/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.jca.vault.provider.keystore;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreSpi;
import java.security.cert.Certificate;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import org.honton.chas.jca.vault.provider.keygen.VaultKeyFactory;
import org.honton.chas.vault.api.VaultApi;
import org.honton.chas.vault.api.VaultClient;

public class VaultKeyStore
extends KeyStoreSpi {
    private static <T> T noSupportForCertificates() {
        throw new UnsupportedOperationException("No support for certificates");
    }

    private static <T> T noSupportForUpdate() {
        throw new UnsupportedOperationException("No support for update or delete");
    }

    protected VaultApi getVaultInstance() {
        return VaultClient.INSTANCE;
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.getVaultInstance().listKeys());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.getVaultInstance().readKey(alias) != null;
    }

    @Override
    public int engineSize() {
        return this.getVaultInstance().listKeys().size();
    }

    @Override
    public Key engineGetKey(String alias, char[] password) {
        Map<String, Object> result = this.getVaultInstance().readKey(alias);
        if (result == null) {
            return null;
        }
        return VaultKeyFactory.wrapPublicKey(alias, result);
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] chars) {
    }

    @Override
    public Certificate[] engineGetCertificateChain(String s) {
        return (Certificate[])VaultKeyStore.noSupportForCertificates();
    }

    @Override
    public Certificate engineGetCertificate(String s) {
        return (Certificate)VaultKeyStore.noSupportForCertificates();
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        Map<String, Object> result = this.getVaultInstance().readKey(alias);
        if (result == null) {
            return null;
        }
        Map.Entry<String, Map<String, String>> latestKey = VaultKeyFactory.latestKey(result);
        return Date.from(Instant.parse((CharSequence)VaultClient.walkPath(latestKey.getValue(), "creation_time")));
    }

    @Override
    public void engineSetKeyEntry(String s, Key key, char[] chars, Certificate[] certificates) {
        VaultKeyStore.noSupportForUpdate();
    }

    @Override
    public void engineSetKeyEntry(String s, byte[] bytes, Certificate[] certificates) {
        VaultKeyStore.noSupportForUpdate();
    }

    @Override
    public void engineSetCertificateEntry(String s, Certificate certificate) {
        VaultKeyStore.noSupportForCertificates();
    }

    @Override
    public void engineDeleteEntry(String s) {
        VaultKeyStore.noSupportForUpdate();
    }

    @Override
    public boolean engineIsKeyEntry(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean engineIsCertificateEntry(String s) {
        return (Boolean)VaultKeyStore.noSupportForCertificates();
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        return (String)VaultKeyStore.noSupportForCertificates();
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] chars) {
        throw new UnsupportedOperationException("No support for export");
    }
}

