/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.jca.vault.provider.keygen;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import lombok.Generated;
import org.honton.chas.jca.vault.provider.VaultPublicKey;
import org.honton.chas.jca.vault.provider.keygen.Pkcs8;
import org.honton.chas.jca.vault.provider.signature.ecdsa.VaultEcdsaPrivateKey;
import org.honton.chas.jca.vault.provider.signature.ecdsa.VaultEcdsaPublicKey;
import org.honton.chas.jca.vault.provider.signature.rsa.VaultRsaPrivateKey;
import org.honton.chas.jca.vault.provider.signature.rsa.VaultRsaPublicKey;
import org.honton.chas.vault.api.VaultClient;

public final class VaultKeyFactory {
    static KeyPair createKeyPair(String name, Map<String, Object> result) {
        return VaultKeyFactory.wrapKeyPair(name, result);
    }

    public static Key wrapPrivateKey(String name, Map<String, Object> result) {
        return VaultKeyFactory.wrapKeyPair(name, result).getPrivate();
    }

    private static KeyPair wrapKeyPair(String name, Map<String, Object> result) {
        VaultPublicKey publicKey = VaultKeyFactory.wrapPublicKey(name, result);
        PrivateKey privateKey = VaultKeyFactory.wrapPrivateKey(publicKey);
        return new KeyPair(publicKey, privateKey);
    }

    public static VaultPublicKey wrapPublicKey(String name, Map<String, Object> result) {
        Map.Entry<String, Map<String, String>> latestKey = VaultKeyFactory.latestKey(result);
        PublicKey publicKey = VaultKeyFactory.getPublicKey(latestKey.getValue());
        int version = Integer.parseInt(latestKey.getKey());
        String type = (String)VaultClient.walkPath(result, "type");
        if (type.startsWith("rsa-")) {
            return new VaultRsaPublicKey(name, version, (RSAPublicKey)publicKey);
        }
        if (type.startsWith("ecdsa-")) {
            return new VaultEcdsaPublicKey(name, version, (ECPublicKey)publicKey);
        }
        throw new UnsupportedOperationException("Unsupported key type " + type);
    }

    private static PrivateKey wrapPrivateKey(VaultPublicKey publicKey) {
        if (publicKey instanceof VaultRsaPublicKey) {
            return new VaultRsaPrivateKey(publicKey.getName(), publicKey.getVersion());
        }
        if (publicKey instanceof VaultEcdsaPublicKey) {
            return new VaultEcdsaPrivateKey(publicKey.getName(), publicKey.getVersion(), ((VaultEcdsaPublicKey)publicKey).getParams());
        }
        throw new UnsupportedOperationException("Unsupported key type ");
    }

    public static Map.Entry<String, Map<String, String>> latestKey(Map<String, Object> result) {
        Map keys = (Map)VaultClient.walkPath(result, "keys");
        return (Map.Entry)keys.entrySet().stream().reduce(VaultKeyFactory::max).orElseThrow();
    }

    private static Map.Entry<String, Map<String, String>> max(Map.Entry<String, Map<String, String>> l, Map.Entry<String, Map<String, String>> r) {
        return Integer.parseInt(l.getKey()) > Integer.parseInt(r.getKey()) ? l : r;
    }

    private static PublicKey getPublicKey(Map<String, String> key) {
        return Pkcs8.getPublicKeyFromString(key.get("public_key"));
    }

    @Generated
    private VaultKeyFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

