/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.jca.vault.provider.signature;

import java.beans.ConstructorProperties;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import lombok.Generated;
import org.honton.chas.jca.vault.provider.keygen.VaultParameterSpec;
import org.honton.chas.jca.vault.provider.keygen.ecdsa.VaultEcdsaKeyAlgorithm;
import org.honton.chas.jca.vault.provider.keygen.rsa.VaultRsaKeyType;

public enum SignatureAlgorithm {
    RSASSA_PSS_SHA_256,
    RSASSA_PSS_SHA_384,
    RSASSA_PSS_SHA_512,
    RSASSA_PKCS_SHA_256,
    RSASSA_PKCS_SHA_384,
    RSASSA_PKCS_SHA_512,
    ECDSA_SHA_256,
    ECDSA_SHA_384,
    ECDSA_SHA_512;

    private final KeyAlgorithm keyAlgorithm;
    private final String shaSize;

    private SignatureAlgorithm() {
        String name = this.name();
        this.keyAlgorithm = SignatureAlgorithm.keyAlgorithm(name);
        this.shaSize = SignatureAlgorithm.getShaSize(name);
    }

    private static KeyAlgorithm keyAlgorithm(String name) {
        if (name.startsWith("RSASSA_PSS_")) {
            return KeyAlgorithm.RSASSA_PSS;
        }
        if (name.startsWith("RSASSA_PKCS_")) {
            return KeyAlgorithm.RSASSA_PKCS;
        }
        return KeyAlgorithm.ECDSA;
    }

    private static String getShaSize(String name) {
        return name.substring(name.indexOf("SHA_") + 4);
    }

    public String getJcaKeyAlgorithm() {
        return this.keyAlgorithm.getJcaKeyAlgorithm();
    }

    public String getJcaSignatureAlgorithm() {
        return this.keyAlgorithm.jcaSignatureAlgorithm(this.shaSize);
    }

    public AlgorithmParameterSpec getJcaParameterSpec() {
        return this.keyAlgorithm.jcaParameterSpec("SHA-" + this.shaSize);
    }

    public String getVaultHashAlgorithm() {
        return "sha2-" + this.shaSize;
    }

    public VaultParameterSpec getVaultKeyAlgorithm() {
        return this.keyAlgorithm.vaultKeyAlgorithm(this.shaSize);
    }

    public String getVaultSignatureAlgorithm() {
        return this.keyAlgorithm.getVaultSignatureAlgorithm();
    }

    static enum KeyAlgorithm {
        RSASSA_PKCS("RSA", "pkcs1v15"),
        RSASSA_PSS("RSASSA-PSS", "pss"){

            @Override
            String jcaSignatureAlgorithm(String shaSize) {
                return super.jcaSignatureAlgorithm(shaSize) + "andMGF1";
            }

            @Override
            PSSParameterSpec jcaParameterSpec(String mdName) {
                switch (mdName) {
                    case "SHA-256": {
                        return new PSSParameterSpec(mdName, "MGF1", MGF1ParameterSpec.SHA256, 32, 1);
                    }
                    case "SHA-384": {
                        return new PSSParameterSpec(mdName, "MGF1", MGF1ParameterSpec.SHA384, 48, 1);
                    }
                    case "SHA-512": {
                        return new PSSParameterSpec(mdName, "MGF1", MGF1ParameterSpec.SHA512, 64, 1);
                    }
                }
                throw new UnsupportedOperationException(mdName);
            }
        }
        ,
        ECDSA("EC", null){

            @Override
            String jcaSignatureAlgorithm(String shaSize) {
                return "SHA" + shaSize + "withECDSA";
            }

            @Override
            VaultParameterSpec vaultKeyAlgorithm(String shaSize) {
                switch (shaSize) {
                    case "256": {
                        return VaultEcdsaKeyAlgorithm.ECDSA_P256;
                    }
                    case "384": {
                        return VaultEcdsaKeyAlgorithm.ECDSA_P384;
                    }
                    case "512": {
                        return VaultEcdsaKeyAlgorithm.ECDSA_P521;
                    }
                }
                throw new UnsupportedOperationException(shaSize);
            }
        };

        private final String jcaKeyAlgorithm;
        private final String vaultSignatureAlgorithm;

        String jcaSignatureAlgorithm(String shaSize) {
            return "SHA" + shaSize + "withRSA";
        }

        AlgorithmParameterSpec jcaParameterSpec(String mdName) {
            return null;
        }

        VaultParameterSpec vaultKeyAlgorithm(String shaSize) {
            switch (shaSize) {
                case "256": {
                    return VaultRsaKeyType.RSA_2048;
                }
                case "384": {
                    return VaultRsaKeyType.RSA_3072;
                }
                case "512": {
                    return VaultRsaKeyType.RSA_4096;
                }
            }
            throw new UnsupportedOperationException(shaSize);
        }

        @ConstructorProperties(value={"jcaKeyAlgorithm", "vaultSignatureAlgorithm"})
        @Generated
        private KeyAlgorithm(String jcaKeyAlgorithm, String vaultSignatureAlgorithm) {
            this.jcaKeyAlgorithm = jcaKeyAlgorithm;
            this.vaultSignatureAlgorithm = vaultSignatureAlgorithm;
        }

        @Generated
        public String getJcaKeyAlgorithm() {
            return this.jcaKeyAlgorithm;
        }

        @Generated
        public String getVaultSignatureAlgorithm() {
            return this.vaultSignatureAlgorithm;
        }
    }
}

