/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.jca.vault.provider.signature;

import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureSpi;
import org.honton.chas.jca.vault.provider.VaultPrivateKey;
import org.honton.chas.jca.vault.provider.VaultPublicKey;
import org.honton.chas.jca.vault.provider.signature.SignatureAlgorithm;
import org.honton.chas.vault.api.VaultApi;
import org.honton.chas.vault.api.VaultClient;

public class VaultSignature
extends SignatureSpi {
    private final SignatureAlgorithm signatureAlgorithm;
    private final ByteBuffer data;
    private VaultPublicKey vaultPublicKey;
    private VaultPrivateKey vaultPrivateKey;

    public VaultSignature(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.data = ByteBuffer.allocate(4000);
    }

    protected VaultApi getVaultInstance() {
        return VaultClient.INSTANCE;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) {
        this.vaultPublicKey = (VaultPublicKey)publicKey;
        this.data.clear();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) {
        this.vaultPrivateKey = (VaultPrivateKey)privateKey;
        this.data.clear();
    }

    @Override
    protected void engineUpdate(byte b) {
        this.data.put(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) {
        this.data.put(b, off, len);
    }

    @Override
    protected byte[] engineSign() {
        return this.getVaultInstance().signData(this.vaultPrivateKey.getName(), this.vaultPrivateKey.getVersion(), this.signatureAlgorithm.getVaultSignatureAlgorithm(), this.signatureAlgorithm.getVaultHashAlgorithm(), this.data.flip());
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) {
        return this.getVaultInstance().verifySignedData(this.vaultPublicKey.getName(), this.vaultPublicKey.getVersion(), this.signatureAlgorithm.getVaultSignatureAlgorithm(), this.signatureAlgorithm.getVaultHashAlgorithm(), this.data.flip(), sigBytes);
    }

    @Override
    protected void engineSetParameter(String s, Object o) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }
}

