/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.vault.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.honton.chas.vault.api.VaultApi;

public class VaultClient
implements VaultApi {
    private static final String VAULT_PREFIX = "vault:v";
    private static final int VAULT_PREFIX_LENGTH = "vault:v".length();
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer ";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().findAndRegisterModules();
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();
    public static VaultClient INSTANCE = new VaultClient(VaultClient.getEnvOrProperty("VAULT_ADDR"), () -> VaultClient.getEnvOrProperty("VAULT_TOKEN"));
    private final String vaultAddress;
    private final Supplier<String> vaultTokenSupplier;

    static void setVaultInstance(String vaultAddress, Supplier<String> vaultToken) {
        INSTANCE = new VaultClient(vaultAddress, vaultToken);
    }

    private static String getEnvOrProperty(String name) {
        String value = System.getenv(name);
        return value == null || value.isEmpty() ? System.getProperty(name) : value;
    }

    private static String encodeUrl(String name) {
        return URLEncoder.encode(name, StandardCharsets.US_ASCII).replace("+", "%20");
    }

    private static HttpRequest.BodyPublisher getBodyPublisher(Object request) {
        return HttpRequest.BodyPublishers.ofString(OBJECT_MAPPER.writeValueAsString(request));
    }

    private static String base64Encode(ByteBuffer data) {
        ByteBuffer encoded = Base64.getMimeEncoder().encode(data);
        return StandardCharsets.ISO_8859_1.decode(encoded).toString();
    }

    private static String base64Encode(byte[] predigested) {
        return new String(Base64.getMimeEncoder().encode(predigested), StandardCharsets.ISO_8859_1);
    }

    private static byte[] base64Decode(String data) {
        return Base64.getMimeDecoder().decode(data);
    }

    public static <T> T walkPath(Object result, String ... pathSegments) {
        for (String pathSegment : pathSegments) {
            result = ((Map)result).get(pathSegment);
        }
        return (T)result;
    }

    private <T> T send(HttpRequest.Builder builder, String url, String ... pathSegments) {
        if (this.vaultAddress == null) {
            throw new IllegalStateException("Set VAULT_ADDR environment or System property or invoke VaultApi.setVaultInstance()");
        }
        String vaultToken = this.vaultTokenSupplier.get();
        if (vaultToken == null) {
            throw new IllegalStateException("Set VAULT_TOKEN environment or System property or invoke VaultApi.setVaultInstance()");
        }
        URI uri = URI.create(this.vaultAddress + url);
        HttpResponse<String> response = HTTP_CLIENT.send(builder.uri(uri).header(CONTENT_TYPE, APPLICATION_JSON).header(AUTHORIZATION, BEARER + vaultToken).build(), HttpResponse.BodyHandlers.ofString());
        if (200 > response.statusCode() || response.statusCode() > 300) {
            if (response.statusCode() == 404) {
                return null;
            }
            throw new IOException(response.statusCode() + " : " + response.body());
        }
        String body = response.body();
        if (body.isEmpty()) {
            return null;
        }
        Object result = OBJECT_MAPPER.readValue(body, Map.class);
        return VaultClient.walkPath(result, pathSegments);
    }

    private <T> T post(String url, Object request, String ... pathSegments) {
        return this.send(HttpRequest.newBuilder().POST(VaultClient.getBodyPublisher(request)), url, pathSegments);
    }

    @Override
    public List<String> listKeys() {
        HttpRequest.Builder request = HttpRequest.newBuilder().method("LIST", HttpRequest.BodyPublishers.noBody());
        List<String> list = (List<String>)this.send(request, "/v1/transit/keys", "data", "keys");
        return list != null ? list : List.of();
    }

    @Override
    public void createKey(String name, String keyType, String autoRotationPeriod) {
        this.post("/v1/transit/keys/" + VaultClient.encodeUrl(name), Map.of("type", keyType, "duration", autoRotationPeriod), new String[0]);
    }

    @Override
    public Map<String, Object> readKey(String name) {
        String url = "/v1/transit/keys/" + VaultClient.encodeUrl(name);
        return (Map)this.send(HttpRequest.newBuilder().GET(), url, "data");
    }

    @Override
    public byte[] signData(String name, int version, String signatureAlgorithm, String hashAlgorithm, ByteBuffer data) {
        String input = VaultClient.base64Encode(data);
        Map<String, String> body = signatureAlgorithm != null ? Map.of("input", input, "signature_algorithm", signatureAlgorithm, "salt_length", "hash") : Map.of("input", input, "salt_length", "hash");
        String signature = (String)this.post("/v1/transit/sign/" + VaultClient.encodeUrl(name) + "/" + hashAlgorithm, body, "data", "signature");
        String interesting = this.extractSignature(signature);
        return VaultClient.base64Decode(interesting);
    }

    private String extractSignature(String signature) {
        int last = signature.length();
        while (signature.charAt(last - 1) == '=') {
            --last;
        }
        return signature.substring(signature.indexOf(58, VAULT_PREFIX_LENGTH) + 1, last);
    }

    @Override
    public boolean verifySignedData(String name, int version, String sa, String hashAlgorithm, ByteBuffer data, byte[] signature) {
        String in = VaultClient.base64Encode(data);
        String vs = VAULT_PREFIX + version + ":" + VaultClient.base64Encode(signature);
        Map<String, String> body = sa != null ? Map.of("input", in, "signature", vs, "signature_algorithm", sa, "salt_length", "hash") : Map.of("input", in, "signature", vs, "salt_length", "hash");
        return (Boolean)this.post("/v1/transit/verify/" + VaultClient.encodeUrl(name) + "/" + hashAlgorithm, body, "data", "valid");
    }

    @ConstructorProperties(value={"vaultAddress", "vaultTokenSupplier"})
    @Generated
    public VaultClient(String vaultAddress, Supplier<String> vaultTokenSupplier) {
        this.vaultAddress = vaultAddress;
        this.vaultTokenSupplier = vaultTokenSupplier;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaultClient)) {
            return false;
        }
        VaultClient other = (VaultClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$vaultAddress = this.vaultAddress;
        String other$vaultAddress = other.vaultAddress;
        if (this$vaultAddress == null ? other$vaultAddress != null : !this$vaultAddress.equals(other$vaultAddress)) {
            return false;
        }
        Supplier<String> this$vaultTokenSupplier = this.vaultTokenSupplier;
        Supplier<String> other$vaultTokenSupplier = other.vaultTokenSupplier;
        return !(this$vaultTokenSupplier == null ? other$vaultTokenSupplier != null : !this$vaultTokenSupplier.equals(other$vaultTokenSupplier));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VaultClient;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $vaultAddress = this.vaultAddress;
        result = result * 59 + ($vaultAddress == null ? 43 : $vaultAddress.hashCode());
        Supplier<String> $vaultTokenSupplier = this.vaultTokenSupplier;
        result = result * 59 + ($vaultTokenSupplier == null ? 43 : $vaultTokenSupplier.hashCode());
        return result;
    }
}

