/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.properties;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="write", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class WriteYaml
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Parameter(property="yaml.filename", required=true)
    String filename;
    @Parameter(property="yaml.path", required=true)
    String path;
    @Parameter
    Map<String, String> values;
    @Parameter(property="yaml.skip")
    boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        Path buildDirectory = Path.of(this.project.getBuild().getDirectory(), new String[0]);
        Path location = buildDirectory.resolve(this.filename);
        try {
            Files.createDirectories(location.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.writeYaml(location, this.getPrefixedValues());
    }

    private Map<String, ?> getPrefixedValues() {
        Map<String, Object> prefixedValues = this.values;
        if (this.path != null) {
            String[] segments = this.path.split("\\.");
            int i = segments.length;
            while (--i >= 0) {
                prefixedValues = Map.of(segments[i], prefixedValues);
            }
        }
        return prefixedValues;
    }

    private void writeYaml(Path location, Map<String, ?> prefixedValues) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Saving " + location));
        try (BufferedWriter bw = Files.newBufferedWriter(location, new OpenOption[0]);){
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setPrettyFlow(true);
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
            new Yaml(dumperOptions).dump(prefixedValues, (Writer)bw);
            this.getLog().debug((CharSequence)("Saved " + location));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write " + location, (Exception)e);
        }
    }
}

