/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.zookeeper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;

public class ZkUrlConnection
extends URLConnection {
    private static final int SESSION_TIMEOUT = (int)TimeUnit.MINUTES.toMillis(5L);
    private ZooKeeper zooKeeper;

    protected ZkUrlConnection(URL url) {
        super(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        ZkUrlConnection zkUrlConnection = this;
        synchronized (zkUrlConnection) {
            if (!this.connected) {
                this.connected = true;
                this.zooKeeper = new ZooKeeper(this.getConnectString(), SESSION_TIMEOUT, null);
            }
        }
    }

    private String getConnectString() {
        return this.url.getHost() + ':' + (this.url.getPort() < 0 ? this.url.getDefaultPort() : this.url.getPort());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        byte[] data = new byte[]{};
        try {
            data = this.zooKeeper.getData(this.url.getPath(), false, null);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(e);
            throw iie;
        }
        return new ByteArrayInputStream(data);
    }
}

