/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.proton.exceptions;

import org.hornetq.api.core.HornetQException;

public class HornetQAMQPException
extends HornetQException {
    private static final String ERROR_PREFIX = "amqp:";
    private final AmqpError amqpError;

    public String getAmqpError() {
        return this.amqpError.getError();
    }

    public HornetQAMQPException(AmqpError amqpError, String message) {
        super(message);
        this.amqpError = amqpError;
    }

    public static enum AmqpError {
        INTERNAL_ERROR("internal-error"),
        NOT_FOUND("not-found"),
        UNAUTHORIZED_ACCESS("unuathorized-access"),
        DECODE_ERROR("decode-error"),
        RESOURCE_LIMIT_EXCEEDED("resource-limit-exceeded"),
        NOT_ALLOWED("not-allowed"),
        INVALID_FIELD("invalid-field"),
        NOT_IMPLEMENTED("not-implemented"),
        RESOURCE_LOCKED("resource-locked"),
        PRECONDITIONS_FAILED("preconditions-failed"),
        RESOURCE_DELETED("resource-deleted"),
        ILLEGAL_STATE("illegal-state"),
        FRAME_SIZE_TOO_SMALL("frame-size-too-small");

        private final String error;

        private AmqpError(String error) {
            this.error = error;
        }

        public String getError() {
            return HornetQAMQPException.ERROR_PREFIX + this.error;
        }
    }
}

