/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.buffers.impl;

import java.nio.ByteBuffer;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.utils.UTF8Util;
import org.jboss.netty.buffer.ChannelBuffer;

public class ChannelBufferWrapper
implements HornetQBuffer {
    protected ChannelBuffer buffer;

    public ChannelBufferWrapper(ChannelBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public SimpleString readNullableSimpleString() {
        byte b = this.buffer.readByte();
        if (b == 0) {
            return null;
        }
        return this.readSimpleStringInternal();
    }

    @Override
    public String readNullableString() {
        byte b = this.buffer.readByte();
        if (b == 0) {
            return null;
        }
        return this.readStringInternal();
    }

    @Override
    public SimpleString readSimpleString() {
        return this.readSimpleStringInternal();
    }

    private SimpleString readSimpleStringInternal() {
        int len = this.buffer.readInt();
        byte[] data = new byte[len];
        this.buffer.readBytes(data);
        return new SimpleString(data);
    }

    @Override
    public String readString() {
        return this.readStringInternal();
    }

    private String readStringInternal() {
        int len = this.buffer.readInt();
        if (len < 9) {
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)this.buffer.readShort();
            }
            return new String(chars);
        }
        if (len < 4095) {
            return this.readUTF();
        }
        return this.readSimpleStringInternal().toString();
    }

    @Override
    public String readUTF() {
        return UTF8Util.readUTF(this);
    }

    @Override
    public void writeBoolean(boolean val) {
        this.buffer.writeByte((int)((byte)(val ? -1 : 0)));
    }

    @Override
    public void writeNullableSimpleString(SimpleString val) {
        if (val == null) {
            this.buffer.writeByte(0);
        } else {
            this.buffer.writeByte(1);
            this.writeSimpleStringInternal(val);
        }
    }

    @Override
    public void writeNullableString(String val) {
        if (val == null) {
            this.buffer.writeByte(0);
        } else {
            this.buffer.writeByte(1);
            this.writeStringInternal(val);
        }
    }

    @Override
    public void writeSimpleString(SimpleString val) {
        this.writeSimpleStringInternal(val);
    }

    private void writeSimpleStringInternal(SimpleString val) {
        byte[] data = val.getData();
        this.buffer.writeInt(data.length);
        this.buffer.writeBytes(data);
    }

    @Override
    public void writeString(String val) {
        this.writeStringInternal(val);
    }

    private void writeStringInternal(String val) {
        int length = val.length();
        this.buffer.writeInt(length);
        if (length < 9) {
            for (int i = 0; i < val.length(); ++i) {
                this.buffer.writeShort((int)((short)val.charAt(i)));
            }
        } else if (length < 4095) {
            this.writeUTF(val);
        } else {
            this.writeSimpleStringInternal(new SimpleString(val));
        }
    }

    @Override
    public void writeUTF(String utf) {
        UTF8Util.saveUTF(this, utf);
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public ChannelBuffer channelBuffer() {
        return this.buffer;
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public HornetQBuffer copy() {
        return new ChannelBufferWrapper(this.buffer.copy());
    }

    @Override
    public HornetQBuffer copy(int index, int length) {
        return new ChannelBufferWrapper(this.buffer.copy(index, length));
    }

    @Override
    public void discardReadBytes() {
        this.buffer.discardReadBytes();
    }

    @Override
    public HornetQBuffer duplicate() {
        return new ChannelBufferWrapper(this.buffer.duplicate());
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        this.buffer.getBytes(index, dst);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
    }

    @Override
    public void getBytes(int index, HornetQBuffer dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst.channelBuffer(), dstIndex, length);
    }

    @Override
    public void getBytes(int index, HornetQBuffer dst, int length) {
        this.buffer.getBytes(index, dst.channelBuffer(), length);
    }

    @Override
    public void getBytes(int index, HornetQBuffer dst) {
        this.buffer.getBytes(index, dst.channelBuffer());
    }

    @Override
    public char getChar(int index) {
        return (char)this.buffer.getShort(index);
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.buffer.getLong(index));
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.buffer.getInt(index));
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public short getUnsignedByte(int index) {
        return this.buffer.getUnsignedByte(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        return this.buffer.getUnsignedInt(index);
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.buffer.getUnsignedShort(index);
    }

    @Override
    public void markReaderIndex() {
        this.buffer.markReaderIndex();
    }

    @Override
    public void markWriterIndex() {
        this.buffer.markWriterIndex();
    }

    @Override
    public boolean readable() {
        return this.buffer.readable();
    }

    @Override
    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    @Override
    public byte readByte() {
        return this.buffer.readByte();
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
    }

    @Override
    public void readBytes(byte[] dst) {
        this.buffer.readBytes(dst);
    }

    @Override
    public void readBytes(ByteBuffer dst) {
        this.buffer.readBytes(dst);
    }

    @Override
    public void readBytes(HornetQBuffer dst, int dstIndex, int length) {
        this.buffer.readBytes(dst.channelBuffer(), dstIndex, length);
    }

    @Override
    public void readBytes(HornetQBuffer dst, int length) {
        this.buffer.readBytes(dst.channelBuffer(), length);
    }

    @Override
    public void readBytes(HornetQBuffer dst) {
        this.buffer.readBytes(dst.channelBuffer());
    }

    @Override
    public HornetQBuffer readBytes(int length) {
        return new ChannelBufferWrapper(this.buffer.readBytes(length));
    }

    @Override
    public char readChar() {
        return (char)this.buffer.readShort();
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.buffer.readLong());
    }

    @Override
    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    @Override
    public void readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.buffer.readInt());
    }

    @Override
    public int readInt() {
        return this.buffer.readInt();
    }

    @Override
    public long readLong() {
        return this.buffer.readLong();
    }

    @Override
    public short readShort() {
        return this.buffer.readShort();
    }

    @Override
    public HornetQBuffer readSlice(int length) {
        return new ChannelBufferWrapper(this.buffer.readSlice(length));
    }

    @Override
    public short readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    @Override
    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    @Override
    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    @Override
    public void resetReaderIndex() {
        this.buffer.resetReaderIndex();
    }

    @Override
    public void resetWriterIndex() {
        this.buffer.resetWriterIndex();
    }

    @Override
    public void setByte(int index, byte value) {
        this.buffer.setByte(index, (int)value);
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
    }

    @Override
    public void setBytes(int index, byte[] src) {
        this.buffer.setBytes(index, src);
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        this.buffer.setBytes(index, src);
    }

    @Override
    public void setBytes(int index, HornetQBuffer src, int srcIndex, int length) {
        this.buffer.setBytes(index, src.channelBuffer(), srcIndex, length);
    }

    @Override
    public void setBytes(int index, HornetQBuffer src, int length) {
        this.buffer.setBytes(index, src.channelBuffer(), length);
    }

    @Override
    public void setBytes(int index, HornetQBuffer src) {
        this.buffer.setBytes(index, src.channelBuffer());
    }

    @Override
    public void setChar(int index, char value) {
        this.buffer.setShort(index, (int)((short)value));
    }

    @Override
    public void setDouble(int index, double value) {
        this.buffer.setLong(index, Double.doubleToLongBits(value));
    }

    @Override
    public void setFloat(int index, float value) {
        this.buffer.setInt(index, Float.floatToIntBits(value));
    }

    @Override
    public void setIndex(int readerIndex, int writerIndex) {
        this.buffer.setIndex(readerIndex, writerIndex);
    }

    @Override
    public void setInt(int index, int value) {
        this.buffer.setInt(index, value);
    }

    @Override
    public void setLong(int index, long value) {
        this.buffer.setLong(index, value);
    }

    @Override
    public void setShort(int index, short value) {
        this.buffer.setShort(index, (int)value);
    }

    @Override
    public void skipBytes(int length) {
        this.buffer.skipBytes(length);
    }

    @Override
    public HornetQBuffer slice() {
        return new ChannelBufferWrapper(this.buffer.slice());
    }

    @Override
    public HornetQBuffer slice(int index, int length) {
        return new ChannelBufferWrapper(this.buffer.slice(index, length));
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.buffer.toByteBuffer();
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        return this.buffer.toByteBuffer(index, length);
    }

    @Override
    public boolean writable() {
        return this.buffer.writable();
    }

    @Override
    public int writableBytes() {
        return this.buffer.writableBytes();
    }

    @Override
    public void writeByte(byte value) {
        this.buffer.writeByte((int)value);
    }

    @Override
    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
    }

    @Override
    public void writeBytes(byte[] src) {
        this.buffer.writeBytes(src);
    }

    @Override
    public void writeBytes(ByteBuffer src) {
        this.buffer.writeBytes(src);
    }

    @Override
    public void writeBytes(HornetQBuffer src, int srcIndex, int length) {
        this.buffer.writeBytes(src.channelBuffer(), srcIndex, length);
    }

    @Override
    public void writeBytes(HornetQBuffer src, int length) {
        this.buffer.writeBytes(src.channelBuffer(), length);
    }

    @Override
    public void writeChar(char chr) {
        this.buffer.writeShort((int)((short)chr));
    }

    @Override
    public void writeDouble(double value) {
        this.buffer.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeFloat(float value) {
        this.buffer.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeInt(int value) {
        this.buffer.writeInt(value);
    }

    @Override
    public void writeLong(long value) {
        this.buffer.writeLong(value);
    }

    @Override
    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    @Override
    public void writerIndex(int writerIndex) {
        this.buffer.writerIndex(writerIndex);
    }

    @Override
    public void writeShort(short value) {
        this.buffer.writeShort((int)value);
    }
}

