/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.util.ArrayList;
import java.util.Iterator;

public class SelectorTranslator {
    public static String convertToHornetQFilterString(String selectorString) {
        if (selectorString == null) {
            return null;
        }
        String filterString = SelectorTranslator.parse(selectorString, "JMSDeliveryMode", "HQDurable");
        filterString = SelectorTranslator.parse(filterString, "'PERSISTENT'", "'DURABLE'");
        filterString = SelectorTranslator.parse(filterString, "'NON_PERSISTENT'", "'NON_DURABLE'");
        filterString = SelectorTranslator.parse(filterString, "JMSPriority", "HQPriority");
        filterString = SelectorTranslator.parse(filterString, "JMSTimestamp", "HQTimestamp");
        return filterString;
    }

    private static String parse(String input, String match, String replace) {
        int quote = 39;
        boolean inQuote = false;
        int matchPos = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        boolean replaceInQuotes = match.charAt(0) == '\'';
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\'') {
                boolean bl = inQuote = !inQuote;
            }
            if ((!inQuote || replaceInQuotes) && c == match.charAt(matchPos)) {
                int posBeforeStart;
                if (++matchPos != match.length()) continue;
                boolean matched = true;
                if (i < input.length() - 1 && Character.isJavaIdentifierPart(input.charAt(i + 1))) {
                    matched = false;
                }
                if ((posBeforeStart = i - match.length()) >= 0 && Character.isJavaIdentifierPart(input.charAt(posBeforeStart))) {
                    matched = false;
                }
                if (matched) {
                    positions.add(i - match.length() + 1);
                }
                matchPos = 0;
                continue;
            }
            matchPos = 0;
        }
        if (!positions.isEmpty()) {
            StringBuffer buff = new StringBuffer();
            int startPos = 0;
            Iterator i$ = positions.iterator();
            while (i$.hasNext()) {
                int pos = (Integer)i$.next();
                String substr = input.substring(startPos, pos);
                buff.append(substr);
                buff.append(replace);
                startPos = pos + match.length();
            }
            if (startPos < input.length()) {
                buff.append(input.substring(startPos, input.length()));
            }
            return buff.toString();
        }
        return input;
    }
}

