/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.jms;

import java.util.List;
import javax.jms.Queue;
import javax.jms.Topic;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.HornetQDestination;

public class HornetQJMSClient {
    private static final Logger log = Logger.getLogger(HornetQJMSClient.class);

    public static HornetQConnectionFactory createConnectionFactory() {
        return new HornetQConnectionFactory();
    }

    public static HornetQConnectionFactory createConnectionFactory(ClientSessionFactory sessionFactory) {
        return new HornetQConnectionFactory(sessionFactory);
    }

    public static HornetQConnectionFactory createConnectionFactory(String discoveryAddress, int discoveryPort) {
        return new HornetQConnectionFactory(discoveryAddress, discoveryPort);
    }

    public static HornetQConnectionFactory createConnectionFactory(List<Pair<TransportConfiguration, TransportConfiguration>> staticConnectors) {
        return new HornetQConnectionFactory(staticConnectors);
    }

    public static HornetQConnectionFactory createConnectionFactory(TransportConfiguration connectorConfig, TransportConfiguration backupConnectorConfig) {
        return new HornetQConnectionFactory(connectorConfig, backupConnectorConfig);
    }

    public static HornetQConnectionFactory createConnectionFactory(TransportConfiguration connectorConfig) {
        return new HornetQConnectionFactory(connectorConfig);
    }

    public static Topic createTopic(String name) {
        return HornetQDestination.createTopic(name);
    }

    public static Queue createQueue(String name) {
        return HornetQDestination.createQueue(name);
    }

    private HornetQJMSClient() {
    }
}

