/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.TransactionRolledBackException;
import org.hornetq.api.core.HornetQException;

public class JMSExceptionHelper {
    public static JMSException convertFromHornetQException(HornetQException me) {
        JMSException je;
        switch (me.getCode()) {
            case 3: {
                je = new JMSException(me.getMessage());
                break;
            }
            case 104: {
                je = new IllegalStateException(me.getMessage());
                break;
            }
            case 0: {
                je = new JMSException(me.getMessage());
                break;
            }
            case 103: {
                je = new InvalidSelectorException(me.getMessage());
                break;
            }
            case 2: {
                je = new JMSException(me.getMessage());
                break;
            }
            case 102: {
                je = new IllegalStateException(me.getMessage());
                break;
            }
            case 100: {
                je = new InvalidDestinationException(me.getMessage());
                break;
            }
            case 101: {
                je = new InvalidDestinationException(me.getMessage());
                break;
            }
            case 105: {
                je = new JMSSecurityException(me.getMessage());
                break;
            }
            case 1: {
                je = new IllegalStateException(me.getMessage());
                break;
            }
            case 111: {
                je = new TransactionRolledBackException(me.getMessage());
                break;
            }
            default: {
                je = new JMSException(me.getMessage());
            }
        }
        je.setStackTrace(me.getStackTrace());
        je.initCause((Throwable)me);
        return je;
    }
}

