/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.MessageHandler;
import org.hornetq.jms.HornetQJMSLogger;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.HornetQSession;

public class JMSMessageListenerWrapper
implements MessageHandler {
    private final HornetQSession session;
    private final MessageListener listener;
    private final ClientConsumer consumer;
    private final boolean transactedOrClientAck;

    protected JMSMessageListenerWrapper(HornetQSession session, ClientConsumer consumer, MessageListener listener, int ackMode) {
        this.session = session;
        this.consumer = consumer;
        this.listener = listener;
        this.transactedOrClientAck = ackMode == 0 || ackMode == 2 || session.isXA();
    }

    public void onMessage(ClientMessage message) {
        block13: {
            HornetQMessage msg = HornetQMessage.createMessage(message, this.session.getCoreSession());
            try {
                msg.doBeforeReceive();
            }
            catch (Exception e) {
                HornetQJMSLogger.LOGGER.errorPreparingMessageForReceipt(e);
                return;
            }
            if (this.transactedOrClientAck) {
                try {
                    message.acknowledge();
                }
                catch (HornetQException e) {
                    HornetQJMSLogger.LOGGER.errorProcessingMessage(e);
                }
            }
            try {
                this.listener.onMessage((Message)msg);
            }
            catch (RuntimeException e) {
                HornetQJMSLogger.LOGGER.onMessageError(e);
                if (this.transactedOrClientAck) break block13;
                try {
                    this.session.getCoreSession().rollback(true);
                    this.session.setRecoverCalled(true);
                }
                catch (Exception e2) {
                    HornetQJMSLogger.LOGGER.errorRecoveringSession(e2);
                }
            }
        }
        if (!this.session.isRecoverCalled()) {
            try {
                if (!this.consumer.isClosed() && !this.transactedOrClientAck) {
                    message.acknowledge();
                }
            }
            catch (HornetQException e) {
                HornetQJMSLogger.LOGGER.errorProcessingMessage(e);
            }
        }
        this.session.setRecoverCalled(false);
    }
}

