/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.hornetq.jms.client.HornetQConnectionForContext;
import org.hornetq.jms.client.HornetQJMSConsumer;
import org.hornetq.jms.client.HornetQJMSProducer;
import org.hornetq.jms.client.JmsExceptionUtils;
import org.hornetq.jms.client.ThreadAwareContext;

public class HornetQJMSContext
implements JMSContext {
    private static final boolean DEFAULT_AUTO_START = true;
    private final int sessionMode;
    private final ThreadAwareContext threadAwareContext;
    private volatile Message lastMessagesWaitingAck;
    private final HornetQConnectionForContext connection;
    private Session session;
    private boolean autoStart = true;
    private boolean xa;
    private boolean closed;

    HornetQJMSContext(HornetQConnectionForContext connection, int ackMode, boolean xa, ThreadAwareContext threadAwareContext) {
        this.connection = connection;
        this.sessionMode = ackMode;
        this.xa = xa;
        this.threadAwareContext = threadAwareContext;
    }

    public HornetQJMSContext(HornetQConnectionForContext connection, int ackMode, ThreadAwareContext threadAwareContext) {
        this(connection, ackMode, false, threadAwareContext);
    }

    public HornetQJMSContext(HornetQConnectionForContext connection, ThreadAwareContext threadAwareContext) {
        this(connection, 0, true, threadAwareContext);
    }

    public JMSContext getContext() {
        return this;
    }

    public XAResource getXAResource() {
        this.checkSession();
        return ((XASession)this.session).getXAResource();
    }

    public JMSContext createContext(int sessionMode) {
        return this.connection.createContext(sessionMode);
    }

    public JMSProducer createProducer() {
        this.checkSession();
        try {
            return new HornetQJMSProducer(this, this.session.createProducer(null));
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSession() {
        if (this.session == null) {
            HornetQJMSContext hornetQJMSContext = this;
            synchronized (hornetQJMSContext) {
                if (this.closed) {
                    throw new IllegalStateRuntimeException("Context is closed");
                }
                if (this.session == null) {
                    try {
                        this.session = this.xa ? ((XAConnection)this.connection).createXASession() : this.connection.createSession(this.sessionMode);
                    }
                    catch (JMSException e) {
                        throw JmsExceptionUtils.convertToRuntimeException(e);
                    }
                }
            }
        }
    }

    public String getClientID() {
        try {
            return this.connection.getClientID();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void setClientID(String clientID) {
        try {
            this.connection.setClientID(clientID);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public ConnectionMetaData getMetaData() {
        try {
            return this.connection.getMetaData();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public ExceptionListener getExceptionListener() {
        try {
            return this.connection.getExceptionListener();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void setExceptionListener(ExceptionListener listener) {
        try {
            this.connection.setExceptionListener(listener);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void start() {
        try {
            this.connection.start();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void stop() {
        this.threadAwareContext.assertNotMessageListenerThreadRuntime();
        try {
            this.connection.stop();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.threadAwareContext.assertNotCompletionListenerThreadRuntime();
        this.threadAwareContext.assertNotMessageListenerThreadRuntime();
        try {
            HornetQJMSContext hornetQJMSContext = this;
            synchronized (hornetQJMSContext) {
                if (this.session != null) {
                    this.session.close();
                }
                this.connection.closeFromContext();
                this.closed = true;
            }
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public BytesMessage createBytesMessage() {
        this.checkSession();
        try {
            return this.session.createBytesMessage();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public MapMessage createMapMessage() {
        this.checkSession();
        try {
            return this.session.createMapMessage();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public Message createMessage() {
        this.checkSession();
        try {
            return this.session.createMessage();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public ObjectMessage createObjectMessage() {
        this.checkSession();
        try {
            return this.session.createObjectMessage();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        this.checkSession();
        try {
            return this.session.createObjectMessage(object);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public StreamMessage createStreamMessage() {
        this.checkSession();
        try {
            return this.session.createStreamMessage();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public TextMessage createTextMessage() {
        this.checkSession();
        try {
            return this.session.createTextMessage();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public TextMessage createTextMessage(String text) {
        this.checkSession();
        try {
            return this.session.createTextMessage(text);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public boolean getTransacted() {
        this.checkSession();
        try {
            return this.session.getTransacted();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public int getSessionMode() {
        return this.sessionMode;
    }

    public void commit() {
        this.threadAwareContext.assertNotCompletionListenerThreadRuntime();
        this.checkSession();
        try {
            this.session.commit();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void rollback() {
        this.threadAwareContext.assertNotCompletionListenerThreadRuntime();
        this.checkSession();
        try {
            this.session.rollback();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void recover() {
        this.checkSession();
        try {
            this.session.recover();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createConsumer(Destination destination) {
        this.checkSession();
        try {
            HornetQJMSConsumer consumer = new HornetQJMSConsumer(this, this.session.createConsumer(destination));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        this.checkSession();
        try {
            HornetQJMSConsumer consumer = new HornetQJMSConsumer(this, this.session.createConsumer(destination, messageSelector));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        this.checkSession();
        try {
            HornetQJMSConsumer consumer = new HornetQJMSConsumer(this, this.session.createConsumer(destination, messageSelector, noLocal));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public Queue createQueue(String queueName) {
        this.checkSession();
        try {
            return this.session.createQueue(queueName);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public Topic createTopic(String topicName) {
        this.checkSession();
        try {
            return this.session.createTopic(topicName);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        this.checkSession();
        try {
            HornetQJMSConsumer consumer = new HornetQJMSConsumer(this, this.session.createDurableConsumer(topic, name));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        this.checkSession();
        try {
            HornetQJMSConsumer consumer = new HornetQJMSConsumer(this, this.session.createDurableConsumer(topic, name, messageSelector, noLocal));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        this.checkSession();
        try {
            HornetQJMSConsumer consumer = new HornetQJMSConsumer(this, this.session.createSharedDurableConsumer(topic, name));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        this.checkSession();
        try {
            HornetQJMSConsumer consumer = new HornetQJMSConsumer(this, this.session.createSharedDurableConsumer(topic, name, messageSelector));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        this.checkSession();
        try {
            HornetQJMSConsumer consumer = new HornetQJMSConsumer(this, this.session.createSharedConsumer(topic, sharedSubscriptionName));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        this.checkSession();
        try {
            HornetQJMSConsumer consumer = new HornetQJMSConsumer(this, this.session.createSharedConsumer(topic, sharedSubscriptionName, messageSelector));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public QueueBrowser createBrowser(Queue queue) {
        this.checkSession();
        try {
            QueueBrowser browser = this.session.createBrowser(queue);
            this.checkAutoStart();
            return browser;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        this.checkSession();
        try {
            QueueBrowser browser = this.session.createBrowser(queue, messageSelector);
            this.checkAutoStart();
            return browser;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public TemporaryQueue createTemporaryQueue() {
        this.checkSession();
        try {
            return this.session.createTemporaryQueue();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public TemporaryTopic createTemporaryTopic() {
        this.checkSession();
        try {
            return this.session.createTemporaryTopic();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void unsubscribe(String name) {
        this.checkSession();
        try {
            this.session.unsubscribe(name);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void acknowledge() {
        this.checkSession();
        if (this.closed) {
            throw new IllegalStateRuntimeException("Context is closed");
        }
        try {
            if (this.lastMessagesWaitingAck != null) {
                this.lastMessagesWaitingAck.acknowledge();
            }
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    private synchronized void checkAutoStart() throws JMSException {
        if (this.closed) {
            throw new IllegalStateRuntimeException("Context is closed");
        }
        if (this.autoStart) {
            this.connection.start();
        }
    }

    Message setLastMessage(JMSConsumer consumer, Message lastMessageReceived) {
        if (this.sessionMode == 2) {
            this.lastMessagesWaitingAck = lastMessageReceived;
        }
        return lastMessageReceived;
    }

    public ThreadAwareContext getThreadAwareContext() {
        return this.threadAwareContext;
    }
}

