/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.HornetQInvalidFilterExpressionException;
import org.hornetq.api.core.HornetQNonExistentQueueException;
import org.hornetq.api.core.SimpleString;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="HQ")
public interface HornetQJMSClientBundle {
    public static final HornetQJMSClientBundle BUNDLE = (HornetQJMSClientBundle)Messages.getBundle(HornetQJMSClientBundle.class);

    @Message(id=129000, value="Invalid filter: {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQInvalidFilterExpressionException invalidFilter(@Cause Throwable var1, SimpleString var2);

    @Message(id=129001, value="Invalid Subscription Name. It is required to set the subscription name", format=Message.Format.MESSAGE_FORMAT)
    public HornetQIllegalStateException invalidSubscriptionName();

    @Message(id=129002, value="Destination {0} does not exist", format=Message.Format.MESSAGE_FORMAT)
    public HornetQNonExistentQueueException destinationDoesNotExist(SimpleString var1);

    @Message(id=129003, value="name cannot be null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nameCannotBeNull();

    @Message(id=129004, value="name cannot be empty", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nameCannotBeEmpty();

    @Message(id=129005, value="It is illegal to call this method from within a Message Listener", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateRuntimeException callingMethodFromListenerRuntime();

    @Message(id=129006, value="It is illegal to call this method from within a Message Listener", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException callingMethodFromListener();

    @Message(id=129007, value="It is illegal to call this method from within a Completion Listener", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateRuntimeException callingMethodFromCompletionListenerRuntime();

    @Message(id=129008, value="It is illegal to call this method from within a Completion Listener", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException callingMethodFromCompletionListener();

    @Message(id=129009, value="Null {0} is not allowed", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException nullArgumentNotAllowed(String var1);

    @Message(id=129010, value="Topic (Destination) cannot be null", format=Message.Format.MESSAGE_FORMAT)
    public InvalidDestinationException nullTopic();

    @Message(id=129011, value="LargeMessage streaming is only possible on ByteMessage or StreamMessage", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException onlyValidForByteOrStreamMessages();

    @Message(id=129012, value="The property name ''{0}'' is not a valid java identifier.", format=Message.Format.MESSAGE_FORMAT)
    public JMSRuntimeException invalidJavaIdentifier(String var1);

    @Message(id=129013, value="Message is read-only", format=Message.Format.MESSAGE_FORMAT)
    public MessageNotWriteableException messageNotWritable();

    @Message(id=129014, value="Message is write-only", format=Message.Format.MESSAGE_FORMAT)
    public MessageNotReadableException messageNotReadable();

    @Message(id=129015, value="Illegal deliveryMode value: {0}", format=Message.Format.MESSAGE_FORMAT)
    public JMSException illegalDeliveryMode(int var1);
}

