/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms;

import javax.jms.JMSException;
import javax.jms.Topic;
import org.hornetq.jms.HornetQDestination;
import org.hornetq.utils.Pair;
import org.hornetq.utils.SimpleString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HornetQTopic
extends HornetQDestination
implements Topic {
    private static final long serialVersionUID = 7873614001276404156L;
    public static final String JMS_TOPIC_ADDRESS_PREFIX = "jms.topic.";
    private static final char SEPARATOR = '.';

    public static String createQueueNameForDurableSubscription(String clientID, String subscriptionName) {
        return HornetQTopic.escape(clientID) + '.' + HornetQTopic.escape(subscriptionName);
    }

    public static Pair<String, String> decomposeQueueNameForDurableSubscription(String queueName) {
        StringBuffer[] parts = new StringBuffer[2];
        int currentPart = 0;
        parts[0] = new StringBuffer();
        parts[1] = new StringBuffer();
        int pos = 0;
        while (pos < queueName.length()) {
            char ch = queueName.charAt(pos);
            ++pos;
            if (ch == '.') {
                if (++currentPart < parts.length) continue;
                throw new IllegalArgumentException("Invalid message queue name: " + queueName);
            }
            if (ch == '\\') {
                if (pos >= queueName.length()) {
                    throw new IllegalArgumentException("Invalid message queue name: " + queueName);
                }
                ch = queueName.charAt(pos);
                ++pos;
            }
            parts[currentPart].append(ch);
        }
        if (currentPart != 1) {
            throw new IllegalArgumentException("Invalid message queue name: " + queueName);
        }
        Pair pair = new Pair((Object)parts[0].toString(), (Object)parts[1].toString());
        return pair;
    }

    public static SimpleString createAddressFromName(String name) {
        return new SimpleString(JMS_TOPIC_ADDRESS_PREFIX + name);
    }

    public HornetQTopic(String name) {
        super(JMS_TOPIC_ADDRESS_PREFIX + name, name);
    }

    public HornetQTopic(String address, String name) {
        super(address, name);
    }

    public String getTopicName() throws JMSException {
        return this.name;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    public String toString() {
        return "HornetQTopic[" + this.name + "]";
    }
}

