/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.bridge;

import javax.management.ObjectName;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.jms.bridge.BridgeMBean;
import org.hornetq.jms.bridge.JMSBridge;
import org.hornetq.jms.bridge.QualityOfServiceMode;
import org.hornetq.jms.bridge.impl.JMSBridgeImpl;

public class BridgeService
implements BridgeMBean {
    private static final Logger log = Logger.getLogger(BridgeService.class);
    private JMSBridge bridge = new JMSBridgeImpl();
    private String sourceDestinationLookup;
    private String targetDestinationLookup;
    private ObjectName sourceProviderLoader;
    private ObjectName targetProviderLoader;

    public synchronized ObjectName getSourceProviderLoader() {
        return this.sourceProviderLoader;
    }

    public synchronized void setSourceProviderLoader(ObjectName sourceProvider) {
        if (this.bridge.isStarted()) {
            log.warn((Object)"Cannot set SourceProvider when bridge is started");
            return;
        }
        this.sourceProviderLoader = sourceProvider;
    }

    public synchronized ObjectName getTargetProviderLoader() {
        return this.targetProviderLoader;
    }

    public synchronized void setTargetProviderLoader(ObjectName targetProvider) {
        if (this.bridge.isStarted()) {
            log.warn((Object)"Cannot set TargetProvider when bridge is started");
            return;
        }
        this.targetProviderLoader = targetProvider;
    }

    public String getSourceDestinationLookup() {
        return this.sourceDestinationLookup;
    }

    public String getTargetDestinationLookup() {
        return this.targetDestinationLookup;
    }

    public void setSourceDestinationLookup(String lookup) {
        if (this.bridge.isStarted()) {
            log.warn((Object)"Cannot set SourceDestinationLookup when bridge is started");
            return;
        }
        this.sourceDestinationLookup = this.checkAndTrim(lookup);
    }

    public void setTargetDestinationLookup(String lookup) {
        if (this.bridge.isStarted()) {
            log.warn((Object)"Cannot set TargetDestinationLookup when bridge is started");
            return;
        }
        this.targetDestinationLookup = this.checkAndTrim(lookup);
    }

    public String getSourceUsername() {
        return this.bridge.getSourceUsername();
    }

    public String getSourcePassword() {
        return this.bridge.getSourcePassword();
    }

    public void setSourceUsername(String name) {
        this.bridge.setSourceUsername(name);
    }

    public void setSourcePassword(String pwd) {
        this.bridge.setSourcePassword(pwd);
    }

    public String getTargetUsername() {
        return this.bridge.getTargetUsername();
    }

    public String getTargetPassword() {
        return this.bridge.getTargetPassword();
    }

    public void setTargetUsername(String name) {
        this.bridge.setTargetUsername(name);
    }

    public void setTargetPassword(String pwd) {
        this.bridge.setTargetPassword(pwd);
    }

    public int getQualityOfServiceMode() {
        return this.bridge.getQualityOfServiceMode().intValue();
    }

    public void setQualityOfServiceMode(int mode) {
        this.bridge.setQualityOfServiceMode(QualityOfServiceMode.valueOf(mode));
    }

    public String getSelector() {
        return this.bridge.getSelector();
    }

    public void setSelector(String selector) {
        this.bridge.setSelector(selector);
    }

    public int getMaxBatchSize() {
        return this.bridge.getMaxBatchSize();
    }

    public void setMaxBatchSize(int size) {
        this.bridge.setMaxBatchSize(size);
    }

    public long getMaxBatchTime() {
        return this.bridge.getMaxBatchTime();
    }

    public void setMaxBatchTime(long time) {
        this.bridge.setMaxBatchTime(time);
    }

    public String getSubName() {
        return this.bridge.getSubscriptionName();
    }

    public void setSubName(String subname) {
        this.bridge.setSubscriptionName(subname);
    }

    public String getClientID() {
        return this.bridge.getClientID();
    }

    public void setClientID(String clientID) {
        this.bridge.setClientID(clientID);
    }

    public long getFailureRetryInterval() {
        return this.bridge.getFailureRetryInterval();
    }

    public void setFailureRetryInterval(long interval) {
        this.bridge.setFailureRetryInterval(interval);
    }

    public int getMaxRetries() {
        return this.bridge.getMaxRetries();
    }

    public void setMaxRetries(int retries) {
        this.bridge.setMaxRetries(retries);
    }

    public boolean isAddMessageIDInHeader() {
        return this.bridge.isAddMessageIDInHeader();
    }

    public void setAddMessageIDInHeader(boolean value) {
        this.bridge.setAddMessageIDInHeader(value);
    }

    public boolean isFailed() {
        return this.bridge.isFailed();
    }

    public boolean isPaused() {
        return this.bridge.isPaused();
    }

    public boolean isStarted() {
        return this.bridge.isStarted();
    }

    public HornetQComponent getInstance() {
        return this.bridge;
    }

    public void pause() throws Exception {
        this.bridge.pause();
    }

    public void resume() throws Exception {
        this.bridge.resume();
    }

    protected void startService() throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Starting bridge");
        }
        if (this.sourceProviderLoader == null) {
            throw new IllegalArgumentException("sourceProvider cannot be null");
        }
        if (this.targetProviderLoader == null) {
            throw new IllegalArgumentException("targetProvider cannot be null");
        }
        if (this.sourceDestinationLookup == null) {
            throw new IllegalArgumentException("Source destination lookup cannot be null");
        }
        if (this.targetDestinationLookup == null) {
            throw new IllegalArgumentException("Target destination lookup cannot be null");
        }
        boolean sameSourceAndTarget = this.sourceProviderLoader.equals(this.targetProviderLoader);
    }

    protected void stopService() throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Stopping bridge");
        }
        this.bridge.stop();
    }

    private String checkAndTrim(String s) {
        if (s != null && "".equals(s = s.trim())) {
            s = null;
        }
        return s;
    }
}

