/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.management.impl;

import java.util.List;
import javax.management.ObjectName;
import org.hornetq.core.management.AddressControl;
import org.hornetq.core.management.ManagementService;
import org.hornetq.core.management.ObjectNames;
import org.hornetq.core.management.QueueControl;
import org.hornetq.core.messagecounter.MessageCounter;
import org.hornetq.core.messagecounter.MessageCounterManager;
import org.hornetq.jms.HornetQQueue;
import org.hornetq.jms.HornetQTopic;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.management.JMSManagementService;
import org.hornetq.jms.server.management.JMSServerControl;
import org.hornetq.jms.server.management.impl.ConnectionFactoryControlImpl;
import org.hornetq.jms.server.management.impl.JMSQueueControlImpl;
import org.hornetq.jms.server.management.impl.JMSServerControlImpl;
import org.hornetq.jms.server.management.impl.TopicControlImpl;
import org.hornetq.jms.server.management.jmx.impl.ReplicationAwareConnectionFactoryControlWrapper;
import org.hornetq.jms.server.management.jmx.impl.ReplicationAwareJMSQueueControlWrapper;
import org.hornetq.jms.server.management.jmx.impl.ReplicationAwareJMSServerControlWrapper;
import org.hornetq.jms.server.management.jmx.impl.ReplicationAwareTopicControlWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSManagementServiceImpl
implements JMSManagementService {
    private final ManagementService managementService;

    public JMSManagementServiceImpl(ManagementService managementService) {
        this.managementService = managementService;
    }

    @Override
    public synchronized JMSServerControl registerJMSServer(JMSServerManager server) throws Exception {
        ObjectName objectName = ObjectNames.getJMSServerObjectName();
        JMSServerControlImpl control = new JMSServerControlImpl(server);
        ReplicationAwareJMSServerControlWrapper replicatingProxy = new ReplicationAwareJMSServerControlWrapper(control, this.managementService.getReplicationOperationInvoker());
        this.managementService.registerInJMX(objectName, (Object)replicatingProxy);
        this.managementService.registerInRegistry("jms.server", (Object)control);
        return replicatingProxy;
    }

    @Override
    public synchronized void unregisterJMSServer() throws Exception {
        ObjectName objectName = ObjectNames.getJMSServerObjectName();
        this.managementService.unregisterFromJMX(objectName);
        this.managementService.unregisterFromRegistry("jms.server");
    }

    @Override
    public synchronized void registerQueue(HornetQQueue queue, String jndiBinding) throws Exception {
        QueueControl coreQueueControl = (QueueControl)this.managementService.getResource("core.queue." + queue.getAddress());
        MessageCounterManager messageCounterManager = this.managementService.getMessageCounterManager();
        MessageCounter counter = new MessageCounter(queue.getName(), null, coreQueueControl, false, coreQueueControl.isDurable(), messageCounterManager.getMaxDayCount());
        messageCounterManager.registerMessageCounter(queue.getName(), counter);
        ObjectName objectName = ObjectNames.getJMSQueueObjectName((String)queue.getQueueName());
        JMSQueueControlImpl control = new JMSQueueControlImpl(queue, coreQueueControl, jndiBinding, counter);
        this.managementService.registerInJMX(objectName, (Object)new ReplicationAwareJMSQueueControlWrapper(control, this.managementService.getReplicationOperationInvoker()));
        this.managementService.registerInRegistry("jms.queue." + queue.getQueueName(), (Object)control);
    }

    @Override
    public synchronized void unregisterQueue(String name) throws Exception {
        ObjectName objectName = ObjectNames.getJMSQueueObjectName((String)name);
        this.managementService.unregisterFromJMX(objectName);
        this.managementService.unregisterFromRegistry("jms.queue." + name);
    }

    @Override
    public synchronized void registerTopic(HornetQTopic topic, String jndiBinding) throws Exception {
        ObjectName objectName = ObjectNames.getJMSTopicObjectName((String)topic.getTopicName());
        AddressControl addressControl = (AddressControl)this.managementService.getResource("core.address." + topic.getAddress());
        TopicControlImpl control = new TopicControlImpl(topic, addressControl, jndiBinding, this.managementService);
        this.managementService.registerInJMX(objectName, (Object)new ReplicationAwareTopicControlWrapper(control, this.managementService.getReplicationOperationInvoker()));
        this.managementService.registerInRegistry("jms.address." + topic.getTopicName(), (Object)control);
    }

    @Override
    public synchronized void unregisterTopic(String name) throws Exception {
        ObjectName objectName = ObjectNames.getJMSTopicObjectName((String)name);
        this.managementService.unregisterFromJMX(objectName);
        this.managementService.unregisterFromRegistry("jms.address." + name);
    }

    @Override
    public synchronized void registerConnectionFactory(String name, HornetQConnectionFactory connectionFactory, List<String> bindings) throws Exception {
        ObjectName objectName = ObjectNames.getConnectionFactoryObjectName((String)name);
        ConnectionFactoryControlImpl control = new ConnectionFactoryControlImpl(connectionFactory, name, bindings);
        this.managementService.registerInJMX(objectName, (Object)new ReplicationAwareConnectionFactoryControlWrapper(control, this.managementService.getReplicationOperationInvoker()));
        this.managementService.registerInRegistry("jms.connectionfactory." + name, (Object)control);
    }

    @Override
    public synchronized void unregisterConnectionFactory(String name) throws Exception {
        ObjectName objectName = ObjectNames.getConnectionFactoryObjectName((String)name);
        this.managementService.unregisterFromJMX(objectName);
        this.managementService.unregisterFromRegistry("jms.connectionfactory." + name);
    }
}

