/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.management.jmx.impl;

import java.util.Map;
import javax.management.MBeanInfo;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.management.ReplicationOperationInvoker;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.management.jmx.impl.ReplicationAwareStandardMBeanWrapper;
import org.hornetq.jms.server.management.JMSQueueControl;
import org.hornetq.jms.server.management.impl.JMSQueueControlImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationAwareJMSQueueControlWrapper
extends ReplicationAwareStandardMBeanWrapper
implements JMSQueueControl {
    private static final Logger log = Logger.getLogger(ReplicationAwareJMSQueueControlWrapper.class);
    private final JMSQueueControlImpl localControl;

    public ReplicationAwareJMSQueueControlWrapper(JMSQueueControlImpl localControl, ReplicationOperationInvoker replicationInvoker) throws Exception {
        super("jms.queue." + localControl.getName(), JMSQueueControl.class, replicationInvoker);
        this.localControl = localControl;
    }

    @Override
    public int getConsumerCount() {
        return this.localControl.getConsumerCount();
    }

    @Override
    public String getDeadLetterAddress() {
        return this.localControl.getDeadLetterAddress();
    }

    @Override
    public void setDeadLetterAddress(String deadLetterAddress) throws Exception {
        this.replicationAwareInvoke("setDeadLetterAddress", new Object[]{deadLetterAddress});
    }

    @Override
    public int getDeliveringCount() {
        return this.localControl.getDeliveringCount();
    }

    @Override
    public String getExpiryAddress() {
        return this.localControl.getExpiryAddress();
    }

    @Override
    public int getMessageCount() {
        return this.localControl.getMessageCount();
    }

    @Override
    public int getMessagesAdded() {
        return this.localControl.getMessagesAdded();
    }

    @Override
    public String getName() {
        return this.localControl.getName();
    }

    @Override
    public long getScheduledCount() {
        return this.localControl.getScheduledCount();
    }

    @Override
    public boolean isDurable() {
        return this.localControl.isDurable();
    }

    @Override
    public boolean isTemporary() {
        return this.localControl.isTemporary();
    }

    @Override
    public String listMessageCounter() {
        return this.localControl.listMessageCounter();
    }

    @Override
    public String listMessageCounterAsHTML() {
        return this.localControl.listMessageCounterAsHTML();
    }

    @Override
    public String listMessageCounterHistory() throws Exception {
        return this.localControl.listMessageCounterHistory();
    }

    @Override
    public String listMessageCounterHistoryAsHTML() {
        return this.localControl.listMessageCounterHistoryAsHTML();
    }

    @Override
    public Map<String, Object>[] listMessages(String filter) throws Exception {
        return this.localControl.listMessages(filter);
    }

    @Override
    public String listMessagesAsJSON(String filter) throws Exception {
        return this.localControl.listMessagesAsJSON(filter);
    }

    @Override
    public int countMessages(String filter) throws Exception {
        return this.localControl.countMessages(filter);
    }

    @Override
    public String getAddress() {
        return this.localControl.getAddress();
    }

    @Override
    public String getJNDIBinding() {
        return this.localControl.getJNDIBinding();
    }

    @Override
    public boolean changeMessagePriority(String messageID, int newPriority) throws Exception {
        return (Boolean)this.replicationAwareInvoke("changeMessagePriority", new Object[]{messageID, newPriority});
    }

    @Override
    public boolean expireMessage(String messageID) throws Exception {
        return (Boolean)this.replicationAwareInvoke("expireMessage", new Object[]{messageID});
    }

    @Override
    public int expireMessages(String filter) throws Exception {
        return (Integer)this.replicationAwareInvoke("expireMessages", new Object[]{filter});
    }

    @Override
    public int moveMessages(String filter, String otherQueueName) throws Exception {
        return (Integer)this.replicationAwareInvoke("moveMessages", new Object[]{filter, otherQueueName});
    }

    @Override
    public boolean moveMessage(String messageID, String otherQueueName) throws Exception {
        return (Boolean)this.replicationAwareInvoke("moveMessage", new Object[]{messageID, otherQueueName});
    }

    @Override
    public int removeMessages(String filter) throws Exception {
        return (Integer)this.replicationAwareInvoke("removeMessages", new Object[]{filter});
    }

    @Override
    public boolean removeMessage(String messageID) throws Exception {
        return (Boolean)this.replicationAwareInvoke("removeMessage", new Object[]{messageID});
    }

    @Override
    public boolean sendMessageToDeadLetterAddress(String messageID) throws Exception {
        return (Boolean)this.replicationAwareInvoke("sendMessageToDeadLetterAddress", new Object[]{messageID});
    }

    @Override
    public void setExpiryAddress(String expiryAddress) throws Exception {
        this.replicationAwareInvoke("setExpiryAddress", new Object[]{expiryAddress});
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), MBeanInfoHelper.getMBeanOperationsInfo(JMSQueueControl.class), info.getNotifications());
    }
}

