/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.recovery;

import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hornetq.core.client.ClientSession;
import org.hornetq.core.client.ClientSessionFactory;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.config.TransportConfiguration;
import org.hornetq.core.exception.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.FailureListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HornetQXAResourceWrapper
implements XAResource,
FailureListener {
    private static final Logger log = Logger.getLogger(HornetQXAResourceWrapper.class);
    private static final Object lock = new Object();
    private final String connectorFactoryClassName;
    private Map<String, Object> connectorConfig;
    private final String username;
    private final String password;
    private ClientSessionFactory csf;
    private XAResource delegate;

    public HornetQXAResourceWrapper(String connectorFactoryClassName, Map<String, Object> connectorConfig, String username, String password) {
        this.connectorFactoryClassName = connectorFactoryClassName;
        this.connectorConfig = connectorConfig;
        this.username = username;
        this.password = password;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        log.debug((Object)("Recover " + this.connectorFactoryClassName));
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.recover(flag);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        log.debug((Object)("Commit " + this.connectorFactoryClassName + " xid " + " onePhase=" + onePhase));
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.commit(xid, onePhase);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        log.debug((Object)("Rollback " + this.connectorFactoryClassName + " xid "));
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.rollback(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        log.debug((Object)("Forget " + this.connectorFactoryClassName + " xid "));
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.forget(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (xaRes instanceof HornetQXAResourceWrapper) {
            xaRes = ((HornetQXAResourceWrapper)xaRes).getDelegate();
        }
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.isSameRM(xaRes);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.prepare(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.start(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            xaResource.end(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.getTransactionTimeout();
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        XAResource xaResource = this.getDelegate();
        try {
            return xaResource.setTransactionTimeout(seconds);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void connectionFailed(HornetQException me) {
        log.warn((Object)("Notified of connection failure in recovery connectionFactory for provider " + this.connectorFactoryClassName), (Throwable)me);
        this.close();
    }

    public XAResource getDelegate() throws XAException {
        XAResource result = null;
        Exception error = null;
        try {
            result = this.connect();
        }
        catch (Exception e) {
            log.error((Object)"********************************Failed to connect to server", (Throwable)e);
            error = e;
        }
        if (result == null) {
            XAException xae = new XAException("Error trying to connect to provider " + this.connectorFactoryClassName);
            xae.errorCode = -3;
            if (error != null) {
                xae.initCause(error);
            }
            log.debug((Object)"Cannot get connectionFactory XAResource", (Throwable)xae);
            throw xae;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XAResource connect() throws Exception {
        Object object = lock;
        synchronized (object) {
            if (this.delegate != null) {
                return this.delegate;
            }
        }
        TransportConfiguration config = new TransportConfiguration(this.connectorFactoryClassName, this.connectorConfig);
        this.csf = new ClientSessionFactoryImpl(config);
        ClientSession cs = null;
        cs = this.username == null ? this.csf.createSession(true, false, false) : this.csf.createSession(this.username, this.password, true, false, false, false, 1);
        cs.addFailureListener((FailureListener)this);
        Object object2 = lock;
        synchronized (object2) {
            this.delegate = cs;
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            ClientSessionFactory oldCSF = null;
            Object object = lock;
            synchronized (object) {
                oldCSF = this.csf;
                this.csf = null;
                this.delegate = null;
            }
            if (oldCSF != null) {
                oldCSF.close();
            }
        }
        catch (Exception ignored) {
            log.trace((Object)"Ignored error during close", (Throwable)ignored);
        }
    }

    protected XAException check(XAException e) throws XAException {
        if (e.errorCode == 4) {
            log.debug((Object)("Fatal error in provider " + this.connectorFactoryClassName), (Throwable)e);
            this.close();
        }
        throw new XAException(-7);
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

