/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.hornetq.core.config.TransportConfiguration;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.FileDeploymentManager;
import org.hornetq.core.deployers.impl.XmlDeployer;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.jms.HornetQQueue;
import org.hornetq.jms.HornetQTopic;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.SelectorTranslator;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.hornetq.jms.server.config.JMSConfiguration;
import org.hornetq.jms.server.config.QueueConfiguration;
import org.hornetq.jms.server.config.TopicConfiguration;
import org.hornetq.jms.server.impl.JMSServerDeployer;
import org.hornetq.jms.server.management.JMSManagementService;
import org.hornetq.jms.server.management.impl.JMSManagementServiceImpl;
import org.hornetq.utils.JNDIUtil;
import org.hornetq.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSServerManagerImpl
implements JMSServerManager,
ActivateCallback {
    private static final Logger log = Logger.getLogger(JMSServerManagerImpl.class);
    private static final String REJECT_FILTER = "__HQX=-1";
    private Context context;
    private final Map<String, List<String>> destinations = new HashMap<String, List<String>>();
    private final Map<String, HornetQConnectionFactory> connectionFactories = new HashMap<String, HornetQConnectionFactory>();
    private final Map<String, List<String>> connectionFactoryBindings = new HashMap<String, List<String>>();
    private final HornetQServer server;
    private JMSManagementService jmsManagementService;
    private XmlDeployer jmsDeployer;
    private boolean started;
    private boolean active;
    private DeploymentManager deploymentManager;
    private final String configFileName;
    private boolean contextSet;
    private JMSConfiguration config;

    public JMSServerManagerImpl(HornetQServer server) throws Exception {
        this.server = server;
        this.configFileName = null;
    }

    public JMSServerManagerImpl(HornetQServer server, String configFileName) throws Exception {
        this.server = server;
        this.configFileName = configFileName;
    }

    public JMSServerManagerImpl(HornetQServer server, JMSConfiguration configuration) throws Exception {
        this.server = server;
        this.configFileName = null;
        this.config = configuration;
    }

    public synchronized void activated() {
        this.active = true;
        this.jmsManagementService = new JMSManagementServiceImpl(this.server.getManagementService());
        try {
            this.jmsManagementService.registerJMSServer(this);
            if (this.config == null) {
                this.jmsDeployer = new JMSServerDeployer(this, this.deploymentManager, this.server.getConfiguration());
                if (this.configFileName != null) {
                    this.jmsDeployer.setConfigFileNames(new String[]{this.configFileName});
                }
                this.jmsDeployer.start();
                this.deploymentManager.start();
            } else {
                this.deploy();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to start jms deployer", (Throwable)e);
        }
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (!this.contextSet) {
            this.context = new InitialContext();
        }
        this.deploymentManager = new FileDeploymentManager(this.server.getConfiguration().getFileDeployerScanPeriod());
        this.server.registerActivateCallback((ActivateCallback)this);
        this.server.start();
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        if (this.jmsDeployer != null) {
            this.jmsDeployer.stop();
        }
        if (this.deploymentManager != null) {
            this.deploymentManager.stop();
        }
        for (String destination : this.destinations.keySet()) {
            this.undeployDestination(destination);
        }
        for (String connectionFactory : new HashSet<String>(this.connectionFactories.keySet())) {
            this.destroyConnectionFactory(connectionFactory);
        }
        this.destinations.clear();
        this.connectionFactories.clear();
        this.connectionFactoryBindings.clear();
        if (this.context != null) {
            this.context.close();
        }
        this.jmsManagementService.unregisterJMSServer();
        this.jmsManagementService.stop();
        this.server.stop();
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.server.getHornetQServerControl().isStarted();
    }

    @Override
    public HornetQServer getHornetQServer() {
        return this.server;
    }

    @Override
    public synchronized void setContext(Context context) {
        this.context = context;
        this.contextSet = true;
    }

    @Override
    public synchronized String getVersion() {
        this.checkInitialised();
        return this.server.getHornetQServerControl().getVersion();
    }

    @Override
    public synchronized boolean createQueue(String queueName, String jndiBinding, String selectorString, boolean durable) throws Exception {
        this.checkInitialised();
        HornetQQueue jBossQueue = new HornetQQueue(queueName);
        String coreFilterString = null;
        if (selectorString != null) {
            coreFilterString = SelectorTranslator.convertToHornetQFilterString(selectorString);
        }
        this.server.getHornetQServerControl().deployQueue(jBossQueue.getAddress(), jBossQueue.getAddress(), coreFilterString, durable);
        boolean added = this.bindToJndi(jndiBinding, jBossQueue);
        if (added) {
            this.addToDestinationBindings(queueName, jndiBinding);
        }
        this.jmsManagementService.registerQueue(jBossQueue, jndiBinding);
        return added;
    }

    @Override
    public synchronized boolean createTopic(String topicName, String jndiBinding) throws Exception {
        this.checkInitialised();
        HornetQTopic jBossTopic = new HornetQTopic(topicName);
        this.server.getHornetQServerControl().deployQueue(jBossTopic.getAddress(), jBossTopic.getAddress(), REJECT_FILTER, true);
        boolean added = this.bindToJndi(jndiBinding, jBossTopic);
        if (added) {
            this.addToDestinationBindings(topicName, jndiBinding);
        }
        this.jmsManagementService.registerTopic(jBossTopic, jndiBinding);
        return added;
    }

    @Override
    public synchronized boolean undeployDestination(String name) throws Exception {
        this.checkInitialised();
        List<String> jndiBindings = this.destinations.get(name);
        if (jndiBindings == null || jndiBindings.size() == 0) {
            return false;
        }
        if (this.context != null) {
            Iterator<String> iter = jndiBindings.iterator();
            while (iter.hasNext()) {
                String jndiBinding = iter.next();
                this.context.unbind(jndiBinding);
                iter.remove();
            }
        }
        return true;
    }

    @Override
    public synchronized boolean destroyQueue(String name) throws Exception {
        this.checkInitialised();
        this.undeployDestination(name);
        this.destinations.remove(name);
        this.jmsManagementService.unregisterQueue(name);
        this.server.getHornetQServerControl().destroyQueue(HornetQQueue.createAddressFromName(name).toString());
        return true;
    }

    @Override
    public synchronized boolean destroyTopic(String name) throws Exception {
        this.checkInitialised();
        this.undeployDestination(name);
        this.destinations.remove(name);
        this.jmsManagementService.unregisterTopic(name);
        this.server.getHornetQServerControl().destroyQueue(HornetQTopic.createAddressFromName(name).toString());
        return true;
    }

    @Override
    public synchronized void createConnectionFactory(String name, List<Pair<TransportConfiguration, TransportConfiguration>> connectorConfigs, List<String> jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            cf = new HornetQConnectionFactory(connectorConfigs);
        }
        this.bindConnectionFactory(cf, name, jndiBindings);
    }

    @Override
    public synchronized void createConnectionFactory(String name, List<Pair<TransportConfiguration, TransportConfiguration>> connectorConfigs, String clientID, List<String> jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            cf = new HornetQConnectionFactory(connectorConfigs);
            cf.setClientID(clientID);
        }
        this.bindConnectionFactory(cf, name, jndiBindings);
    }

    @Override
    public synchronized void createConnectionFactory(String name, List<Pair<TransportConfiguration, TransportConfiguration>> connectorConfigs, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, boolean cacheLargeMessagesClient, int minLargeMessageSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnServerShutdown, String groupId, List<String> jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            cf = new HornetQConnectionFactory(connectorConfigs);
            cf.setClientID(clientID);
            cf.setClientFailureCheckPeriod(clientFailureCheckPeriod);
            cf.setConnectionTTL(connectionTTL);
            cf.setCallTimeout(callTimeout);
            cf.setCacheLargeMessagesClient(cacheLargeMessagesClient);
            cf.setMinLargeMessageSize(minLargeMessageSize);
            cf.setConsumerWindowSize(consumerWindowSize);
            cf.setConsumerMaxRate(consumerMaxRate);
            cf.setConfirmationWindowSize(confirmationWindowSize);
            cf.setProducerWindowSize(producerWindowSize);
            cf.setProducerMaxRate(producerMaxRate);
            cf.setBlockOnAcknowledge(blockOnAcknowledge);
            cf.setBlockOnDurableSend(blockOnDurableSend);
            cf.setBlockOnNonDurableSend(blockOnNonDurableSend);
            cf.setAutoGroup(autoGroup);
            cf.setPreAcknowledge(preAcknowledge);
            cf.setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            cf.setTransactionBatchSize(transactionBatchSize);
            cf.setDupsOKBatchSize(dupsOKBatchSize);
            cf.setUseGlobalPools(useGlobalPools);
            cf.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            cf.setThreadPoolMaxSize(threadPoolMaxSize);
            cf.setRetryInterval(retryInterval);
            cf.setRetryIntervalMultiplier(retryIntervalMultiplier);
            cf.setMaxRetryInterval(maxRetryInterval);
            cf.setReconnectAttempts(reconnectAttempts);
            cf.setFailoverOnServerShutdown(failoverOnServerShutdown);
            cf.setGroupID(groupId);
        }
        this.bindConnectionFactory(cf, name, jndiBindings);
    }

    @Override
    public synchronized void createConnectionFactory(String name, String discoveryAddress, int discoveryPort, String clientID, long discoveryRefreshTimeout, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, boolean cacheLargeMessagesClient, int minLargeMessageSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, long initialWaitTimeout, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnServerShutdown, String groupId, List<String> jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            cf = new HornetQConnectionFactory(discoveryAddress, discoveryPort);
            cf.setClientID(clientID);
            cf.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
            cf.setClientFailureCheckPeriod(clientFailureCheckPeriod);
            cf.setConnectionTTL(connectionTTL);
            cf.setCallTimeout(callTimeout);
            cf.setCacheLargeMessagesClient(cacheLargeMessagesClient);
            cf.setMinLargeMessageSize(minLargeMessageSize);
            cf.setConsumerWindowSize(consumerWindowSize);
            cf.setConsumerMaxRate(consumerMaxRate);
            cf.setConfirmationWindowSize(confirmationWindowSize);
            cf.setProducerWindowSize(producerWindowSize);
            cf.setProducerMaxRate(producerMaxRate);
            cf.setBlockOnAcknowledge(blockOnAcknowledge);
            cf.setBlockOnDurableSend(blockOnDurableSend);
            cf.setBlockOnNonDurableSend(blockOnNonDurableSend);
            cf.setAutoGroup(autoGroup);
            cf.setPreAcknowledge(preAcknowledge);
            cf.setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            cf.setTransactionBatchSize(transactionBatchSize);
            cf.setDupsOKBatchSize(dupsOKBatchSize);
            cf.setDiscoveryInitialWaitTimeout(initialWaitTimeout);
            cf.setUseGlobalPools(useGlobalPools);
            cf.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            cf.setThreadPoolMaxSize(threadPoolMaxSize);
            cf.setRetryInterval(retryInterval);
            cf.setRetryIntervalMultiplier(retryIntervalMultiplier);
            cf.setMaxRetryInterval(maxRetryInterval);
            cf.setReconnectAttempts(reconnectAttempts);
            cf.setFailoverOnServerShutdown(failoverOnServerShutdown);
        }
        this.bindConnectionFactory(cf, name, jndiBindings);
    }

    @Override
    public synchronized void createConnectionFactory(String name, String discoveryAddress, int discoveryPort, List<String> jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            cf = new HornetQConnectionFactory(discoveryAddress, discoveryPort);
        }
        this.bindConnectionFactory(cf, name, jndiBindings);
    }

    @Override
    public synchronized void createConnectionFactory(String name, String discoveryAddress, int discoveryPort, String clientID, List<String> jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            cf = new HornetQConnectionFactory(discoveryAddress, discoveryPort);
            cf.setClientID(clientID);
        }
        this.bindConnectionFactory(cf, name, jndiBindings);
    }

    @Override
    public synchronized void createConnectionFactory(String name, TransportConfiguration liveTC, List<String> jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            cf = new HornetQConnectionFactory(liveTC);
        }
        this.bindConnectionFactory(cf, name, jndiBindings);
    }

    @Override
    public synchronized void createConnectionFactory(String name, TransportConfiguration liveTC, String clientID, List<String> jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            cf = new HornetQConnectionFactory(liveTC);
            cf.setClientID(clientID);
        }
        this.bindConnectionFactory(cf, name, jndiBindings);
    }

    @Override
    public synchronized void createConnectionFactory(String name, TransportConfiguration liveTC, TransportConfiguration backupTC, List<String> jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            cf = new HornetQConnectionFactory(liveTC, backupTC);
        }
        this.bindConnectionFactory(cf, name, jndiBindings);
    }

    @Override
    public synchronized void createConnectionFactory(String name, TransportConfiguration liveTC, TransportConfiguration backupTC, String clientID, List<String> jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            cf = new HornetQConnectionFactory(liveTC, backupTC);
            cf.setClientID(clientID);
        }
        this.bindConnectionFactory(cf, name, jndiBindings);
    }

    @Override
    public synchronized boolean destroyConnectionFactory(String name) throws Exception {
        this.checkInitialised();
        List<String> jndiBindings = this.connectionFactoryBindings.get(name);
        if (jndiBindings == null || jndiBindings.size() == 0) {
            return false;
        }
        if (this.context != null) {
            for (String jndiBinding : jndiBindings) {
                try {
                    this.context.unbind(jndiBinding);
                }
                catch (NameNotFoundException e) {}
            }
        }
        this.connectionFactoryBindings.remove(name);
        this.connectionFactories.remove(name);
        this.jmsManagementService.unregisterConnectionFactory(name);
        return true;
    }

    @Override
    public String[] listRemoteAddresses() throws Exception {
        this.checkInitialised();
        return this.server.getHornetQServerControl().listRemoteAddresses();
    }

    @Override
    public String[] listRemoteAddresses(String ipAddress) throws Exception {
        this.checkInitialised();
        return this.server.getHornetQServerControl().listRemoteAddresses(ipAddress);
    }

    @Override
    public boolean closeConnectionsForAddress(String ipAddress) throws Exception {
        this.checkInitialised();
        return this.server.getHornetQServerControl().closeConnectionsForAddress(ipAddress);
    }

    @Override
    public String[] listConnectionIDs() throws Exception {
        return this.server.getHornetQServerControl().listConnectionIDs();
    }

    @Override
    public String[] listSessions(String connectionID) throws Exception {
        this.checkInitialised();
        return this.server.getHornetQServerControl().listSessions(connectionID);
    }

    private synchronized void checkInitialised() {
        if (!this.active) {
            throw new IllegalStateException("Cannot access JMS Server, core server is not yet active");
        }
    }

    private void bindConnectionFactory(HornetQConnectionFactory cf, String name, List<String> jndiBindings) throws Exception {
        for (String jndiBinding : jndiBindings) {
            this.bindToJndi(jndiBinding, cf);
            if (this.connectionFactoryBindings.get(name) == null) {
                this.connectionFactoryBindings.put(name, new ArrayList());
            }
            this.connectionFactoryBindings.get(name).add(jndiBinding);
        }
        this.jmsManagementService.registerConnectionFactory(name, cf, jndiBindings);
    }

    private boolean bindToJndi(String jndiName, Object objectToBind) throws NamingException {
        if (this.context != null) {
            int sepIndex = jndiName.lastIndexOf(47);
            String parentContext = sepIndex == -1 ? "" : jndiName.substring(0, sepIndex);
            String jndiNameInContext = jndiName.substring(sepIndex + 1);
            try {
                this.context.lookup(jndiName);
                log.warn((Object)("Binding for " + jndiName + " already exists"));
                return false;
            }
            catch (Throwable e) {
                Context c = JNDIUtil.createContext((Context)this.context, (String)parentContext);
                c.rebind(jndiNameInContext, objectToBind);
            }
        }
        return true;
    }

    private void addToDestinationBindings(String destination, String jndiBinding) {
        if (this.destinations.get(destination) == null) {
            this.destinations.put(destination, new ArrayList());
        }
        this.destinations.get(destination).add(jndiBinding);
    }

    private void deploy() throws Exception {
        if (this.config == null) {
            return;
        }
        if (this.config.getContext() != null) {
            this.setContext(this.config.getContext());
        }
        List<ConnectionFactoryConfiguration> connectionFactoryConfigurations = this.config.getConnectionFactoryConfigurations();
        for (ConnectionFactoryConfiguration config : connectionFactoryConfigurations) {
            if (config.getDiscoveryAddress() != null) {
                this.createConnectionFactory(config.getName(), config.getDiscoveryAddress(), config.getDiscoveryPort(), config.getClientID(), config.getDiscoveryRefreshTimeout(), config.getClientFailureCheckPeriod(), config.getConnectionTTL(), config.getCallTimeout(), config.isCacheLargeMessagesClient(), config.getMinLargeMessageSize(), config.getConsumerWindowSize(), config.getConsumerMaxRate(), config.getConfirmationWindowSize(), config.getProducerWindowSize(), config.getProducerMaxRate(), config.isBlockOnAcknowledge(), config.isBlockOnDurableSend(), config.isBlockOnNonDurableSend(), config.isAutoGroup(), config.isPreAcknowledge(), config.getLoadBalancingPolicyClassName(), config.getTransactionBatchSize(), config.getDupsOKBatchSize(), config.getInitialWaitTimeout(), config.isUseGlobalPools(), config.getScheduledThreadPoolMaxSize(), config.getThreadPoolMaxSize(), config.getRetryInterval(), config.getRetryIntervalMultiplier(), config.getMaxRetryInterval(), config.getReconnectAttempts(), config.isFailoverOnServerShutdown(), config.getGroupID(), Arrays.asList(config.getBindings()));
                continue;
            }
            this.createConnectionFactory(config.getName(), config.getConnectorConfigs(), config.getClientID(), config.getClientFailureCheckPeriod(), config.getConnectionTTL(), config.getCallTimeout(), config.isCacheLargeMessagesClient(), config.getMinLargeMessageSize(), config.getConsumerWindowSize(), config.getConsumerMaxRate(), config.getConfirmationWindowSize(), config.getProducerWindowSize(), config.getProducerMaxRate(), config.isBlockOnAcknowledge(), config.isBlockOnDurableSend(), config.isBlockOnNonDurableSend(), config.isAutoGroup(), config.isPreAcknowledge(), config.getLoadBalancingPolicyClassName(), config.getTransactionBatchSize(), config.getDupsOKBatchSize(), config.isUseGlobalPools(), config.getScheduledThreadPoolMaxSize(), config.getThreadPoolMaxSize(), config.getRetryInterval(), config.getRetryIntervalMultiplier(), config.getMaxRetryInterval(), config.getReconnectAttempts(), config.isFailoverOnServerShutdown(), config.getGroupID(), Arrays.asList(config.getBindings()));
        }
        List<QueueConfiguration> queueConfigs = this.config.getQueueConfigurations();
        for (QueueConfiguration config : queueConfigs) {
            String[] bindings;
            for (String binding : bindings = config.getBindings()) {
                this.createQueue(config.getName(), binding, config.getSelector(), config.isDurable());
            }
        }
        List<TopicConfiguration> topicConfigs = this.config.getTopicConfigurations();
        for (TopicConfiguration config : topicConfigs) {
            String[] bindings;
            for (String binding : bindings = config.getBindings()) {
                this.createTopic(config.getName(), binding);
            }
        }
    }
}

