/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.io.Serializable;
import javax.jms.Destination;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.hornetq.api.core.SimpleString;
import org.hornetq.jms.client.HornetQQueue;
import org.hornetq.jms.client.HornetQTemporaryQueue;
import org.hornetq.jms.client.HornetQTemporaryTopic;
import org.hornetq.jms.client.HornetQTopic;
import org.hornetq.jms.referenceable.DestinationObjectFactory;
import org.hornetq.jms.referenceable.SerializableObjectRefAddr;

public abstract class HornetQDestination
implements Destination,
Serializable,
Referenceable {
    private static final long serialVersionUID = 5027962425462382883L;
    protected final String name;
    private final String address;
    private final SimpleString simpleAddress;

    protected static String escape(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace(".", "\\.");
    }

    public static Destination fromAddress(String address) {
        if (address.startsWith("jms.queue.")) {
            String name = address.substring("jms.queue.".length());
            return new HornetQQueue(address, name);
        }
        if (address.startsWith("jms.topic.")) {
            String name = address.substring("jms.topic.".length());
            return new HornetQTopic(address, name);
        }
        if (address.startsWith("jms.tempqueue.")) {
            String name = address.substring("jms.tempqueue.".length());
            return new HornetQTemporaryQueue(null, name);
        }
        if (address.startsWith("jms.temptopic.")) {
            String name = address.substring("jms.temptopic.".length());
            return new HornetQTemporaryTopic(null, name);
        }
        throw new IllegalArgumentException("Invalid address " + address);
    }

    public HornetQDestination(String address, String name) {
        this.address = address;
        this.name = name;
        this.simpleAddress = new SimpleString(address);
    }

    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getCanonicalName(), new SerializableObjectRefAddr("HornetQ-DEST", this), DestinationObjectFactory.class.getCanonicalName(), null);
    }

    public String getAddress() {
        return this.address;
    }

    public SimpleString getSimpleAddress() {
        return this.simpleAddress;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isTemporary();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HornetQDestination)) {
            return false;
        }
        HornetQDestination that = (HornetQDestination)o;
        return this.address.equals(that.address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }
}

