/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.AddressControl;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.DiscoveryGroupConfiguration;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.FileDeploymentManager;
import org.hornetq.core.deployers.impl.XmlDeployer;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.BindingType;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.SelectorTranslator;
import org.hornetq.jms.persistence.JMSStorageManager;
import org.hornetq.jms.persistence.config.PersistedConnectionFactory;
import org.hornetq.jms.persistence.config.PersistedDestination;
import org.hornetq.jms.persistence.config.PersistedJNDI;
import org.hornetq.jms.persistence.config.PersistedType;
import org.hornetq.jms.persistence.impl.journal.JMSJournalStorageManagerImpl;
import org.hornetq.jms.persistence.impl.nullpm.NullJMSStorageManagerImpl;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.hornetq.jms.server.config.JMSConfiguration;
import org.hornetq.jms.server.config.JMSQueueConfiguration;
import org.hornetq.jms.server.config.TopicConfiguration;
import org.hornetq.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.hornetq.jms.server.impl.JMSServerDeployer;
import org.hornetq.jms.server.management.JMSManagementService;
import org.hornetq.jms.server.management.impl.JMSManagementServiceImpl;
import org.hornetq.utils.IDGenerator;
import org.hornetq.utils.JNDIUtil;
import org.hornetq.utils.TimeAndCounterIDGenerator;

public class JMSServerManagerImpl
implements JMSServerManager,
ActivateCallback {
    private static final Logger log = Logger.getLogger(JMSServerManagerImpl.class);
    private static final String REJECT_FILTER = "__HQX=-1";
    private Context context;
    private Map<String, HornetQDestination> queues = new HashMap<String, HornetQDestination>();
    private Map<String, HornetQDestination> topics = new HashMap<String, HornetQDestination>();
    private final Map<String, HornetQConnectionFactory> connectionFactories = new HashMap<String, HornetQConnectionFactory>();
    private final Map<String, List<String>> queueJNDI = new HashMap<String, List<String>>();
    private final Map<String, List<String>> topicJNDI = new HashMap<String, List<String>>();
    private final Map<String, List<String>> connectionFactoryJNDI = new HashMap<String, List<String>>();
    private final HornetQServer server;
    private JMSManagementService jmsManagementService;
    private XmlDeployer jmsDeployer;
    private boolean started;
    private boolean active;
    private DeploymentManager deploymentManager;
    private final String configFileName;
    private boolean contextSet;
    private JMSConfiguration config;
    private Configuration coreConfig;
    private JMSStorageManager storage;

    public JMSServerManagerImpl(HornetQServer server) throws Exception {
        this.server = server;
        this.coreConfig = server.getConfiguration();
        this.configFileName = null;
    }

    public JMSServerManagerImpl(HornetQServer server, String configFileName) throws Exception {
        this.server = server;
        this.coreConfig = server.getConfiguration();
        this.configFileName = configFileName;
    }

    public JMSServerManagerImpl(HornetQServer server, JMSConfiguration configuration) throws Exception {
        this.server = server;
        this.coreConfig = server.getConfiguration();
        this.configFileName = null;
        this.config = configuration;
    }

    public JMSServerManagerImpl(HornetQServer server, String configFilename, JMSStorageManager storageManager) {
        this.server = server;
        this.configFileName = null;
        this.storage = storageManager;
    }

    public void preActivate() {
    }

    public synchronized void activated() {
        this.active = true;
        this.jmsManagementService = new JMSManagementServiceImpl(this.server.getManagementService(), this);
        try {
            this.jmsManagementService.registerJMSServer(this);
            this.initJournal();
            if (this.config == null) {
                if (this.server.getConfiguration().isFileDeploymentEnabled()) {
                    this.jmsDeployer = new JMSServerDeployer(this, this.deploymentManager, this.server.getConfiguration());
                    if (this.configFileName != null) {
                        this.jmsDeployer.setConfigFileNames(new String[]{this.configFileName});
                    }
                    this.jmsDeployer.start();
                    this.deploymentManager.start();
                }
            } else {
                this.deploy();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to start jms deployer", (Throwable)e);
        }
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (!this.contextSet) {
            this.context = new InitialContext();
        }
        this.deploymentManager = new FileDeploymentManager(this.server.getConfiguration().getFileDeployerScanPeriod());
        this.server.registerActivateCallback((ActivateCallback)this);
        this.server.start();
        if (this.server.getReplicationEndpoint() != null) {
            this.createJournal();
            this.storage.installReplication(this.server.getReplicationEndpoint());
        }
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        if (this.jmsDeployer != null) {
            this.jmsDeployer.stop();
        }
        if (this.deploymentManager != null) {
            this.deploymentManager.stop();
        }
        if (this.storage != null) {
            this.storage.stop();
        }
        this.unbindJNDI(this.queueJNDI);
        this.unbindJNDI(this.topicJNDI);
        this.unbindJNDI(this.connectionFactoryJNDI);
        for (String connectionFactory : new HashSet<String>(this.connectionFactories.keySet())) {
            this.destroyConnectionFactory(connectionFactory);
        }
        this.connectionFactories.clear();
        this.connectionFactoryJNDI.clear();
        this.queueJNDI.clear();
        this.queues.clear();
        this.topicJNDI.clear();
        this.topics.clear();
        if (this.context != null) {
            this.context.close();
        }
        if (this.jmsManagementService != null) {
            this.jmsManagementService.unregisterJMSServer();
            this.jmsManagementService.stop();
        }
        this.server.stop();
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.server.isStarted();
    }

    @Override
    public HornetQServer getHornetQServer() {
        return this.server;
    }

    @Override
    public void addAddressSettings(String address, AddressSettings addressSettings) {
        this.server.getAddressSettingsRepository().addMatch(address, (Object)addressSettings);
    }

    @Override
    public AddressSettings getAddressSettings(String address) {
        return (AddressSettings)this.server.getAddressSettingsRepository().getMatch(address);
    }

    @Override
    public void addSecurity(String addressMatch, Set<Role> roles) {
        this.server.getSecurityRepository().addMatch(addressMatch, roles);
    }

    @Override
    public Set<Role> getSecurity(String addressMatch) {
        return (Set)this.server.getSecurityRepository().getMatch(addressMatch);
    }

    @Override
    public synchronized void setContext(Context context) {
        this.context = context;
        this.contextSet = true;
    }

    @Override
    public synchronized String getVersion() {
        this.checkInitialised();
        return this.server.getVersion().getFullVersion();
    }

    @Override
    public synchronized boolean createQueue(boolean storeConfig, String queueName, String selectorString, boolean durable, String ... jndi) throws Exception {
        this.checkInitialised();
        boolean added = this.internalCreateQueue(queueName, selectorString, durable);
        if (!added) {
            return false;
        }
        HornetQDestination destination = this.queues.get(queueName);
        if (destination == null) {
            throw new IllegalArgumentException("Queue does not exist");
        }
        ArrayList<String> bindings = new ArrayList<String>();
        for (String jndiItem : jndi) {
            if (!this.bindToJndi(jndiItem, destination)) continue;
            bindings.add(jndiItem);
        }
        String[] usedJNDI = bindings.toArray(new String[bindings.size()]);
        this.addToBindings(this.queueJNDI, queueName, usedJNDI);
        if (storeConfig && durable) {
            this.storage.storeDestination(new PersistedDestination(PersistedType.Queue, queueName, selectorString, durable));
            this.storage.addJNDI(PersistedType.Queue, queueName, usedJNDI);
        }
        return added;
    }

    @Override
    public synchronized boolean createTopic(boolean storeConfig, String topicName, String ... jndi) throws Exception {
        this.checkInitialised();
        boolean added = this.internalCreateTopic(topicName);
        if (!added) {
            return false;
        }
        HornetQDestination destination = this.topics.get(topicName);
        if (destination == null) {
            throw new IllegalArgumentException("Queue does not exist");
        }
        ArrayList<String> bindings = new ArrayList<String>();
        for (String jndiItem : jndi) {
            if (!this.bindToJndi(jndiItem, destination)) continue;
            bindings.add(jndiItem);
        }
        String[] usedJNDI = bindings.toArray(new String[bindings.size()]);
        this.addToBindings(this.topicJNDI, topicName, usedJNDI);
        if (storeConfig) {
            this.storage.storeDestination(new PersistedDestination(PersistedType.Topic, topicName));
            this.storage.addJNDI(PersistedType.Topic, topicName, usedJNDI);
        }
        return true;
    }

    @Override
    public boolean addTopicToJndi(String topicName, String jndiBinding) throws Exception {
        this.checkInitialised();
        HornetQDestination destination = this.topics.get(topicName);
        if (destination == null) {
            throw new IllegalArgumentException("Topic does not exist");
        }
        if (destination.getTopicName() == null) {
            throw new IllegalArgumentException(topicName + " is not a topic");
        }
        boolean added = this.bindToJndi(jndiBinding, destination);
        if (added) {
            this.addToBindings(this.topicJNDI, topicName, jndiBinding);
            this.storage.addJNDI(PersistedType.Topic, topicName, jndiBinding);
        }
        return added;
    }

    @Override
    public String[] getJNDIOnQueue(String queue) {
        return this.getJNDIList(this.queueJNDI, queue);
    }

    @Override
    public String[] getJNDIOnTopic(String topic) {
        return this.getJNDIList(this.topicJNDI, topic);
    }

    @Override
    public String[] getJNDIOnConnectionFactory(String factoryName) {
        return this.getJNDIList(this.connectionFactoryJNDI, factoryName);
    }

    @Override
    public boolean addQueueToJndi(String queueName, String jndiBinding) throws Exception {
        this.checkInitialised();
        HornetQDestination destination = this.queues.get(queueName);
        if (destination == null) {
            throw new IllegalArgumentException("Queue does not exist");
        }
        if (destination.getQueueName() == null) {
            throw new IllegalArgumentException(queueName + " is not a queue");
        }
        boolean added = this.bindToJndi(jndiBinding, destination);
        if (added) {
            this.addToBindings(this.queueJNDI, queueName, jndiBinding);
            this.storage.addJNDI(PersistedType.Queue, queueName, jndiBinding);
        }
        return added;
    }

    @Override
    public boolean addConnectionFactoryToJNDI(String name, String jndiBinding) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory factory = this.connectionFactories.get(name);
        if (factory == null) {
            throw new IllegalArgumentException("Factory does not exist");
        }
        boolean added = this.bindToJndi(jndiBinding, factory);
        if (added) {
            this.addToBindings(this.connectionFactoryJNDI, name, jndiBinding);
            this.storage.addJNDI(PersistedType.ConnectionFactory, name, jndiBinding);
        }
        return added;
    }

    @Override
    public boolean removeQueueFromJNDI(String name, String jndi) throws Exception {
        this.checkInitialised();
        boolean removed = this.removeFromJNDI(this.queueJNDI, name, jndi);
        if (removed) {
            this.storage.deleteJNDI(PersistedType.Queue, name, jndi);
        }
        return removed;
    }

    @Override
    public boolean removeQueueFromJNDI(String name) throws Exception {
        this.checkInitialised();
        if (this.removeFromJNDI(this.queues, this.queueJNDI, name)) {
            this.storage.deleteDestination(PersistedType.Queue, name);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTopicFromJNDI(String name, String jndi) throws Exception {
        this.checkInitialised();
        if (this.removeFromJNDI(this.topicJNDI, name, jndi)) {
            this.storage.deleteJNDI(PersistedType.Topic, name, jndi);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTopicFromJNDI(String name) throws Exception {
        this.checkInitialised();
        boolean removed = this.removeFromJNDI(this.topics, this.topicJNDI, name);
        if (removed) {
            this.storage.deleteDestination(PersistedType.Topic, name);
        }
        return removed;
    }

    @Override
    public boolean removeConnectionFactoryFromJNDI(String name, String jndi) throws Exception {
        this.checkInitialised();
        this.removeFromJNDI(this.connectionFactoryJNDI, name, jndi);
        this.storage.deleteJNDI(PersistedType.ConnectionFactory, name, jndi);
        return true;
    }

    @Override
    public boolean removeConnectionFactoryFromJNDI(String name) throws Exception {
        this.checkInitialised();
        this.removeFromJNDI(this.connectionFactories, this.connectionFactoryJNDI, name);
        this.storage.deleteConnectionFactory(name);
        return true;
    }

    @Override
    public synchronized boolean destroyQueue(String name) throws Exception {
        this.checkInitialised();
        this.removeFromJNDI(this.queues, this.queueJNDI, name);
        this.queues.remove(name);
        this.queueJNDI.remove(name);
        this.jmsManagementService.unregisterQueue(name);
        this.server.destroyQueue(HornetQDestination.createQueueAddressFromName(name), null);
        this.storage.deleteDestination(PersistedType.Queue, name);
        return true;
    }

    @Override
    public synchronized boolean destroyTopic(String name) throws Exception {
        this.checkInitialised();
        this.removeFromJNDI(this.topics, this.topicJNDI, name);
        this.topics.remove(name);
        this.topicJNDI.remove(name);
        this.jmsManagementService.unregisterTopic(name);
        AddressControl addressControl = (AddressControl)this.server.getManagementService().getResource("core.address." + HornetQDestination.createTopicAddressFromName(name));
        if (addressControl != null) {
            for (String queueName : addressControl.getQueueNames()) {
                Binding binding = this.server.getPostOffice().getBinding(new SimpleString(queueName));
                if (binding == null) {
                    log.warn((Object)("Queue " + queueName + " doesn't exist on the topic " + name + ". It was deleted manually probably."));
                    continue;
                }
                if (binding.getType() == BindingType.REMOTE_QUEUE) continue;
                this.server.destroyQueue(SimpleString.toSimpleString((String)queueName), null);
            }
        }
        this.storage.deleteDestination(PersistedType.Topic, name);
        return true;
    }

    @Override
    public synchronized void createConnectionFactory(String name, List<Pair<TransportConfiguration, TransportConfiguration>> connectorConfigs, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, connectorConfigs, new String[0]);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, String clientID, List<Pair<TransportConfiguration, TransportConfiguration>> connectorConfigs, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, connectorConfigs, new String[0]);
            configuration.setClientID(clientID);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, List<Pair<TransportConfiguration, TransportConfiguration>> connectorConfigs, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, boolean cacheLargeMessagesClient, int minLargeMessageSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, boolean failoverOnServerShutdown, String groupId, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, connectorConfigs, new String[0]);
            configuration.setClientID(clientID);
            configuration.setClientFailureCheckPeriod(clientFailureCheckPeriod);
            configuration.setConnectionTTL(connectionTTL);
            configuration.setCallTimeout(callTimeout);
            configuration.setCacheLargeMessagesClient(cacheLargeMessagesClient);
            configuration.setMinLargeMessageSize(minLargeMessageSize);
            configuration.setConsumerWindowSize(consumerWindowSize);
            configuration.setConsumerMaxRate(consumerMaxRate);
            configuration.setConfirmationWindowSize(confirmationWindowSize);
            configuration.setProducerWindowSize(producerWindowSize);
            configuration.setProducerMaxRate(producerMaxRate);
            configuration.setBlockOnAcknowledge(blockOnAcknowledge);
            configuration.setBlockOnDurableSend(blockOnDurableSend);
            configuration.setBlockOnNonDurableSend(blockOnNonDurableSend);
            configuration.setAutoGroup(autoGroup);
            configuration.setPreAcknowledge(preAcknowledge);
            configuration.setLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            configuration.setTransactionBatchSize(transactionBatchSize);
            configuration.setDupsOKBatchSize(dupsOKBatchSize);
            configuration.setUseGlobalPools(useGlobalPools);
            configuration.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            configuration.setThreadPoolMaxSize(threadPoolMaxSize);
            configuration.setRetryInterval(retryInterval);
            configuration.setRetryIntervalMultiplier(retryIntervalMultiplier);
            configuration.setMaxRetryInterval(maxRetryInterval);
            configuration.setReconnectAttempts(reconnectAttempts);
            configuration.setFailoverOnInitialConnection(failoverOnInitialConnection);
            configuration.setFailoverOnServerShutdown(failoverOnServerShutdown);
            configuration.setGroupID(groupId);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, String localBindAddress, String discoveryAddress, int discoveryPort, String clientID, long discoveryRefreshTimeout, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, boolean cacheLargeMessagesClient, int minLargeMessageSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, long initialWaitTimeout, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, boolean failoverOnServerShutdown, String groupId, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, localBindAddress, discoveryAddress, discoveryPort, new String[0]);
            configuration.setClientID(clientID);
            configuration.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
            configuration.setClientFailureCheckPeriod(clientFailureCheckPeriod);
            configuration.setConnectionTTL(connectionTTL);
            configuration.setCallTimeout(callTimeout);
            configuration.setCacheLargeMessagesClient(cacheLargeMessagesClient);
            configuration.setMinLargeMessageSize(minLargeMessageSize);
            configuration.setConsumerWindowSize(consumerWindowSize);
            configuration.setConsumerMaxRate(consumerMaxRate);
            configuration.setConfirmationWindowSize(confirmationWindowSize);
            configuration.setProducerWindowSize(producerWindowSize);
            configuration.setProducerMaxRate(producerMaxRate);
            configuration.setBlockOnAcknowledge(blockOnAcknowledge);
            configuration.setBlockOnDurableSend(blockOnDurableSend);
            configuration.setBlockOnNonDurableSend(blockOnNonDurableSend);
            configuration.setAutoGroup(autoGroup);
            configuration.setPreAcknowledge(preAcknowledge);
            configuration.setLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            configuration.setTransactionBatchSize(transactionBatchSize);
            configuration.setDupsOKBatchSize(dupsOKBatchSize);
            configuration.setDiscoveryRefreshTimeout(initialWaitTimeout);
            configuration.setUseGlobalPools(useGlobalPools);
            configuration.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            configuration.setThreadPoolMaxSize(threadPoolMaxSize);
            configuration.setRetryInterval(retryInterval);
            configuration.setRetryIntervalMultiplier(retryIntervalMultiplier);
            configuration.setMaxRetryInterval(maxRetryInterval);
            configuration.setReconnectAttempts(reconnectAttempts);
            configuration.setFailoverOnInitialConnection(failoverOnInitialConnection);
            configuration.setFailoverOnServerShutdown(failoverOnServerShutdown);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, String discoveryAddress, int discoveryPort, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, discoveryAddress, discoveryPort, new String[0]);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, String clientID, String discoveryAddress, int discoveryPort, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, discoveryAddress, discoveryPort, new String[0]);
            configuration.setClientID(clientID);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(boolean storeConfig, ConnectionFactoryConfiguration cfConfig, String ... jndi) throws Exception {
        HornetQConnectionFactory cf = this.internalCreateCF(cfConfig);
        ArrayList<String> bindings = new ArrayList<String>();
        for (String jndiItem : jndi) {
            if (!this.bindToJndi(jndiItem, cf)) continue;
            bindings.add(jndiItem);
        }
        String[] usedJNDI = bindings.toArray(new String[bindings.size()]);
        this.addToBindings(this.connectionFactoryJNDI, cfConfig.getName(), usedJNDI);
        if (storeConfig) {
            this.storage.storeConnectionFactory(new PersistedConnectionFactory(cfConfig));
            this.storage.addJNDI(PersistedType.ConnectionFactory, cfConfig.getName(), usedJNDI);
        }
    }

    private HornetQConnectionFactory internalCreateConnectionFactory(String name, String localBindAddress, String discoveryAddress, int discoveryPort, String clientID, long discoveryRefreshTimeout, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, boolean cacheLargeMessagesClient, int minLargeMessageSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, long initialWaitTimeout, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, boolean failoverOnServerShutdown, String groupId) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            cf = (HornetQConnectionFactory)HornetQJMSClient.createConnectionFactory(discoveryAddress, discoveryPort);
            cf.setClientID(clientID);
            cf.setLocalBindAddress(localBindAddress);
            cf.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
            cf.setClientFailureCheckPeriod(clientFailureCheckPeriod);
            cf.setConnectionTTL(connectionTTL);
            cf.setCallTimeout(callTimeout);
            cf.setCacheLargeMessagesClient(cacheLargeMessagesClient);
            cf.setMinLargeMessageSize(minLargeMessageSize);
            cf.setConsumerWindowSize(consumerWindowSize);
            cf.setConsumerMaxRate(consumerMaxRate);
            cf.setConfirmationWindowSize(confirmationWindowSize);
            cf.setProducerWindowSize(producerWindowSize);
            cf.setProducerMaxRate(producerMaxRate);
            cf.setBlockOnAcknowledge(blockOnAcknowledge);
            cf.setBlockOnDurableSend(blockOnDurableSend);
            cf.setBlockOnNonDurableSend(blockOnNonDurableSend);
            cf.setAutoGroup(autoGroup);
            cf.setPreAcknowledge(preAcknowledge);
            cf.setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            cf.setTransactionBatchSize(transactionBatchSize);
            cf.setDupsOKBatchSize(dupsOKBatchSize);
            cf.setDiscoveryInitialWaitTimeout(initialWaitTimeout);
            cf.setUseGlobalPools(useGlobalPools);
            cf.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            cf.setThreadPoolMaxSize(threadPoolMaxSize);
            cf.setRetryInterval(retryInterval);
            cf.setRetryIntervalMultiplier(retryIntervalMultiplier);
            cf.setMaxRetryInterval(maxRetryInterval);
            cf.setReconnectAttempts(reconnectAttempts);
            cf.setFailoverOnInitialConnection(failoverOnInitialConnection);
            cf.setFailoverOnServerShutdown(failoverOnServerShutdown);
        }
        return cf;
    }

    private HornetQConnectionFactory internalCreateConnectionFactory(String name, List<Pair<TransportConfiguration, TransportConfiguration>> connectorConfigs, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, boolean cacheLargeMessagesClient, int minLargeMessageSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, boolean failoverOnServerShutdown, String groupId) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            cf = (HornetQConnectionFactory)HornetQJMSClient.createConnectionFactory(connectorConfigs);
            cf.setClientID(clientID);
            cf.setClientFailureCheckPeriod(clientFailureCheckPeriod);
            cf.setConnectionTTL(connectionTTL);
            cf.setCallTimeout(callTimeout);
            cf.setCacheLargeMessagesClient(cacheLargeMessagesClient);
            cf.setMinLargeMessageSize(minLargeMessageSize);
            cf.setConsumerWindowSize(consumerWindowSize);
            cf.setConsumerMaxRate(consumerMaxRate);
            cf.setConfirmationWindowSize(confirmationWindowSize);
            cf.setProducerWindowSize(producerWindowSize);
            cf.setProducerMaxRate(producerMaxRate);
            cf.setBlockOnAcknowledge(blockOnAcknowledge);
            cf.setBlockOnDurableSend(blockOnDurableSend);
            cf.setBlockOnNonDurableSend(blockOnNonDurableSend);
            cf.setAutoGroup(autoGroup);
            cf.setPreAcknowledge(preAcknowledge);
            cf.setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            cf.setTransactionBatchSize(transactionBatchSize);
            cf.setDupsOKBatchSize(dupsOKBatchSize);
            cf.setUseGlobalPools(useGlobalPools);
            cf.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            cf.setThreadPoolMaxSize(threadPoolMaxSize);
            cf.setRetryInterval(retryInterval);
            cf.setRetryIntervalMultiplier(retryIntervalMultiplier);
            cf.setMaxRetryInterval(maxRetryInterval);
            cf.setReconnectAttempts(reconnectAttempts);
            cf.setFailoverOnInitialConnection(failoverOnInitialConnection);
            cf.setFailoverOnServerShutdown(failoverOnServerShutdown);
            cf.setGroupID(groupId);
        }
        return cf;
    }

    private String[] getJNDIList(Map<String, List<String>> map, String name) {
        List<String> result = map.get(name);
        if (result == null) {
            return new String[0];
        }
        String[] strings = new String[result.size()];
        result.toArray(strings);
        return strings;
    }

    private boolean internalCreateQueue(String queueName, String selectorString, boolean durable) throws Exception {
        if (this.queues.get(queueName) != null) {
            return false;
        }
        HornetQDestination hqQueue = HornetQDestination.createQueue(queueName);
        String coreFilterString = null;
        if (selectorString != null) {
            coreFilterString = SelectorTranslator.convertToHornetQFilterString(selectorString);
        }
        this.server.deployQueue(SimpleString.toSimpleString((String)hqQueue.getAddress()), SimpleString.toSimpleString((String)hqQueue.getAddress()), SimpleString.toSimpleString((String)coreFilterString), durable, false);
        this.queues.put(queueName, hqQueue);
        this.jmsManagementService.registerQueue(hqQueue);
        return true;
    }

    private boolean internalCreateTopic(String topicName) throws Exception {
        if (this.topics.get(topicName) != null) {
            return false;
        }
        HornetQDestination hqTopic = HornetQDestination.createTopic(topicName);
        this.server.deployQueue(SimpleString.toSimpleString((String)hqTopic.getAddress()), SimpleString.toSimpleString((String)hqTopic.getAddress()), SimpleString.toSimpleString((String)REJECT_FILTER), true, false);
        this.topics.put(topicName, hqTopic);
        this.jmsManagementService.registerTopic(hqTopic);
        return true;
    }

    private HornetQConnectionFactory internalCreateCF(ConnectionFactoryConfiguration cfConfig) throws HornetQException, Exception {
        List<Pair<TransportConfiguration, TransportConfiguration>> connectorConfigs = this.lookupConnectors(cfConfig);
        this.lookupDiscovery(cfConfig);
        HornetQConnectionFactory cf = cfConfig.getDiscoveryAddress() != null ? this.internalCreateConnectionFactory(cfConfig.getName(), cfConfig.getLocalBindAddress(), cfConfig.getDiscoveryAddress(), cfConfig.getDiscoveryPort(), cfConfig.getClientID(), cfConfig.getDiscoveryRefreshTimeout(), cfConfig.getClientFailureCheckPeriod(), cfConfig.getConnectionTTL(), cfConfig.getCallTimeout(), cfConfig.isCacheLargeMessagesClient(), cfConfig.getMinLargeMessageSize(), cfConfig.getConsumerWindowSize(), cfConfig.getConsumerMaxRate(), cfConfig.getConfirmationWindowSize(), cfConfig.getProducerWindowSize(), cfConfig.getProducerMaxRate(), cfConfig.isBlockOnAcknowledge(), cfConfig.isBlockOnDurableSend(), cfConfig.isBlockOnNonDurableSend(), cfConfig.isAutoGroup(), cfConfig.isPreAcknowledge(), cfConfig.getLoadBalancingPolicyClassName(), cfConfig.getTransactionBatchSize(), cfConfig.getDupsOKBatchSize(), cfConfig.getInitialWaitTimeout(), cfConfig.isUseGlobalPools(), cfConfig.getScheduledThreadPoolMaxSize(), cfConfig.getThreadPoolMaxSize(), cfConfig.getRetryInterval(), cfConfig.getRetryIntervalMultiplier(), cfConfig.getMaxRetryInterval(), cfConfig.getReconnectAttempts(), cfConfig.isFailoverOnInitialConnection(), cfConfig.isFailoverOnServerShutdown(), cfConfig.getGroupID()) : this.internalCreateConnectionFactory(cfConfig.getName(), connectorConfigs, cfConfig.getClientID(), cfConfig.getClientFailureCheckPeriod(), cfConfig.getConnectionTTL(), cfConfig.getCallTimeout(), cfConfig.isCacheLargeMessagesClient(), cfConfig.getMinLargeMessageSize(), cfConfig.getConsumerWindowSize(), cfConfig.getConsumerMaxRate(), cfConfig.getConfirmationWindowSize(), cfConfig.getProducerWindowSize(), cfConfig.getProducerMaxRate(), cfConfig.isBlockOnAcknowledge(), cfConfig.isBlockOnDurableSend(), cfConfig.isBlockOnNonDurableSend(), cfConfig.isAutoGroup(), cfConfig.isPreAcknowledge(), cfConfig.getLoadBalancingPolicyClassName(), cfConfig.getTransactionBatchSize(), cfConfig.getDupsOKBatchSize(), cfConfig.isUseGlobalPools(), cfConfig.getScheduledThreadPoolMaxSize(), cfConfig.getThreadPoolMaxSize(), cfConfig.getRetryInterval(), cfConfig.getRetryIntervalMultiplier(), cfConfig.getMaxRetryInterval(), cfConfig.getReconnectAttempts(), cfConfig.isFailoverOnInitialConnection(), cfConfig.isFailoverOnServerShutdown(), cfConfig.getGroupID());
        this.connectionFactories.put(cfConfig.getName(), cf);
        this.jmsManagementService.registerConnectionFactory(cfConfig.getName(), cf);
        return cf;
    }

    @Override
    public synchronized void createConnectionFactory(String name, TransportConfiguration liveTC, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, liveTC, new String[0]);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, String clientID, TransportConfiguration liveTC, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, liveTC, new String[0]);
            configuration.setClientID(clientID);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, TransportConfiguration liveTC, TransportConfiguration backupTC, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, liveTC, backupTC, new String[0]);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, String clientID, TransportConfiguration liveTC, TransportConfiguration backupTC, String ... jndiBindings) throws Exception {
        this.checkInitialised();
        HornetQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfigurationImpl configuration = new ConnectionFactoryConfigurationImpl(name, liveTC, backupTC, new String[0]);
            configuration.setClientID(clientID);
            this.createConnectionFactory(true, configuration, jndiBindings);
        }
    }

    @Override
    public synchronized boolean destroyConnectionFactory(String name) throws Exception {
        this.checkInitialised();
        List<String> jndiBindings = this.connectionFactoryJNDI.get(name);
        if (jndiBindings == null || jndiBindings.size() == 0) {
            return false;
        }
        if (this.context != null) {
            for (String jndiBinding : jndiBindings) {
                try {
                    this.context.unbind(jndiBinding);
                }
                catch (NameNotFoundException e) {}
            }
        }
        this.connectionFactoryJNDI.remove(name);
        this.connectionFactories.remove(name);
        this.jmsManagementService.unregisterConnectionFactory(name);
        return true;
    }

    @Override
    public String[] listRemoteAddresses() throws Exception {
        this.checkInitialised();
        return this.server.getHornetQServerControl().listRemoteAddresses();
    }

    @Override
    public String[] listRemoteAddresses(String ipAddress) throws Exception {
        this.checkInitialised();
        return this.server.getHornetQServerControl().listRemoteAddresses(ipAddress);
    }

    @Override
    public boolean closeConnectionsForAddress(String ipAddress) throws Exception {
        this.checkInitialised();
        return this.server.getHornetQServerControl().closeConnectionsForAddress(ipAddress);
    }

    @Override
    public String[] listConnectionIDs() throws Exception {
        return this.server.getHornetQServerControl().listConnectionIDs();
    }

    @Override
    public String[] listSessions(String connectionID) throws Exception {
        this.checkInitialised();
        return this.server.getHornetQServerControl().listSessions(connectionID);
    }

    private synchronized void checkInitialised() {
        if (!this.active) {
            throw new IllegalStateException("Cannot access JMS Server, core server is not yet active");
        }
    }

    private void addToBindings(Map<String, List<String>> map, String name, String ... jndi) {
        List<String> list = map.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            map.put(name, list);
        }
        for (String jndiItem : jndi) {
            list.add(jndiItem);
        }
    }

    private boolean bindToJndi(String jndiName, Object objectToBind) throws NamingException {
        if (this.context != null) {
            int sepIndex = jndiName.lastIndexOf(47);
            String parentContext = sepIndex == -1 ? "" : jndiName.substring(0, sepIndex);
            String jndiNameInContext = jndiName.substring(sepIndex + 1);
            try {
                this.context.lookup(jndiName);
                log.warn((Object)("Binding for " + jndiName + " already exists"));
                return false;
            }
            catch (Throwable e) {
                Context c = JNDIUtil.createContext((Context)this.context, (String)parentContext);
                c.rebind(jndiNameInContext, objectToBind);
            }
        }
        return true;
    }

    private void lookupDiscovery(ConnectionFactoryConfiguration cfConfig) throws HornetQException {
        if (cfConfig.getDiscoveryGroupName() != null) {
            Configuration configuration = this.server.getConfiguration();
            DiscoveryGroupConfiguration discoveryGroupConfiguration = null;
            discoveryGroupConfiguration = (DiscoveryGroupConfiguration)configuration.getDiscoveryGroupConfigurations().get(cfConfig.getDiscoveryGroupName());
            if (discoveryGroupConfiguration == null) {
                log.warn((Object)("There is no discovery group with name '" + cfConfig.getDiscoveryGroupName() + "' deployed."));
                throw new HornetQException(104, "There is no discovery group with name '" + cfConfig.getDiscoveryGroupName() + "' deployed.");
            }
            cfConfig.setLocalBindAddress(discoveryGroupConfiguration.getLocalBindAddress());
            cfConfig.setDiscoveryAddress(discoveryGroupConfiguration.getGroupAddress());
            cfConfig.setDiscoveryPort(discoveryGroupConfiguration.getGroupPort());
            cfConfig.setDiscoveryRefreshTimeout(discoveryGroupConfiguration.getRefreshTimeout());
        }
    }

    private void deploy() throws Exception {
        if (this.config == null) {
            return;
        }
        if (this.config.getContext() != null) {
            this.setContext(this.config.getContext());
        }
        List<ConnectionFactoryConfiguration> connectionFactoryConfigurations = this.config.getConnectionFactoryConfigurations();
        for (ConnectionFactoryConfiguration config : connectionFactoryConfigurations) {
            this.createConnectionFactory(false, config, config.getBindings());
        }
        List<JMSQueueConfiguration> queueConfigs = this.config.getQueueConfigurations();
        for (JMSQueueConfiguration config : queueConfigs) {
            String[] bindings = config.getBindings();
            this.createQueue(false, config.getName(), config.getSelector(), config.isDurable(), bindings);
        }
        List<TopicConfiguration> topicConfigs = this.config.getTopicConfigurations();
        for (TopicConfiguration config : topicConfigs) {
            String[] bindings = config.getBindings();
            this.createTopic(false, config.getName(), bindings);
        }
    }

    private void unbindJNDI(Map<String, List<String>> param) {
        if (this.context != null) {
            for (List<String> elementList : param.values()) {
                for (String key : elementList) {
                    try {
                        this.context.unbind(key);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Impossible to unbind key " + key + " from JNDI"), (Throwable)e);
                    }
                }
            }
        }
    }

    private void initJournal() throws Exception {
        this.coreConfig = this.server.getConfiguration();
        this.createJournal();
        this.storage.load();
        List<PersistedConnectionFactory> cfs = this.storage.recoverConnectionFactories();
        for (PersistedConnectionFactory cf : cfs) {
            this.internalCreateCF(cf.getConfig());
        }
        List<PersistedDestination> destinations = this.storage.recoverDestinations();
        for (PersistedDestination destination : destinations) {
            if (destination.getType() == PersistedType.Queue) {
                this.internalCreateQueue(destination.getName(), destination.getSelector(), destination.isDurable());
                continue;
            }
            if (destination.getType() != PersistedType.Topic) continue;
            this.internalCreateTopic(destination.getName());
        }
        List<PersistedJNDI> jndiSpace = this.storage.recoverPersistedJNDI();
        for (PersistedJNDI record : jndiSpace) {
            Referenceable objectToBind;
            Map<String, Referenceable> objects;
            Map<String, List<String>> mapJNDI;
            switch (record.getType()) {
                case Queue: {
                    mapJNDI = this.queueJNDI;
                    objects = this.queues;
                    break;
                }
                case Topic: {
                    mapJNDI = this.topicJNDI;
                    objects = this.topics;
                    break;
                }
                default: {
                    mapJNDI = this.connectionFactoryJNDI;
                    objects = this.connectionFactories;
                }
            }
            if ((objectToBind = objects.get(record.getName())) == null) continue;
            List<String> jndiList = mapJNDI.get(record.getName());
            if (jndiList == null) {
                jndiList = new ArrayList<String>();
                mapJNDI.put(record.getName(), jndiList);
            }
            for (String jndi : record.getJndi()) {
                jndiList.add(jndi);
                this.bindToJndi(jndi, objectToBind);
            }
        }
    }

    private void createJournal() throws Exception {
        if (this.storage == null) {
            this.storage = this.coreConfig.isPersistenceEnabled() ? new JMSJournalStorageManagerImpl((IDGenerator)new TimeAndCounterIDGenerator(), this.server.getConfiguration(), this.server.getReplicationManager()) : new NullJMSStorageManagerImpl();
        } else if (this.storage.isStarted()) {
            this.storage.stop();
        }
        this.storage.start();
    }

    private synchronized boolean removeFromJNDI(Map<String, ?> keys, Map<String, List<String>> jndiMap, String name) throws Exception {
        this.checkInitialised();
        List<String> jndiBindings = jndiMap.remove(name);
        if (jndiBindings == null || jndiBindings.size() == 0) {
            return false;
        }
        keys.remove(name);
        if (this.context != null) {
            Iterator<String> iter = jndiBindings.iterator();
            while (iter.hasNext()) {
                String jndiBinding = iter.next();
                this.context.unbind(jndiBinding);
                iter.remove();
            }
        }
        return true;
    }

    private synchronized boolean removeFromJNDI(Map<String, List<String>> jndiMap, String name, String jndi) throws Exception {
        this.checkInitialised();
        List<String> jndiBindings = jndiMap.get(name);
        if (jndiBindings == null || jndiBindings.size() == 0) {
            return false;
        }
        if (jndiBindings.remove(jndi)) {
            this.context.unbind(jndi);
            return true;
        }
        return false;
    }

    private List<Pair<TransportConfiguration, TransportConfiguration>> lookupConnectors(ConnectionFactoryConfiguration cfConfig) throws HornetQException {
        if (cfConfig.getConnectorConfigs() != null && cfConfig.getConnectorConfigs().size() > 0) {
            return cfConfig.getConnectorConfigs();
        }
        if (cfConfig.getConnectorNames() != null) {
            Configuration configuration = this.server.getConfiguration();
            ArrayList<Pair<TransportConfiguration, TransportConfiguration>> connectorConfigs = new ArrayList<Pair<TransportConfiguration, TransportConfiguration>>();
            for (Pair<String, String> configConnector : cfConfig.getConnectorNames()) {
                String connectorName = (String)configConnector.a;
                String backupConnectorName = (String)configConnector.b;
                TransportConfiguration connector = (TransportConfiguration)configuration.getConnectorConfigurations().get(connectorName);
                if (connector == null) {
                    log.warn((Object)("There is no connector with name '" + connectorName + "' deployed."));
                    throw new HornetQException(104, "There is no connector with name '" + connectorName + "' deployed.");
                }
                TransportConfiguration backupConnector = null;
                if (backupConnectorName != null && (backupConnector = (TransportConfiguration)configuration.getConnectorConfigurations().get(backupConnectorName)) == null) {
                    log.warn((Object)("There is no backup connector with name '" + backupConnectorName + "' deployed."));
                    throw new HornetQException(104, "There is no backup connector with name '" + backupConnectorName + "' deployed.");
                }
                connectorConfigs.add((Pair<TransportConfiguration, TransportConfiguration>)new Pair((Object)connector, (Object)backupConnector));
            }
            return connectorConfigs;
        }
        return null;
    }
}

