/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.management.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.api.jms.management.JMSQueueControl;
import org.hornetq.api.jms.management.JMSServerControl;
import org.hornetq.api.jms.management.TopicControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.utils.SecurityFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSServerControlImpl
extends StandardMBean
implements JMSServerControl,
NotificationEmitter {
    private final JMSServerManager server;
    private final NotificationBroadcasterSupport broadcaster;
    private final AtomicLong notifSeq = new AtomicLong(0L);

    private static List<String> convert(Object[] jndiBindings) {
        ArrayList<String> bindings = new ArrayList<String>();
        for (Object object : jndiBindings) {
            bindings.add(object.toString().trim());
        }
        return bindings;
    }

    private static String[] toArray(String commaSeparatedString) {
        if (commaSeparatedString == null || commaSeparatedString.trim().length() == 0) {
            return new String[0];
        }
        String[] values = commaSeparatedString.split(",");
        String[] trimmed = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            trimmed[i] = values[i].trim();
        }
        return trimmed;
    }

    private static List<Pair<TransportConfiguration, TransportConfiguration>> convertToConnectorPairs(Object[] liveConnectorsTransportClassNames, Object[] liveConnectorTransportParams, Object[] backupConnectorsTransportClassNames, Object[] backupConnectorTransportParams) {
        ArrayList<Pair<TransportConfiguration, TransportConfiguration>> pairs = new ArrayList<Pair<TransportConfiguration, TransportConfiguration>>();
        for (int i = 0; i < liveConnectorsTransportClassNames.length; ++i) {
            Map liveParams = null;
            if (liveConnectorTransportParams.length > i) {
                liveParams = (Map)liveConnectorTransportParams[i];
            }
            TransportConfiguration tcLive = new TransportConfiguration(liveConnectorsTransportClassNames[i].toString(), liveParams);
            Map backupParams = null;
            if (backupConnectorTransportParams.length > i) {
                backupParams = (Map)backupConnectorTransportParams[i];
            }
            Object tcBackup = null;
            if (backupConnectorsTransportClassNames.length > i) {
                new TransportConfiguration(backupConnectorsTransportClassNames[i].toString(), backupParams);
            }
            Pair pair = new Pair((Object)tcLive, tcBackup);
            pairs.add((Pair<TransportConfiguration, TransportConfiguration>)pair);
        }
        return pairs;
    }

    public static MBeanNotificationInfo[] getNotificationInfos() {
        NotificationType[] values = NotificationType.values();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].toString();
        }
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(names, JMSServerControl.class.getName(), "Notifications emitted by a JMS Server")};
    }

    public JMSServerControlImpl(JMSServerManager server) throws Exception {
        super(JMSServerControl.class);
        this.server = server;
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    @Override
    public void createConnectionFactory(String name, String liveTransportClassName, Map<String, Object> liveTransportParams, Object[] jndiBindings) throws Exception {
        List<String> jndiBindingsList = JMSServerControlImpl.convert(jndiBindings);
        TransportConfiguration liveTC = new TransportConfiguration(liveTransportClassName, liveTransportParams);
        this.server.createConnectionFactory(name, liveTC, jndiBindingsList);
        this.sendNotification(NotificationType.CONNECTION_FACTORY_CREATED, name);
    }

    @Override
    public void createConnectionFactory(String name, Object[] liveConnectorsTransportClassNames, Object[] liveConnectorTransportParams, Object[] backupConnectorsTransportClassNames, Object[] backupConnectorTransportParams, Object[] jndiBindings) throws Exception {
        List<Pair<TransportConfiguration, TransportConfiguration>> pairs = JMSServerControlImpl.convertToConnectorPairs(liveConnectorsTransportClassNames, liveConnectorTransportParams, backupConnectorsTransportClassNames, backupConnectorTransportParams);
        List<String> jndiBindingsList = JMSServerControlImpl.convert(jndiBindings);
        this.server.createConnectionFactory(name, pairs, jndiBindingsList);
        this.sendNotification(NotificationType.CONNECTION_FACTORY_CREATED, name);
    }

    @Override
    public void createConnectionFactory(String name, String liveTransportClassNames, String liveTransportParams, String backupTransportClassNames, String backupTransportParams, String jndiBindings) throws Exception {
        Object[] liveClassNames = JMSServerControlImpl.toArray(liveTransportClassNames);
        Object[] liveParams = ManagementHelper.fromCommaSeparatedArrayOfCommaSeparatedKeyValues((String)liveTransportParams);
        Object[] backupClassNames = JMSServerControlImpl.toArray(backupTransportClassNames);
        Object[] backupParams = ManagementHelper.fromCommaSeparatedArrayOfCommaSeparatedKeyValues((String)backupTransportParams);
        Object[] bindings = JMSServerControlImpl.toArray(jndiBindings);
        this.createConnectionFactory(name, liveClassNames, liveParams, backupClassNames, backupParams, bindings);
    }

    @Override
    public void createConnectionFactory(String name, String discoveryAddress, int discoveryPort, Object[] jndiBindings) throws Exception {
        List<String> jndiBindingsList = JMSServerControlImpl.convert(jndiBindings);
        this.server.createConnectionFactory(name, discoveryAddress, discoveryPort, jndiBindingsList);
        this.sendNotification(NotificationType.CONNECTION_FACTORY_CREATED, name);
    }

    @Override
    public void createConnectionFactory(String name, String discoveryAddress, int discoveryPort, String jndiBindings) throws Exception {
        Object[] bindings = JMSServerControlImpl.toArray(jndiBindings);
        this.createConnectionFactory(name, discoveryAddress, discoveryPort, bindings);
    }

    @Override
    public boolean createQueue(String name, String jndiBinding) throws Exception {
        boolean created = this.server.createQueue(name, jndiBinding, null, true);
        if (created) {
            this.sendNotification(NotificationType.QUEUE_CREATED, name);
        }
        return created;
    }

    @Override
    public boolean destroyQueue(String name) throws Exception {
        boolean destroyed = this.server.destroyQueue(name);
        if (destroyed) {
            this.sendNotification(NotificationType.QUEUE_DESTROYED, name);
        }
        return destroyed;
    }

    @Override
    public boolean createTopic(String topicName, String jndiBinding) throws Exception {
        boolean created = this.server.createTopic(topicName, jndiBinding);
        if (created) {
            this.sendNotification(NotificationType.TOPIC_CREATED, topicName);
        }
        return created;
    }

    @Override
    public boolean destroyTopic(String name) throws Exception {
        boolean destroyed = this.server.destroyTopic(name);
        if (destroyed) {
            this.sendNotification(NotificationType.TOPIC_DESTROYED, name);
        }
        return destroyed;
    }

    @Override
    public void destroyConnectionFactory(String name) throws Exception {
        boolean destroyed = this.server.destroyConnectionFactory(name);
        if (destroyed) {
            this.sendNotification(NotificationType.CONNECTION_FACTORY_DESTROYED, name);
        }
    }

    @Override
    public boolean isStarted() {
        return this.server.isStarted();
    }

    @Override
    public String getVersion() {
        return this.server.getVersion();
    }

    @Override
    public String[] getQueueNames() {
        Object[] queueControls = this.server.getHornetQServer().getManagementService().getResources(JMSQueueControl.class);
        String[] names = new String[queueControls.length];
        for (int i = 0; i < queueControls.length; ++i) {
            JMSQueueControl queueControl = (JMSQueueControl)queueControls[i];
            names[i] = queueControl.getName();
        }
        return names;
    }

    @Override
    public String[] getTopicNames() {
        Object[] topicControls = this.server.getHornetQServer().getManagementService().getResources(TopicControl.class);
        String[] names = new String[topicControls.length];
        for (int i = 0; i < topicControls.length; ++i) {
            TopicControl topicControl = (TopicControl)topicControls[i];
            names[i] = topicControl.getName();
        }
        return names;
    }

    @Override
    public String[] getConnectionFactoryNames() {
        Object[] cfControls = this.server.getHornetQServer().getManagementService().getResources(ConnectionFactoryControl.class);
        String[] names = new String[cfControls.length];
        for (int i = 0; i < cfControls.length; ++i) {
            ConnectionFactoryControl cfControl = (ConnectionFactoryControl)cfControls[i];
            names[i] = cfControl.getName();
        }
        return names;
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return JMSServerControlImpl.getNotificationInfos();
    }

    @Override
    public String[] listRemoteAddresses() throws Exception {
        return this.server.listRemoteAddresses();
    }

    @Override
    public String[] listRemoteAddresses(String ipAddress) throws Exception {
        return this.server.listRemoteAddresses(ipAddress);
    }

    @Override
    public boolean closeConnectionsForAddress(String ipAddress) throws Exception {
        return this.server.closeConnectionsForAddress(ipAddress);
    }

    @Override
    public String[] listConnectionIDs() throws Exception {
        return this.server.listConnectionIDs();
    }

    @Override
    public String[] listSessions(String connectionID) throws Exception {
        return this.server.listSessions(connectionID);
    }

    @Override
    public void addAddressSettings(String address, String DLA, String expiryAddress, boolean lastValueQueue, int deliveryAttempts, long maxSizeBytes, int pageSizeBytes, long redeliveryDelay, long redistributionDelay, boolean sendToDLAOnNoRoute, String addressFullMessagePolicy) throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setDeadLetterAddress(DLA == null ? null : new SimpleString(DLA));
        addressSettings.setExpiryAddress(expiryAddress == null ? null : new SimpleString(expiryAddress));
        addressSettings.setLastValueQueue(lastValueQueue);
        addressSettings.setMaxDeliveryAttempts(deliveryAttempts);
        addressSettings.setMaxSizeBytes(maxSizeBytes);
        addressSettings.setPageSizeBytes(pageSizeBytes);
        addressSettings.setRedeliveryDelay(redeliveryDelay);
        addressSettings.setRedistributionDelay(redistributionDelay);
        addressSettings.setSendToDLAOnNoRoute(sendToDLAOnNoRoute);
        if (addressFullMessagePolicy == null) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        } else if (addressFullMessagePolicy.equalsIgnoreCase("PAGE")) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        } else if (addressFullMessagePolicy.equalsIgnoreCase("DROP")) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP);
        } else if (addressFullMessagePolicy.equalsIgnoreCase("BLOCK")) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        }
        this.server.addAddressSettings(address, addressSettings);
    }

    @Override
    public AddressSettings getAddressSettings(String address) {
        return this.server.getAddressSettings(address);
    }

    @Override
    public String getAddressSettingsAsJSON(String address) throws Exception {
        return this.server.getHornetQServer().getHornetQServerControl().getAddressSettingsAsJSON(address);
    }

    @Override
    public void addSecuritySettings(String addressMatch, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createTempQueueRoles, String deleteTempQueueRoles, String manageRoles) throws Exception {
        Set roles = SecurityFormatter.createSecurity((String)sendRoles, (String)consumeRoles, (String)createDurableQueueRoles, (String)deleteDurableQueueRoles, (String)createTempQueueRoles, (String)deleteTempQueueRoles, (String)manageRoles);
        this.server.addSecurity(addressMatch, roles);
    }

    @Override
    public void removeSecuritySettings(String addressMatch) throws Exception {
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), MBeanInfoHelper.getMBeanOperationsInfo(JMSServerControl.class), info.getNotifications());
    }

    private void sendNotification(NotificationType type, String message) {
        Notification notif = new Notification(type.toString(), (Object)this, this.notifSeq.incrementAndGet(), message);
        this.broadcaster.sendNotification(notif);
    }

    private static List<String> toList(String commaSeparatedString) {
        ArrayList<String> list = new ArrayList<String>();
        if (commaSeparatedString == null || commaSeparatedString.trim().length() == 0) {
            return list;
        }
        String[] values = commaSeparatedString.split(",");
        for (int i = 0; i < values.length; ++i) {
            list.add(values[i].trim());
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NotificationType {
        QUEUE_CREATED,
        QUEUE_DESTROYED,
        TOPIC_CREATED,
        TOPIC_DESTROYED,
        CONNECTION_FACTORY_CREATED,
        CONNECTION_FACTORY_DESTROYED;

    }
}

