/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.config.impl;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactoryConfigurationImpl
implements ConnectionFactoryConfiguration {
    private final String[] bindings;
    private final String name;
    private String discoveryGroupName;
    private String discoveryAddress;
    private int discoveryPort;
    private List<Pair<String, String>> connectorNames;
    private List<Pair<TransportConfiguration, TransportConfiguration>> connectorConfigs;
    private String clientID = null;
    private long discoveryRefreshTimeout = 10000L;
    private long clientFailureCheckPeriod = 30000L;
    private long connectionTTL = 60000L;
    private long callTimeout = 30000L;
    private boolean cacheLargeMessagesClient = false;
    private int minLargeMessageSize = 102400;
    private int consumerWindowSize = 0x100000;
    private int consumerMaxRate = -1;
    private int confirmationWindowSize = -1;
    private int producerWindowSize = 0x100000;
    private int producerMaxRate = -1;
    private boolean blockOnAcknowledge = false;
    private boolean blockOnDurableSend = true;
    private boolean blockOnNonDurableSend = false;
    private boolean autoGroup = false;
    private boolean preAcknowledge = false;
    private String loadBalancingPolicyClassName = HornetQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME;
    private int transactionBatchSize = 0x100000;
    private int dupsOKBatchSize = 0x100000;
    private long initialWaitTimeout = 2000L;
    private boolean useGlobalPools = true;
    private int scheduledThreadPoolMaxSize = 5;
    private int threadPoolMaxSize = -1;
    private long retryInterval = 2000L;
    private double retryIntervalMultiplier = 1.0;
    private long maxRetryInterval = 2000L;
    private int reconnectAttempts = 0;
    private boolean failoverOnServerShutdown = false;
    private String groupID = null;

    public ConnectionFactoryConfigurationImpl(String name, String discoveryAddress, int discoveryPort, String ... bindings) {
        this(name, bindings);
        this.discoveryAddress = discoveryAddress;
        this.discoveryPort = discoveryPort;
    }

    public ConnectionFactoryConfigurationImpl(String name, TransportConfiguration liveConfig, String ... bindings) {
        this(name, liveConfig, (TransportConfiguration)null, bindings);
    }

    public ConnectionFactoryConfigurationImpl(String name, TransportConfiguration liveConfig, TransportConfiguration backupConfig, String ... bindings) {
        this(name, bindings);
        this.connectorConfigs = new ArrayList<Pair<TransportConfiguration, TransportConfiguration>>();
        this.connectorConfigs.add((Pair<TransportConfiguration, TransportConfiguration>)new Pair((Object)liveConfig, (Object)backupConfig));
    }

    public ConnectionFactoryConfigurationImpl(String name, List<Pair<TransportConfiguration, TransportConfiguration>> transportConfigs, String ... bindings) {
        this(name, bindings);
        this.connectorConfigs = new ArrayList<Pair<TransportConfiguration, TransportConfiguration>>();
        this.connectorConfigs.addAll(transportConfigs);
    }

    public ConnectionFactoryConfigurationImpl(String name, String ... bindings) {
        this.name = name;
        this.bindings = new String[bindings.length];
        System.arraycopy(bindings, 0, this.bindings, 0, bindings.length);
    }

    @Override
    public String[] getBindings() {
        return this.bindings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDiscoveryAddress() {
        return this.discoveryAddress;
    }

    @Override
    public void setDiscoveryAddress(String discoveryAddress) {
        this.discoveryAddress = discoveryAddress;
    }

    @Override
    public int getDiscoveryPort() {
        return this.discoveryPort;
    }

    @Override
    public void setDiscoveryPort(int discoveryPort) {
        this.discoveryPort = discoveryPort;
    }

    @Override
    public List<Pair<TransportConfiguration, TransportConfiguration>> getConnectorConfigs() {
        return this.connectorConfigs;
    }

    @Override
    public void setConnectorConfigs(List<Pair<TransportConfiguration, TransportConfiguration>> connectorConfigs) {
        this.connectorConfigs = connectorConfigs;
    }

    @Override
    public String getClientID() {
        return this.clientID;
    }

    @Override
    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    @Override
    public long getDiscoveryRefreshTimeout() {
        return this.discoveryRefreshTimeout;
    }

    @Override
    public void setDiscoveryRefreshTimeout(long discoveryRefreshTimeout) {
        this.discoveryRefreshTimeout = discoveryRefreshTimeout;
    }

    @Override
    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    @Override
    public void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
    }

    @Override
    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    @Override
    public void setConnectionTTL(long connectionTTL) {
        this.connectionTTL = connectionTTL;
    }

    @Override
    public long getCallTimeout() {
        return this.callTimeout;
    }

    @Override
    public void setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
    }

    @Override
    public boolean isCacheLargeMessagesClient() {
        return this.cacheLargeMessagesClient;
    }

    @Override
    public void setCacheLargeMessagesClient(boolean cacheLargeMessagesClient) {
        this.cacheLargeMessagesClient = cacheLargeMessagesClient;
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public void setMinLargeMessageSize(int minLargeMessageSize) {
        this.minLargeMessageSize = minLargeMessageSize;
    }

    @Override
    public int getConsumerWindowSize() {
        return this.consumerWindowSize;
    }

    @Override
    public void setConsumerWindowSize(int consumerWindowSize) {
        this.consumerWindowSize = consumerWindowSize;
    }

    @Override
    public int getConsumerMaxRate() {
        return this.consumerMaxRate;
    }

    @Override
    public void setConsumerMaxRate(int consumerMaxRate) {
        this.consumerMaxRate = consumerMaxRate;
    }

    @Override
    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    @Override
    public void setConfirmationWindowSize(int confirmationWindowSize) {
        this.confirmationWindowSize = confirmationWindowSize;
    }

    @Override
    public int getProducerMaxRate() {
        return this.producerMaxRate;
    }

    @Override
    public void setProducerMaxRate(int producerMaxRate) {
        this.producerMaxRate = producerMaxRate;
    }

    @Override
    public int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    @Override
    public void setProducerWindowSize(int producerWindowSize) {
        this.producerWindowSize = producerWindowSize;
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    @Override
    public void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.blockOnAcknowledge = blockOnAcknowledge;
    }

    @Override
    public boolean isBlockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    @Override
    public void setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.blockOnDurableSend = blockOnDurableSend;
    }

    @Override
    public boolean isBlockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    @Override
    public void setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.blockOnNonDurableSend = blockOnNonDurableSend;
    }

    @Override
    public boolean isAutoGroup() {
        return this.autoGroup;
    }

    @Override
    public void setAutoGroup(boolean autoGroup) {
        this.autoGroup = autoGroup;
    }

    @Override
    public boolean isPreAcknowledge() {
        return this.preAcknowledge;
    }

    @Override
    public void setPreAcknowledge(boolean preAcknowledge) {
        this.preAcknowledge = preAcknowledge;
    }

    @Override
    public String getLoadBalancingPolicyClassName() {
        return this.loadBalancingPolicyClassName;
    }

    @Override
    public void setLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        this.loadBalancingPolicyClassName = loadBalancingPolicyClassName;
    }

    @Override
    public int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    @Override
    public void setTransactionBatchSize(int transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
    }

    @Override
    public int getDupsOKBatchSize() {
        return this.dupsOKBatchSize;
    }

    @Override
    public void setDupsOKBatchSize(int dupsOKBatchSize) {
        this.dupsOKBatchSize = dupsOKBatchSize;
    }

    @Override
    public long getInitialWaitTimeout() {
        return this.initialWaitTimeout;
    }

    @Override
    public void setInitialWaitTimeout(long initialWaitTimeout) {
        this.initialWaitTimeout = initialWaitTimeout;
    }

    @Override
    public boolean isUseGlobalPools() {
        return this.useGlobalPools;
    }

    @Override
    public void setUseGlobalPools(boolean useGlobalPools) {
        this.useGlobalPools = useGlobalPools;
    }

    @Override
    public int getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    @Override
    public void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.threadPoolMaxSize = threadPoolMaxSize;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    @Override
    public void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    @Override
    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    @Override
    public void setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
    }

    @Override
    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    @Override
    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    @Override
    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    @Override
    public List<Pair<String, String>> getConnectorNames() {
        return this.connectorNames;
    }

    @Override
    public void setConnectorNames(List<Pair<String, String>> connectors) {
        this.connectorNames = connectors;
    }

    @Override
    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    @Override
    public void setDiscoveryGroupName(String groupName) {
        this.discoveryGroupName = groupName;
    }
}

