/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.jms.management;

import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.management.Operation;
import org.hornetq.api.core.management.Parameter;
import org.hornetq.core.security.Role;
import org.hornetq.core.settings.impl.AddressSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface JMSServerControl {
    public boolean isStarted();

    public String getVersion();

    public String[] getTopicNames();

    public String[] getQueueNames();

    public String[] getConnectionFactoryNames();

    @Operation(desc="Create a JMS Queue", impact=1)
    public boolean createQueue(@Parameter(name="name", desc="Name of the queue to create") String var1, @Parameter(name="jndiBinding", desc="the name of the binding for JNDI") String var2) throws Exception;

    @Operation(desc="Destroy a JMS Queue", impact=1)
    public boolean destroyQueue(@Parameter(name="name", desc="Name of the queue to destroy") String var1) throws Exception;

    @Operation(desc="Create a JMS Topic", impact=1)
    public boolean createTopic(@Parameter(name="name", desc="Name of the topic to create") String var1, @Parameter(name="jndiBinding", desc="the name of the binding for JNDI") String var2) throws Exception;

    @Operation(desc="Destroy a JMS Topic", impact=1)
    public boolean destroyTopic(@Parameter(name="name", desc="Name of the topic to destroy") String var1) throws Exception;

    public void createConnectionFactory(String var1, String var2, Map<String, Object> var3, Object[] var4) throws Exception;

    public void createConnectionFactory(String var1, Object[] var2, Object[] var3, Object[] var4, Object[] var5, Object[] var6) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="liveTransportClassNames", desc="comma-separated list of class names for transport to live servers") String var2, @Parameter(name="liveTransportParams", desc="comma-separated list of key=value parameters for the live transports (enclosed between { } for each transport)") String var3, @Parameter(name="backupTransportClassNames", desc="comma-separated list of class names for transport to backup servers") String var4, @Parameter(name="backupTransportParams", desc="comma-separated list of key=value parameters for the backup transports (enclosed between { } for each transport)") String var5, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings") String var6) throws Exception;

    public void createConnectionFactory(String var1, String var2, int var3, Object[] var4) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="discoveryAddress") String var2, @Parameter(name="discoveryPort") int var3, @Parameter(name="jndiBindings") String var4) throws Exception;

    @Operation(desc="Destroy a JMS ConnectionFactory", impact=1)
    public void destroyConnectionFactory(@Parameter(name="name", desc="Name of the ConnectionFactory to destroy") String var1) throws Exception;

    @Operation(desc="List the client addresses", impact=0)
    public String[] listRemoteAddresses() throws Exception;

    @Operation(desc="List the client addresses which match the given IP Address", impact=0)
    public String[] listRemoteAddresses(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="Closes all the connections for the given IP Address", impact=0)
    public boolean closeConnectionsForAddress(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="List all the connection IDs", impact=0)
    public String[] listConnectionIDs() throws Exception;

    @Operation(desc="List the sessions for the given connectionID", impact=0)
    public String[] listSessions(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;

    @Operation(desc="Add address settings for addresses matching the addressMatch", impact=1)
    public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="the dead letter address setting", name="DLA") String var2, @Parameter(desc="the expiry address setting", name="expiryAddress") String var3, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean var4, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int var5, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long var6, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int var8, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long var9, @Parameter(desc="the redistribution delay", name="redistributionDelay") long var11, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean var13, @Parameter(desc="the ploicy to use when the address is full", name="addressFullMessagePolicy") String var14) throws Exception;

    public AddressSettings getAddressSettings(String var1);

    @Operation(desc="returns the address settings as a JSON string for an address match", impact=0)
    public String getAddressSettingsAsJSON(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="Add security settings for addresses matching the addressMatch", impact=1)
    public void addSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="a comma-separated list of roles allowed to send messages", name="send") String var2, @Parameter(desc="a comma-separated list of roles allowed to consume messages", name="consume") String var3, @Parameter(desc="a comma-separated list of roles allowed to create durable queues", name="createDurableQueueRoles") String var4, @Parameter(desc="a comma-separated list of roles allowed to delete durable queues", name="deleteDurableQueueRoles") String var5, @Parameter(desc="a comma-separated list of roles allowed to create temporary queues", name="createTempQueueRoles") String var6, @Parameter(desc="a comma-separated list of roles allowed to delete temporary queues", name="deleteTempQueueRoles") String var7, @Parameter(desc="a comma-separated list of roles allowed to send management messages messages", name="manage") String var8) throws Exception;

    @Operation(desc="removes the address settings for an address match", impact=0)
    public void removeSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    public Set<Role> getSecuritySettings(String var1) throws Exception;

    public String getSecuritySettingsAsJSON(String var1) throws Exception;
}

