/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.jms.management;

import java.util.Map;
import org.hornetq.api.core.management.Operation;
import org.hornetq.api.core.management.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface JMSServerControl {
    public boolean isStarted();

    public String getVersion();

    public String[] getTopicNames();

    public String[] getQueueNames();

    public String[] getConnectionFactoryNames();

    @Operation(desc="Create a JMS Queue", impact=1)
    public boolean createQueue(@Parameter(name="name", desc="Name of the queue to create") String var1, @Parameter(name="jndiBinding", desc="the name of the binding for JNDI") String var2) throws Exception;

    @Operation(desc="Destroy a JMS Queue", impact=1)
    public boolean destroyQueue(@Parameter(name="name", desc="Name of the queue to destroy") String var1) throws Exception;

    @Operation(desc="Create a JMS Topic", impact=1)
    public boolean createTopic(@Parameter(name="name", desc="Name of the topic to create") String var1, @Parameter(name="jndiBinding", desc="the name of the binding for JNDI") String var2) throws Exception;

    @Operation(desc="Destroy a JMS Topic", impact=1)
    public boolean destroyTopic(@Parameter(name="name", desc="Name of the topic to destroy") String var1) throws Exception;

    public void createConnectionFactory(String var1, String var2, Map<String, Object> var3, Object[] var4) throws Exception;

    public void createConnectionFactory(String var1, Object[] var2, Object[] var3, Object[] var4, Object[] var5, Object[] var6) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="liveTransportClassNames", desc="comma-separated list of class names for transport to live servers") String var2, @Parameter(name="liveTransportParams", desc="comma-separated list of key=value parameters for the live transports (enclosed between { } for each transport)") String var3, @Parameter(name="backupTransportClassNames", desc="comma-separated list of class names for transport to backup servers") String var4, @Parameter(name="backupTransportParams", desc="comma-separated list of key=value parameters for the backup transports (enclosed between { } for each transport)") String var5, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings") String var6) throws Exception;

    public void createConnectionFactory(String var1, String var2, int var3, Object[] var4) throws Exception;

    @Operation(desc="Create a JMS ConnectionFactory", impact=1)
    public void createConnectionFactory(@Parameter(name="name") String var1, @Parameter(name="discoveryAddress") String var2, @Parameter(name="discoveryPort") int var3, @Parameter(name="jndiBindings") String var4) throws Exception;

    @Operation(desc="Destroy a JMS ConnectionFactory", impact=1)
    public void destroyConnectionFactory(@Parameter(name="name", desc="Name of the ConnectionFactory to destroy") String var1) throws Exception;

    @Operation(desc="List the client addresses", impact=0)
    public String[] listRemoteAddresses() throws Exception;

    @Operation(desc="List the client addresses which match the given IP Address", impact=0)
    public String[] listRemoteAddresses(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="Closes all the connections for the given IP Address", impact=0)
    public boolean closeConnectionsForAddress(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="List all the connection IDs", impact=0)
    public String[] listConnectionIDs() throws Exception;

    @Operation(desc="List the sessions for the given connectionID", impact=0)
    public String[] listSessions(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;
}

