/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.management.impl;

import java.util.List;
import javax.management.ObjectName;
import org.hornetq.api.core.management.AddressControl;
import org.hornetq.api.core.management.QueueControl;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.api.jms.management.JMSQueueControl;
import org.hornetq.api.jms.management.JMSServerControl;
import org.hornetq.api.jms.management.TopicControl;
import org.hornetq.core.messagecounter.MessageCounter;
import org.hornetq.core.messagecounter.MessageCounterManager;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.management.impl.JMSConnectionFactoryControlImpl;
import org.hornetq.jms.management.impl.JMSQueueControlImpl;
import org.hornetq.jms.management.impl.JMSServerControlImpl;
import org.hornetq.jms.management.impl.JMSTopicControlImpl;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.management.JMSManagementService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSManagementServiceImpl
implements JMSManagementService {
    private final ManagementService managementService;

    public JMSManagementServiceImpl(ManagementService managementService) {
        this.managementService = managementService;
    }

    @Override
    public synchronized JMSServerControl registerJMSServer(JMSServerManager server) throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getJMSServerObjectName();
        JMSServerControlImpl control = new JMSServerControlImpl(server);
        this.managementService.registerInJMX(objectName, (Object)control);
        this.managementService.registerInRegistry("jms.server", (Object)control);
        return control;
    }

    @Override
    public synchronized void unregisterJMSServer() throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getJMSServerObjectName();
        this.managementService.unregisterFromJMX(objectName);
        this.managementService.unregisterFromRegistry("jms.server");
    }

    @Override
    public synchronized void registerQueue(HornetQDestination queue, String jndiBinding) throws Exception {
        QueueControl coreQueueControl = (QueueControl)this.managementService.getResource("core.queue." + queue.getAddress());
        MessageCounterManager messageCounterManager = this.managementService.getMessageCounterManager();
        MessageCounter counter = new MessageCounter(queue.getName(), null, coreQueueControl, false, coreQueueControl.isDurable(), messageCounterManager.getMaxDayCount());
        messageCounterManager.registerMessageCounter(queue.getName(), counter);
        ObjectName objectName = this.managementService.getObjectNameBuilder().getJMSQueueObjectName(queue.getQueueName());
        JMSQueueControlImpl control = new JMSQueueControlImpl(queue, coreQueueControl, jndiBinding, counter);
        this.managementService.registerInJMX(objectName, (Object)control);
        this.managementService.registerInRegistry("jms.queue." + queue.getQueueName(), (Object)control);
    }

    @Override
    public synchronized void unregisterQueue(String name) throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getJMSQueueObjectName(name);
        this.managementService.unregisterFromJMX(objectName);
        this.managementService.unregisterFromRegistry("jms.queue." + name);
    }

    @Override
    public synchronized void registerTopic(HornetQDestination topic, String jndiBinding) throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getJMSTopicObjectName(topic.getTopicName());
        AddressControl addressControl = (AddressControl)this.managementService.getResource("core.address." + topic.getAddress());
        JMSTopicControlImpl control = new JMSTopicControlImpl(topic, addressControl, jndiBinding, this.managementService);
        this.managementService.registerInJMX(objectName, (Object)control);
        this.managementService.registerInRegistry("jms.topic." + topic.getTopicName(), (Object)control);
    }

    @Override
    public synchronized void unregisterTopic(String name) throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getJMSTopicObjectName(name);
        this.managementService.unregisterFromJMX(objectName);
        this.managementService.unregisterFromRegistry("jms.topic." + name);
    }

    @Override
    public synchronized void registerConnectionFactory(String name, HornetQConnectionFactory connectionFactory, List<String> bindings) throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getConnectionFactoryObjectName(name);
        JMSConnectionFactoryControlImpl control = new JMSConnectionFactoryControlImpl(connectionFactory, name, bindings);
        this.managementService.registerInJMX(objectName, (Object)control);
        this.managementService.registerInRegistry("jms.connectionfactory." + name, (Object)control);
    }

    @Override
    public synchronized void unregisterConnectionFactory(String name) throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getConnectionFactoryObjectName(name);
        this.managementService.unregisterFromJMX(objectName);
        this.managementService.unregisterFromRegistry("jms.connectionfactory." + name);
    }

    @Override
    public void stop() throws Exception {
        for (Object resource : this.managementService.getResources(ConnectionFactoryControl.class)) {
            this.unregisterConnectionFactory(((ConnectionFactoryControl)resource).getName());
        }
        for (Object resource : this.managementService.getResources(JMSQueueControl.class)) {
            this.unregisterQueue(((JMSQueueControl)resource).getName());
        }
        for (Object resource : this.managementService.getResources(TopicControl.class)) {
            this.unregisterTopic(((TopicControl)resource).getName());
        }
    }
}

