/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.management.impl;

import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.StandardMBean;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.management.MessageCounterInfo;
import org.hornetq.api.core.management.QueueControl;
import org.hornetq.api.jms.management.JMSQueueControl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.messagecounter.MessageCounter;
import org.hornetq.core.messagecounter.impl.MessageCounterHelper;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.SelectorTranslator;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSQueueControlImpl
extends StandardMBean
implements JMSQueueControl {
    private static final Logger log = Logger.getLogger(JMSQueueControlImpl.class);
    private final HornetQDestination managedQueue;
    private final JMSServerManager jmsServerManager;
    private final QueueControl coreQueueControl;
    private final MessageCounter counter;

    public static String createFilterFromJMSSelector(String selectorStr) throws HornetQException {
        return selectorStr == null || selectorStr.trim().length() == 0 ? null : SelectorTranslator.convertToHornetQFilterString(selectorStr);
    }

    private static String createFilterForJMSMessageID(String jmsMessageID) throws Exception {
        return HornetQMessage.JMSMESSAGEID_HEADER_NAME + " = '" + jmsMessageID + "'";
    }

    static String toJSON(Map<String, Object>[] messages) {
        JSONArray array = new JSONArray();
        for (Map<String, Object> message : messages) {
            array.put((Object)new JSONObject(message));
        }
        return array.toString();
    }

    public JMSQueueControlImpl(HornetQDestination managedQueue, QueueControl coreQueueControl, JMSServerManager jmsServerManager, MessageCounter counter) throws Exception {
        super(JMSQueueControl.class);
        this.managedQueue = managedQueue;
        this.jmsServerManager = jmsServerManager;
        this.coreQueueControl = coreQueueControl;
        this.counter = counter;
    }

    @Override
    public String getName() {
        return this.managedQueue.getName();
    }

    @Override
    public String getAddress() {
        return this.managedQueue.getAddress();
    }

    @Override
    public boolean isTemporary() {
        return this.managedQueue.isTemporary();
    }

    @Override
    public int getMessageCount() {
        return this.coreQueueControl.getMessageCount();
    }

    @Override
    public long getMessagesAdded() {
        return this.coreQueueControl.getMessagesAdded();
    }

    @Override
    public int getConsumerCount() {
        return this.coreQueueControl.getConsumerCount();
    }

    @Override
    public int getDeliveringCount() {
        return this.coreQueueControl.getDeliveringCount();
    }

    @Override
    public long getScheduledCount() {
        return this.coreQueueControl.getScheduledCount();
    }

    public boolean isDurable() {
        return this.coreQueueControl.isDurable();
    }

    @Override
    public String getDeadLetterAddress() {
        return this.coreQueueControl.getDeadLetterAddress();
    }

    @Override
    public void setDeadLetterAddress(String deadLetterAddress) throws Exception {
        this.coreQueueControl.setDeadLetterAddress(deadLetterAddress);
    }

    @Override
    public String getExpiryAddress() {
        return this.coreQueueControl.getExpiryAddress();
    }

    @Override
    public void setExpiryAddress(String expiryAddres) throws Exception {
        this.coreQueueControl.setExpiryAddress(expiryAddres);
    }

    @Override
    public void addJNDI(String jndi) throws Exception {
        this.jmsServerManager.addQueueToJndi(this.managedQueue.getName(), jndi);
    }

    @Override
    public String[] getJNDIBindings() {
        return this.jmsServerManager.getJNDIOnQueue(this.managedQueue.getName());
    }

    @Override
    public boolean removeMessage(String messageID) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int removed = this.coreQueueControl.removeMessages(filter);
        if (removed != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    @Override
    public int removeMessages(String filterStr) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.removeMessages(filter);
    }

    @Override
    public Map<String, Object>[] listMessages(String filterStr) throws Exception {
        try {
            String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
            Map[] coreMessages = this.coreQueueControl.listMessages(filter);
            Map[] jmsMessages = new Map[coreMessages.length];
            int i = 0;
            for (Map coreMessage : coreMessages) {
                Map<String, Object> jmsMessage = HornetQMessage.coreMaptoJMSMap(coreMessage);
                jmsMessages[i++] = jmsMessage;
            }
            return jmsMessages;
        }
        catch (HornetQException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public String listMessagesAsJSON(String filter) throws Exception {
        return JMSQueueControlImpl.toJSON(this.listMessages(filter));
    }

    @Override
    public int countMessages(String filterStr) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.countMessages(filter);
    }

    @Override
    public boolean expireMessage(String messageID) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int expired = this.coreQueueControl.expireMessages(filter);
        if (expired != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    @Override
    public int expireMessages(String filterStr) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.expireMessages(filter);
    }

    @Override
    public boolean sendMessageToDeadLetterAddress(String messageID) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int dead = this.coreQueueControl.sendMessagesToDeadLetterAddress(filter);
        if (dead != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    @Override
    public int sendMessagesToDeadLetterAddress(String filterStr) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.sendMessagesToDeadLetterAddress(filter);
    }

    @Override
    public boolean changeMessagePriority(String messageID, int newPriority) throws Exception {
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int changed = this.coreQueueControl.changeMessagesPriority(filter, newPriority);
        if (changed != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    @Override
    public int changeMessagesPriority(String filterStr, int newPriority) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        return this.coreQueueControl.changeMessagesPriority(filter, newPriority);
    }

    @Override
    public boolean moveMessage(String messageID, String otherQueueName) throws Exception {
        HornetQDestination otherQueue;
        String filter = JMSQueueControlImpl.createFilterForJMSMessageID(messageID);
        int moved = this.coreQueueControl.moveMessages(filter, (otherQueue = HornetQDestination.createQueue(otherQueueName)).getAddress());
        if (moved != 1) {
            throw new IllegalArgumentException("No message found for JMSMessageID: " + messageID);
        }
        return true;
    }

    @Override
    public int moveMessages(String filterStr, String otherQueueName) throws Exception {
        String filter = JMSQueueControlImpl.createFilterFromJMSSelector(filterStr);
        HornetQDestination otherQueue = HornetQDestination.createQueue(otherQueueName);
        return this.coreQueueControl.moveMessages(filter, otherQueue.getAddress());
    }

    @Override
    public String listMessageCounter() {
        try {
            return MessageCounterInfo.toJSon((MessageCounter)this.counter);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void resetMessageCounter() throws Exception {
        this.coreQueueControl.resetMessageCounter();
    }

    @Override
    public String listMessageCounterAsHTML() {
        return MessageCounterHelper.listMessageCounterAsHTML((MessageCounter[])new MessageCounter[]{this.counter});
    }

    @Override
    public String listMessageCounterHistory() throws Exception {
        return MessageCounterHelper.listMessageCounterHistory((MessageCounter)this.counter);
    }

    @Override
    public String listMessageCounterHistoryAsHTML() {
        return MessageCounterHelper.listMessageCounterHistoryAsHTML((MessageCounter[])new MessageCounter[]{this.counter});
    }

    @Override
    public boolean isPaused() throws Exception {
        return this.coreQueueControl.isPaused();
    }

    @Override
    public void pause() throws Exception {
        this.coreQueueControl.pause();
    }

    @Override
    public void resume() throws Exception {
        this.coreQueueControl.resume();
    }

    @Override
    public String getSelector() {
        return this.coreQueueControl.getFilter();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), MBeanInfoHelper.getMBeanOperationsInfo(JMSQueueControl.class), info.getNotifications());
    }
}

