/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.bridge.impl;

import javax.management.StandardMBean;
import org.hornetq.jms.bridge.JMSBridge;
import org.hornetq.jms.bridge.JMSBridgeControl;
import org.hornetq.jms.bridge.QualityOfServiceMode;

public class JMSBridgeControlImpl
extends StandardMBean
implements JMSBridgeControl {
    private final JMSBridge bridge;

    public JMSBridgeControlImpl(JMSBridge bridge) throws Exception {
        super(JMSBridgeControl.class);
        this.bridge = bridge;
    }

    public void pause() throws Exception {
        this.bridge.pause();
    }

    public void resume() throws Exception {
        this.bridge.resume();
    }

    public boolean isStarted() {
        return this.bridge.isStarted();
    }

    public void start() throws Exception {
        this.bridge.start();
    }

    public void stop() throws Exception {
        this.bridge.stop();
    }

    public String getClientID() {
        return this.bridge.getClientID();
    }

    public long getFailureRetryInterval() {
        return this.bridge.getFailureRetryInterval();
    }

    public int getMaxBatchSize() {
        return this.bridge.getMaxBatchSize();
    }

    public long getMaxBatchTime() {
        return this.bridge.getMaxBatchTime();
    }

    public int getMaxRetries() {
        return this.bridge.getMaxRetries();
    }

    public String getQualityOfServiceMode() {
        QualityOfServiceMode mode = this.bridge.getQualityOfServiceMode();
        if (mode != null) {
            return mode.name();
        }
        return null;
    }

    public String getSelector() {
        return this.bridge.getSelector();
    }

    public String getSourcePassword() {
        return this.bridge.getSourcePassword();
    }

    public String getSourceUsername() {
        return this.bridge.getSourceUsername();
    }

    public String getSubscriptionName() {
        return this.bridge.getSubscriptionName();
    }

    public String getTargetPassword() {
        return this.bridge.getTargetPassword();
    }

    public String getTargetUsername() {
        return this.bridge.getTargetUsername();
    }

    public String getTransactionManagerLocatorClass() {
        return this.bridge.getTransactionManagerLocatorClass();
    }

    public String getTransactionManagerLocatorMethod() {
        return this.bridge.getTransactionManagerLocatorMethod();
    }

    public boolean isAddMessageIDInHeader() {
        return this.bridge.isAddMessageIDInHeader();
    }

    public boolean isFailed() {
        return this.bridge.isFailed();
    }

    public boolean isPaused() {
        return this.bridge.isPaused();
    }

    public void setAddMessageIDInHeader(boolean value) {
        this.bridge.setAddMessageIDInHeader(value);
    }

    public void setClientID(String clientID) {
        this.bridge.setClientID(clientID);
    }

    public void setFailureRetryInterval(long interval) {
        this.bridge.setFailureRetryInterval(interval);
    }

    public void setMaxBatchSize(int size) {
        this.bridge.setMaxBatchSize(size);
    }

    public void setMaxBatchTime(long time) {
        this.bridge.setMaxBatchTime(time);
    }

    public void setMaxRetries(int retries) {
        this.bridge.setMaxRetries(retries);
    }

    public void setQualityOfServiceMode(String mode) {
        if (mode != null) {
            this.bridge.setQualityOfServiceMode(QualityOfServiceMode.valueOf(mode));
        } else {
            mode = null;
        }
    }

    public void setSelector(String selector) {
        this.bridge.setSelector(selector);
    }

    public void setSourcePassword(String pwd) {
        this.bridge.setSourcePassword(pwd);
    }

    public void setSourceUsername(String name) {
        this.bridge.setSourceUsername(name);
    }

    public void setSubscriptionName(String subname) {
        this.bridge.setSubscriptionName(subname);
    }

    public void setTargetPassword(String pwd) {
        this.bridge.setTargetPassword(pwd);
    }

    public void setTargetUsername(String name) {
        this.bridge.setTargetUsername(name);
    }

    public void setTransactionManagerLocatorClass(String transactionManagerLocatorClass) {
        this.bridge.setTransactionManagerLocatorClass(transactionManagerLocatorClass);
    }

    public void setTransactionManagerLocatorMethod(String transactionManagerLocatorMethod) {
        this.bridge.setTransactionManagerLocatorMethod(transactionManagerLocatorMethod);
    }
}

