/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.management.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.Parameter;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.api.jms.management.JMSQueueControl;
import org.hornetq.api.jms.management.JMSServerControl;
import org.hornetq.api.jms.management.TopicControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.jms.server.JMSServerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSServerControlImpl
extends StandardMBean
implements JMSServerControl,
NotificationEmitter {
    private final JMSServerManager server;
    private final NotificationBroadcasterSupport broadcaster;
    private final AtomicLong notifSeq = new AtomicLong(0L);

    private static String[] convert(Object[] jndiBindings) {
        String[] bindings = new String[jndiBindings.length];
        int jndiBindingsLength = jndiBindings.length;
        for (int i = 0; i < jndiBindingsLength; ++i) {
            bindings[i] = jndiBindings[i].toString().trim();
        }
        return bindings;
    }

    private static String[] toArray(String commaSeparatedString) {
        if (commaSeparatedString == null || commaSeparatedString.trim().length() == 0) {
            return new String[0];
        }
        String[] values = commaSeparatedString.split(",");
        String[] trimmed = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            trimmed[i] = values[i].trim();
            trimmed[i] = trimmed[i].replace("&comma;", ",");
        }
        return trimmed;
    }

    private static List<Pair<TransportConfiguration, TransportConfiguration>> convertToConnectorPairs(Object[] liveConnectorsTransportClassNames, Object[] liveConnectorTransportParams, Object[] backupConnectorsTransportClassNames, Object[] backupConnectorTransportParams) {
        ArrayList<Pair<TransportConfiguration, TransportConfiguration>> pairs = new ArrayList<Pair<TransportConfiguration, TransportConfiguration>>();
        for (int i = 0; i < liveConnectorsTransportClassNames.length; ++i) {
            Map liveParams = null;
            if (liveConnectorTransportParams.length > i) {
                liveParams = (Map)liveConnectorTransportParams[i];
            }
            TransportConfiguration tcLive = new TransportConfiguration(liveConnectorsTransportClassNames[i].toString(), liveParams);
            Map backupParams = null;
            if (backupConnectorTransportParams.length > i) {
                backupParams = (Map)backupConnectorTransportParams[i];
            }
            Object tcBackup = null;
            if (backupConnectorsTransportClassNames.length > i) {
                new TransportConfiguration(backupConnectorsTransportClassNames[i].toString(), backupParams);
            }
            Pair pair = new Pair((Object)tcLive, tcBackup);
            pairs.add((Pair<TransportConfiguration, TransportConfiguration>)pair);
        }
        return pairs;
    }

    public static MBeanNotificationInfo[] getNotificationInfos() {
        NotificationType[] values = NotificationType.values();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].toString();
        }
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(names, JMSServerControl.class.getName(), "Notifications emitted by a JMS Server")};
    }

    public JMSServerControlImpl(JMSServerManager server) throws Exception {
        super(JMSServerControl.class);
        this.server = server;
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createConnectionFactory(String name, String liveTransportClassName, Map<String, Object> liveTransportParams, Object[] jndiBindings) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            TransportConfiguration liveTC = new TransportConfiguration(liveTransportClassName, liveTransportParams);
            this.server.createConnectionFactory(name, liveTC, JMSServerControlImpl.convert(jndiBindings));
            this.sendNotification(NotificationType.CONNECTION_FACTORY_CREATED, name);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createConnectionFactory(String name, Object[] liveConnectorsTransportClassNames, Object[] liveConnectorTransportParams, Object[] backupConnectorsTransportClassNames, Object[] backupConnectorTransportParams, Object[] jndiBindings) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            List<Pair<TransportConfiguration, TransportConfiguration>> pairs = JMSServerControlImpl.convertToConnectorPairs(liveConnectorsTransportClassNames, liveConnectorTransportParams, backupConnectorsTransportClassNames, backupConnectorTransportParams);
            this.server.createConnectionFactory(name, pairs, JMSServerControlImpl.convert(jndiBindings));
            this.sendNotification(NotificationType.CONNECTION_FACTORY_CREATED, name);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createConnectionFactory(String name, String liveTransportClassNames, String liveTransportParams, String backupTransportClassNames, String backupTransportParams, String jndiBindings) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] liveClassNames = JMSServerControlImpl.toArray(liveTransportClassNames);
            Object[] liveParams = ManagementHelper.fromCommaSeparatedArrayOfCommaSeparatedKeyValues((String)liveTransportParams);
            Object[] backupClassNames = JMSServerControlImpl.toArray(backupTransportClassNames);
            Object[] backupParams = ManagementHelper.fromCommaSeparatedArrayOfCommaSeparatedKeyValues((String)backupTransportParams);
            Object[] bindings = JMSServerControlImpl.toArray(jndiBindings);
            this.createConnectionFactory(name, liveClassNames, liveParams, backupClassNames, backupParams, bindings);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createConnectionFactory(String name, String discoveryAddress, int discoveryPort, Object[] jndiBindings) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.server.createConnectionFactory(name, discoveryAddress, discoveryPort, JMSServerControlImpl.convert(jndiBindings));
            this.sendNotification(NotificationType.CONNECTION_FACTORY_CREATED, name);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createConnectionFactory(String name, String discoveryAddress, int discoveryPort, String jndiBindings) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] bindings = JMSServerControlImpl.toArray(jndiBindings);
            this.createConnectionFactory(name, discoveryAddress, discoveryPort, bindings);
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean createQueue(@Parameter(name="name", desc="Name of the queue to create") String name) throws Exception {
        return this.createQueue(name, null, null);
    }

    @Override
    public boolean createQueue(String name, String jndiBindings) throws Exception {
        return this.createQueue(name, jndiBindings, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createQueue(@Parameter(name="name", desc="Name of the queue to create") String name, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings (use '&comma;' if u need to use commas in your jndi name)") String jndiBindings, @Parameter(name="selector", desc="the jms selector") String selector) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean created = this.server.createQueue(true, name, selector, true, JMSServerControlImpl.toArray(jndiBindings));
            if (created) {
                this.sendNotification(NotificationType.QUEUE_CREATED, name);
            }
            boolean bl = created;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroyQueue(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean destroyed = this.server.destroyQueue(name);
            if (destroyed) {
                this.sendNotification(NotificationType.QUEUE_DESTROYED, name);
            }
            boolean bl = destroyed;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean createTopic(@Parameter(name="name", desc="Name of the topic to create") String name) throws Exception {
        return this.createTopic(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createTopic(String topicName, String jndiBindings) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean created = this.server.createTopic(true, topicName, JMSServerControlImpl.toArray(jndiBindings));
            if (created) {
                this.sendNotification(NotificationType.TOPIC_CREATED, topicName);
            }
            boolean bl = created;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroyTopic(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean destroyed = this.server.destroyTopic(name);
            if (destroyed) {
                this.sendNotification(NotificationType.TOPIC_DESTROYED, name);
            }
            boolean bl = destroyed;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyConnectionFactory(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean destroyed = this.server.destroyConnectionFactory(name);
            if (destroyed) {
                this.sendNotification(NotificationType.CONNECTION_FACTORY_DESTROYED, name);
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean isStarted() {
        return this.server.isStarted();
    }

    @Override
    public String getVersion() {
        this.checkStarted();
        return this.server.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getQueueNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] queueControls = this.server.getHornetQServer().getManagementService().getResources(JMSQueueControl.class);
            String[] names = new String[queueControls.length];
            for (int i = 0; i < queueControls.length; ++i) {
                JMSQueueControl queueControl = (JMSQueueControl)queueControls[i];
                names[i] = queueControl.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getTopicNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] topicControls = this.server.getHornetQServer().getManagementService().getResources(TopicControl.class);
            String[] names = new String[topicControls.length];
            for (int i = 0; i < topicControls.length; ++i) {
                TopicControl topicControl = (TopicControl)topicControls[i];
                names[i] = topicControl.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getConnectionFactoryNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] cfControls = this.server.getHornetQServer().getManagementService().getResources(ConnectionFactoryControl.class);
            String[] names = new String[cfControls.length];
            for (int i = 0; i < cfControls.length; ++i) {
                ConnectionFactoryControl cfControl = (ConnectionFactoryControl)cfControls[i];
                names[i] = cfControl.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return JMSServerControlImpl.getNotificationInfos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listRemoteAddresses() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listRemoteAddresses();
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listRemoteAddresses(String ipAddress) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listRemoteAddresses(ipAddress);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeConnectionsForAddress(String ipAddress) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.closeConnectionsForAddress(ipAddress);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listConnectionIDs() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listConnectionIDs();
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listSessions(String connectionID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listSessions(connectionID);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), MBeanInfoHelper.getMBeanOperationsInfo(JMSServerControl.class), info.getNotifications());
    }

    private void sendNotification(NotificationType type, String message) {
        Notification notif = new Notification(type.toString(), (Object)this, this.notifSeq.incrementAndGet(), message);
        this.broadcaster.sendNotification(notif);
    }

    private void checkStarted() {
        if (!this.server.isStarted()) {
            throw new IllegalStateException("HornetQ JMS Server is not started. it can not be managed yet");
        }
    }

    protected void clearIO() {
        if (this.server.getHornetQServer().getStorageManager() != null) {
            this.server.getHornetQServer().getStorageManager().clearContext();
        }
    }

    protected void blockOnIO() {
        if (this.server.getHornetQServer().getStorageManager() != null) {
            try {
                this.server.getHornetQServer().getStorageManager().waitOnOperations();
                this.server.getHornetQServer().getStorageManager().clearContext();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private static List<String> toList(String commaSeparatedString) {
        ArrayList<String> list = new ArrayList<String>();
        if (commaSeparatedString == null || commaSeparatedString.trim().length() == 0) {
            return list;
        }
        String[] values = commaSeparatedString.split(",");
        for (int i = 0; i < values.length; ++i) {
            list.add(values[i].trim());
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NotificationType {
        QUEUE_CREATED,
        QUEUE_DESTROYED,
        TOPIC_CREATED,
        TOPIC_DESTROYED,
        CONNECTION_FACTORY_CREATED,
        CONNECTION_FACTORY_DESTROYED;

    }
}

