/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.persistence.config;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.jms.persistence.config.PersistedType;
import org.hornetq.utils.BufferHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistedJNDI
implements EncodingSupport {
    private long id;
    private PersistedType type;
    private String name;
    private ArrayList<String> jndi = new ArrayList();

    public PersistedJNDI() {
    }

    public PersistedJNDI(PersistedType type, String name) {
        this.type = type;
        this.name = name;
    }

    public void decode(HornetQBuffer buffer) {
        this.type = PersistedType.getType(buffer.readByte());
        this.name = buffer.readSimpleString().toString();
        int jndiArraySize = buffer.readInt();
        this.jndi = new ArrayList(jndiArraySize);
        for (int i = 0; i < jndiArraySize; ++i) {
            this.jndi.add(buffer.readSimpleString().toString());
        }
    }

    public void encode(HornetQBuffer buffer) {
        buffer.writeByte(this.type.getType());
        BufferHelper.writeAsSimpleString((HornetQBuffer)buffer, (String)this.name);
        buffer.writeInt(this.jndi.size());
        for (String jndiEl : this.jndi) {
            BufferHelper.writeAsSimpleString((HornetQBuffer)buffer, (String)jndiEl);
        }
    }

    public int getEncodeSize() {
        return 1 + BufferHelper.sizeOfSimpleString((String)this.name) + this.sizeOfJNDI();
    }

    private int sizeOfJNDI() {
        int size = 4;
        for (String str : this.jndi) {
            size += BufferHelper.sizeOfSimpleString((String)str);
        }
        return size;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public PersistedType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getJndi() {
        return this.jndi;
    }

    public void addJNDI(String address) {
        this.jndi.add(address);
    }

    public void deleteJNDI(String address) {
        this.jndi.remove(address);
    }
}

