/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.management.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import org.hornetq.api.core.management.Parameter;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.api.jms.management.DestinationControl;
import org.hornetq.api.jms.management.JMSQueueControl;
import org.hornetq.api.jms.management.JMSServerControl;
import org.hornetq.api.jms.management.TopicControl;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.server.ServerConsumer;
import org.hornetq.core.server.ServerSession;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.impl.JMSFactoryType;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONObject;

public class JMSServerControlImpl
extends StandardMBean
implements JMSServerControl,
NotificationEmitter {
    private final JMSServerManager server;
    private final NotificationBroadcasterSupport broadcaster;
    private final AtomicLong notifSeq = new AtomicLong(0L);

    private static String[] convert(Object[] jndiBindings) {
        String[] bindings = new String[jndiBindings.length];
        int jndiBindingsLength = jndiBindings.length;
        for (int i = 0; i < jndiBindingsLength; ++i) {
            bindings[i] = jndiBindings[i].toString().trim();
        }
        return bindings;
    }

    private static String[] toArray(String commaSeparatedString) {
        if (commaSeparatedString == null || commaSeparatedString.trim().length() == 0) {
            return new String[0];
        }
        String[] values = commaSeparatedString.split(",");
        String[] trimmed = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            trimmed[i] = values[i].trim();
            trimmed[i] = trimmed[i].replace("&comma;", ",");
        }
        return trimmed;
    }

    private static String[] determineJMSDestination(String coreAddress) {
        String[] result = new String[2];
        if (coreAddress.startsWith("jms.queue.")) {
            result[0] = coreAddress.substring("jms.queue.".length());
            result[1] = "queue";
        } else if (coreAddress.startsWith("jms.tempqueue.")) {
            result[0] = coreAddress.substring("jms.tempqueue.".length());
            result[1] = "tempqueue";
        } else if (coreAddress.startsWith("jms.topic.")) {
            result[0] = coreAddress.substring("jms.topic.".length());
            result[1] = "topic";
        } else if (coreAddress.startsWith("jms.temptopic.")) {
            result[0] = coreAddress.substring("jms.temptopic.".length());
            result[1] = "temptopic";
        } else {
            System.out.println("JMSServerControlImpl.determineJMSDestination()" + coreAddress);
            return null;
        }
        return result;
    }

    public static MBeanNotificationInfo[] getNotificationInfos() {
        NotificationType[] values = NotificationType.values();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].toString();
        }
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(names, JMSServerControl.class.getName(), "Notifications emitted by a JMS Server")};
    }

    public JMSServerControlImpl(JMSServerManager server) throws Exception {
        super(JMSServerControl.class);
        this.server = server;
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createConnectionFactory(String name, boolean ha, boolean useDiscovery, int cfType, String[] connectorNames, Object[] bindings) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            if (useDiscovery) {
                if (connectorNames == null || connectorNames.length == 0) {
                    throw new IllegalArgumentException("no discovery group name supplied");
                }
                this.server.createConnectionFactory(name, ha, JMSFactoryType.valueOf(cfType), connectorNames[0], JMSServerControlImpl.convert(bindings));
            } else {
                ArrayList<String> connectorList = new ArrayList<String>(connectorNames.length);
                for (String str : connectorNames) {
                    connectorList.add(str);
                }
                this.server.createConnectionFactory(name, ha, JMSFactoryType.valueOf(cfType), connectorList, JMSServerControlImpl.convert(bindings));
            }
            this.sendNotification(NotificationType.CONNECTION_FACTORY_CREATED, name);
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void createConnectionFactory(String name, boolean ha, boolean useDiscovery, int cfType, String connectors, String jndiBindings) throws Exception {
        this.createConnectionFactory(name, ha, useDiscovery, cfType, JMSServerControlImpl.toArray(connectors), JMSServerControlImpl.toArray(jndiBindings));
    }

    @Override
    public boolean createQueue(String name) throws Exception {
        return this.createQueue(name, null, null, true);
    }

    @Override
    public boolean createQueue(String name, String jndiBindings) throws Exception {
        return this.createQueue(name, jndiBindings, null, true);
    }

    @Override
    public boolean createQueue(String name, String jndiBindings, String selector) throws Exception {
        return this.createQueue(name, jndiBindings, selector, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createQueue(@Parameter(name="name", desc="Name of the queue to create") String name, @Parameter(name="jndiBindings", desc="comma-separated list of JNDI bindings (use '&comma;' if u need to use commas in your jndi name)") String jndiBindings, @Parameter(name="selector", desc="the jms selector") String selector, @Parameter(name="durable", desc="is the queue persistent and resilient to restart") boolean durable) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean created = this.server.createQueue(true, name, selector, durable, JMSServerControlImpl.toArray(jndiBindings));
            if (created) {
                this.sendNotification(NotificationType.QUEUE_CREATED, name);
            }
            boolean bl = created;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroyQueue(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean destroyed = this.server.destroyQueue(name);
            if (destroyed) {
                this.sendNotification(NotificationType.QUEUE_DESTROYED, name);
            }
            boolean bl = destroyed;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean createTopic(String name) throws Exception {
        return this.createTopic(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createTopic(String topicName, String jndiBindings) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean created = this.server.createTopic(true, topicName, JMSServerControlImpl.toArray(jndiBindings));
            if (created) {
                this.sendNotification(NotificationType.TOPIC_CREATED, topicName);
            }
            boolean bl = created;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroyTopic(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean destroyed = this.server.destroyTopic(name);
            if (destroyed) {
                this.sendNotification(NotificationType.TOPIC_DESTROYED, name);
            }
            boolean bl = destroyed;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyConnectionFactory(String name) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean destroyed = this.server.destroyConnectionFactory(name);
            if (destroyed) {
                this.sendNotification(NotificationType.CONNECTION_FACTORY_DESTROYED, name);
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean isStarted() {
        return this.server.isStarted();
    }

    @Override
    public String getVersion() {
        this.checkStarted();
        return this.server.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getQueueNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] queueControls = this.server.getHornetQServer().getManagementService().getResources(JMSQueueControl.class);
            String[] names = new String[queueControls.length];
            for (int i = 0; i < queueControls.length; ++i) {
                JMSQueueControl queueControl = (JMSQueueControl)queueControls[i];
                names[i] = queueControl.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getTopicNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] topicControls = this.server.getHornetQServer().getManagementService().getResources(TopicControl.class);
            String[] names = new String[topicControls.length];
            for (int i = 0; i < topicControls.length; ++i) {
                TopicControl topicControl = (TopicControl)topicControls[i];
                names[i] = topicControl.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getConnectionFactoryNames() {
        this.checkStarted();
        this.clearIO();
        try {
            Object[] cfControls = this.server.getHornetQServer().getManagementService().getResources(ConnectionFactoryControl.class);
            String[] names = new String[cfControls.length];
            for (int i = 0; i < cfControls.length; ++i) {
                ConnectionFactoryControl cfControl = (ConnectionFactoryControl)cfControls[i];
                names[i] = cfControl.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return JMSServerControlImpl.getNotificationInfos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listRemoteAddresses() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listRemoteAddresses();
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listRemoteAddresses(String ipAddress) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listRemoteAddresses(ipAddress);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeConnectionsForAddress(String ipAddress) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.closeConnectionsForAddress(ipAddress);
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listConnectionIDs() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listConnectionIDs();
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listConnectionsAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            JSONArray array = new JSONArray();
            Set connections = this.server.getHornetQServer().getRemotingService().getConnections();
            Set sessions = this.server.getHornetQServer().getSessions();
            HashMap<Object, ServerSession> jmsSessions = new HashMap<Object, ServerSession>();
            for (ServerSession session : sessions) {
                if (session.getMetaData("jms-session") == null) continue;
                jmsSessions.put(session.getConnectionID(), session);
            }
            for (RemotingConnection connection : connections) {
                JSONObject obj = new JSONObject();
                obj.put("connectionID", (Object)connection.getID().toString());
                obj.put("clientAddress", (Object)connection.getRemoteAddress());
                obj.put("creationTime", connection.getCreationTime());
                obj.put("clientID", (Object)((ServerSession)jmsSessions.get(connection.getID())).getMetaData("jms-client-id"));
                obj.put("principal", (Object)((ServerSession)jmsSessions.get(connection.getID())).getUsername());
                array.put((Object)obj);
            }
            String string = array.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listConsumersAsJSON(String connectionID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            JSONArray array = new JSONArray();
            Set connections = this.server.getHornetQServer().getRemotingService().getConnections();
            for (RemotingConnection connection : connections) {
                if (!connectionID.equals(connection.getID().toString())) continue;
                List sessions = this.server.getHornetQServer().getSessions(connectionID);
                for (ServerSession session : sessions) {
                    Set consumers = session.getServerConsumers();
                    for (ServerConsumer consumer : consumers) {
                        String[] destinationInfo;
                        JSONObject obj = new JSONObject();
                        obj.put("consumerID", consumer.getID());
                        obj.put("connectionID", (Object)connectionID);
                        obj.put("queueName", (Object)consumer.getQueue().getName().toString());
                        obj.put("browseOnly", consumer.isBrowseOnly());
                        obj.put("creationTime", consumer.getCreationTime());
                        Filter queueFilter = consumer.getQueue().getFilter();
                        if (queueFilter != null) {
                            obj.put("filter", (Object)queueFilter.getFilterString().toString());
                        }
                        if ((destinationInfo = JMSServerControlImpl.determineJMSDestination(consumer.getQueue().getAddress().toString())) == null) continue;
                        obj.put("destinationName", (Object)destinationInfo[0]);
                        obj.put("destinationType", (Object)destinationInfo[1]);
                        if (destinationInfo[1].equals("topic")) {
                            try {
                                HornetQDestination.decomposeQueueNameForDurableSubscription(consumer.getQueue().getName().toString());
                                obj.put("durable", true);
                            }
                            catch (IllegalArgumentException e) {
                                obj.put("durable", false);
                            }
                        } else {
                            obj.put("durable", false);
                        }
                        array.put((Object)obj);
                    }
                }
            }
            String string = array.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listSessions(String connectionID) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.listSessions(connectionID);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listPreparedTransactionDetailsAsJSON() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.server.listPreparedTransactionDetailsAsJSON();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listPreparedTransactionDetailsAsHTML() throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.server.listPreparedTransactionDetailsAsHTML();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), MBeanInfoHelper.getMBeanOperationsInfo(JMSServerControl.class), info.getNotifications());
    }

    private void sendNotification(NotificationType type, String message) {
        Notification notif = new Notification(type.toString(), (Object)this, this.notifSeq.incrementAndGet(), message);
        this.broadcaster.sendNotification(notif);
    }

    private void checkStarted() {
        if (!this.server.isStarted()) {
            throw new IllegalStateException("HornetQ JMS Server is not started. it can not be managed yet");
        }
    }

    protected void clearIO() {
        if (this.server.getHornetQServer().getStorageManager() != null) {
            this.server.getHornetQServer().getStorageManager().clearContext();
        }
    }

    protected void blockOnIO() {
        if (this.server.getHornetQServer().getStorageManager() != null) {
            try {
                this.server.getHornetQServer().getStorageManager().waitOnOperations();
                this.server.getHornetQServer().getStorageManager().clearContext();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private static List<String> toList(String commaSeparatedString) {
        ArrayList<String> list = new ArrayList<String>();
        if (commaSeparatedString == null || commaSeparatedString.trim().length() == 0) {
            return list;
        }
        String[] values = commaSeparatedString.split(",");
        for (int i = 0; i < values.length; ++i) {
            list.add(values[i].trim());
        }
        return list;
    }

    @Override
    public String[] listTargetDestinations(String sessionID) throws Exception {
        String[] addresses = this.server.getHornetQServer().getHornetQServerControl().listTargetAddresses(sessionID);
        HashMap<String, DestinationControl> allDests = new HashMap<String, DestinationControl>();
        Object[] queueControls = this.server.getHornetQServer().getManagementService().getResources(JMSQueueControl.class);
        for (int i = 0; i < queueControls.length; ++i) {
            JMSQueueControl queueControl = (JMSQueueControl)queueControls[i];
            allDests.put(queueControl.getAddress(), queueControl);
        }
        Object[] topicControls = this.server.getHornetQServer().getManagementService().getResources(TopicControl.class);
        for (int i = 0; i < topicControls.length; ++i) {
            TopicControl topicControl = (TopicControl)topicControls[i];
            allDests.put(topicControl.getAddress(), topicControl);
        }
        ArrayList<String> destinations = new ArrayList<String>();
        for (int i = 0; i < addresses.length; ++i) {
            DestinationControl control = (DestinationControl)allDests.get(addresses[i]);
            if (control == null) continue;
            destinations.add(control.getAddress());
        }
        return destinations.toArray(new String[0]);
    }

    @Override
    public String getLastSentMessageID(String sessionID, String address) throws Exception {
        ServerSession session = this.server.getHornetQServer().getSessionByID(sessionID);
        if (session != null) {
            return session.getLastSentMessageID(address);
        }
        return null;
    }

    @Override
    public String getSessionCreationTime(String sessionID) throws Exception {
        ServerSession session = this.server.getHornetQServer().getSessionByID(sessionID);
        if (session != null) {
            return String.valueOf(session.getCreationTime());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listSessionsAsJSON(String connectionID) throws Exception {
        this.checkStarted();
        this.clearIO();
        JSONArray array = new JSONArray();
        try {
            List sessions = this.server.getHornetQServer().getSessions(connectionID);
            for (ServerSession sess : sessions) {
                JSONObject obj = new JSONObject();
                obj.put("sessionID", (Object)sess.getName());
                obj.put("creationTime", sess.getCreationTime());
                array.put((Object)obj);
            }
        }
        finally {
            this.blockOnIO();
        }
        return array.toString();
    }

    public static enum NotificationType {
        QUEUE_CREATED,
        QUEUE_DESTROYED,
        TOPIC_CREATED,
        TOPIC_DESTROYED,
        CONNECTION_FACTORY_CREATED,
        CONNECTION_FACTORY_DESTROYED;

    }
}

