/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.recovery;

import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.server.recovery.HornetQRecoveryRegistry;
import org.hornetq.jms.server.recovery.XARecoveryConfig;

public class RecoveryDiscovery {
    Logger log = Logger.getLogger(RecoveryDiscovery.class);
    private ServerLocator locator;
    private ClientSessionFactory sessionFactory;
    private final XARecoveryConfig config;
    private final AtomicInteger usage = new AtomicInteger(0);
    private boolean started = false;

    public RecoveryDiscovery(XARecoveryConfig config) {
        this.config = config;
    }

    public synchronized void start() {
        if (!this.started) {
            this.log.debug((Object)("Starting RecoveryDiscovery on " + this.config));
            this.started = true;
            this.locator = this.config.createServerLocator();
            this.locator.setReconnectAttempts(-1);
            this.locator.setRetryInterval(1000L);
            this.locator.setRetryIntervalMultiplier(2.0);
            this.locator.setMaxRetryInterval(60000L);
            this.locator.addClusterTopologyListener((ClusterTopologyListener)new InternalListener());
            try {
                this.sessionFactory = this.locator.createSessionFactory();
            }
            catch (Exception startupError) {
                this.log.warn((Object)("Couldn't start recovery discovery on " + this.config + ", we will retry this on the next recovery scan"));
                this.stop();
                HornetQRecoveryRegistry.getInstance().failedDiscovery(this);
            }
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            try {
                if (this.sessionFactory != null) {
                    this.sessionFactory.close();
                }
            }
            catch (Exception ignored) {
                this.log.debug((Object)ignored, (Throwable)ignored);
            }
            try {
                this.locator.close();
            }
            catch (Exception ignored) {
                this.log.debug((Object)ignored, (Throwable)ignored);
            }
            this.sessionFactory = null;
            this.locator = null;
        }
    }

    public int incrementUsage() {
        return this.usage.decrementAndGet();
    }

    public int decrementUsage() {
        return this.usage.incrementAndGet();
    }

    class InternalListener
    implements ClusterTopologyListener {
        InternalListener() {
        }

        public void nodeUP(long eventUID, String nodeID, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean last) {
            if (connectorPair.getA() != null) {
                HornetQRecoveryRegistry.getInstance().nodeUp(nodeID, (Pair<TransportConfiguration, TransportConfiguration>)new Pair(connectorPair.getA(), connectorPair.getB()), RecoveryDiscovery.this.config.getUsername(), RecoveryDiscovery.this.config.getPassword());
            }
        }

        public void nodeDown(long eventUID, String nodeID) {
        }
    }
}

