/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.recovery;

import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.jms.HornetQJMSLogger;
import org.hornetq.jms.server.recovery.HornetQRecoveryRegistry;
import org.hornetq.jms.server.recovery.XARecoveryConfig;

public class RecoveryDiscovery
implements SessionFailureListener {
    private ServerLocator locator;
    private ClientSessionFactoryInternal sessionFactory;
    private final XARecoveryConfig config;
    private final AtomicInteger usage = new AtomicInteger(0);
    private boolean started = false;

    public RecoveryDiscovery(XARecoveryConfig config) {
        this.config = config;
    }

    public synchronized void start() {
        if (!this.started) {
            HornetQJMSLogger.LOGGER.debug("Starting RecoveryDiscovery on " + this.config);
            this.started = true;
            this.locator = this.config.createServerLocator();
            this.locator.disableFinalizeCheck();
            this.locator.addClusterTopologyListener((ClusterTopologyListener)new InternalListener());
            try {
                this.sessionFactory = (ClientSessionFactoryInternal)this.locator.createSessionFactory();
                this.sessionFactory.addFailureListener((SessionFailureListener)this);
                HornetQJMSLogger.LOGGER.debug("RecoveryDiscovery started fine on " + this.config);
            }
            catch (Exception startupError) {
                HornetQJMSLogger.LOGGER.warn("Couldn't start recovery discovery on " + this.config + ", we will retry this on the next recovery scan");
                this.stop();
                HornetQRecoveryRegistry.getInstance().failedDiscovery(this);
            }
        }
    }

    public synchronized void stop() {
        this.internalStop();
    }

    public int incrementUsage() {
        return this.usage.decrementAndGet();
    }

    public int decrementUsage() {
        return this.usage.incrementAndGet();
    }

    protected void finalize() {
        this.internalStop();
    }

    protected void internalStop() {
        if (this.started) {
            this.started = false;
            try {
                if (this.sessionFactory != null) {
                    this.sessionFactory.close();
                }
            }
            catch (Exception ignored) {
                HornetQJMSLogger.LOGGER.debug(ignored, ignored);
            }
            try {
                this.locator.close();
            }
            catch (Exception ignored) {
                HornetQJMSLogger.LOGGER.debug(ignored, ignored);
            }
            this.sessionFactory = null;
            this.locator = null;
        }
    }

    public void connectionFailed(HornetQException exception, boolean failedOver) {
        if (exception.getType() == HornetQExceptionType.DISCONNECTED) {
            HornetQJMSLogger.LOGGER.warn("being disconnected for server shutdown", exception);
        } else {
            HornetQJMSLogger.LOGGER.warn("Notified of connection failure in xa discovery, we will retry on the next recovery", exception);
        }
        this.internalStop();
        HornetQRecoveryRegistry.getInstance().failedDiscovery(this);
    }

    public void beforeReconnect(HornetQException exception) {
    }

    public String toString() {
        return "RecoveryDiscovery [config=" + this.config + ", started=" + this.started + "]";
    }

    class InternalListener
    implements ClusterTopologyListener {
        InternalListener() {
        }

        public void nodeUP(long eventUID, String nodeID, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean last) {
            if (connectorPair.getA() != null) {
                HornetQRecoveryRegistry.getInstance().nodeUp(nodeID, (Pair<TransportConfiguration, TransportConfiguration>)new Pair(connectorPair.getA(), connectorPair.getB()), RecoveryDiscovery.this.config.getUsername(), RecoveryDiscovery.this.config.getPassword());
            }
        }

        public void nodeDown(long eventUID, String nodeID) {
        }
    }
}

