/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.bridge.impl;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.jms.bridge.ConnectionFactoryFactory;
import org.hornetq.jms.bridge.DestinationFactory;
import org.hornetq.jms.bridge.JMSBridge;
import org.hornetq.jms.bridge.JMSBridgeControl;
import org.hornetq.jms.bridge.QualityOfServiceMode;
import org.hornetq.jms.bridge.impl.JMSBridgeControlImpl;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.HornetQSession;

public class JMSBridgeImpl
implements HornetQComponent,
JMSBridge {
    private static final Logger log = Logger.getLogger(JMSBridgeImpl.class);
    private static boolean trace = log.isTraceEnabled();
    private static final int TEN_YEARS = 315360000;
    private final Object lock = new Object();
    private String sourceUsername;
    private String sourcePassword;
    private String targetUsername;
    private String targetPassword;
    private TransactionManager tm;
    private String selector;
    private long failureRetryInterval;
    private int maxRetries;
    private QualityOfServiceMode qualityOfServiceMode;
    private int maxBatchSize;
    private long maxBatchTime;
    private String subName;
    private String clientID;
    private volatile boolean addMessageIDInHeader;
    private boolean started;
    private boolean stopping = false;
    private final LinkedList<Message> messages = new LinkedList();
    private ConnectionFactoryFactory sourceCff;
    private ConnectionFactoryFactory targetCff;
    private DestinationFactory sourceDestinationFactory;
    private DestinationFactory targetDestinationFactory;
    private Connection sourceConn;
    private Connection targetConn;
    private Destination sourceDestination;
    private Destination targetDestination;
    private Session sourceSession;
    private Session targetSession;
    private MessageConsumer sourceConsumer;
    private MessageProducer targetProducer;
    private BatchTimeChecker timeChecker;
    private ExecutorService executor = this.createExecutor();
    private long batchExpiryTime;
    private boolean paused;
    private Transaction tx;
    private boolean failed;
    private int forwardMode;
    private String transactionManagerLocatorClass = "org.hornetq.integration.jboss.tm.JBoss5TransactionManagerLocator";
    private String transactionManagerLocatorMethod = "getTm";
    private MBeanServer mbeanServer;
    private ObjectName objectName;
    private static final int FORWARD_MODE_XA = 0;
    private static final int FORWARD_MODE_LOCALTX = 1;
    private static final int FORWARD_MODE_NONTX = 2;

    public JMSBridgeImpl() {
    }

    public JMSBridgeImpl(ConnectionFactoryFactory sourceCff, ConnectionFactoryFactory targetCff, DestinationFactory sourceDestinationFactory, DestinationFactory targetDestinationFactory, String sourceUsername, String sourcePassword, String targetUsername, String targetPassword, String selector, long failureRetryInterval, int maxRetries, QualityOfServiceMode qosMode, int maxBatchSize, long maxBatchTime, String subName, String clientID, boolean addMessageIDInHeader) {
        this(sourceCff, targetCff, sourceDestinationFactory, targetDestinationFactory, sourceUsername, sourcePassword, targetUsername, targetPassword, selector, failureRetryInterval, maxRetries, qosMode, maxBatchSize, maxBatchTime, subName, clientID, addMessageIDInHeader, null, null);
    }

    public JMSBridgeImpl(ConnectionFactoryFactory sourceCff, ConnectionFactoryFactory targetCff, DestinationFactory sourceDestinationFactory, DestinationFactory targetDestinationFactory, String sourceUsername, String sourcePassword, String targetUsername, String targetPassword, String selector, long failureRetryInterval, int maxRetries, QualityOfServiceMode qosMode, int maxBatchSize, long maxBatchTime, String subName, String clientID, boolean addMessageIDInHeader, MBeanServer mbeanServer, String objectName) {
        this();
        this.sourceCff = sourceCff;
        this.targetCff = targetCff;
        this.sourceDestinationFactory = sourceDestinationFactory;
        this.targetDestinationFactory = targetDestinationFactory;
        this.sourceUsername = sourceUsername;
        this.sourcePassword = sourcePassword;
        this.targetUsername = targetUsername;
        this.targetPassword = targetPassword;
        this.selector = selector;
        this.failureRetryInterval = failureRetryInterval;
        this.maxRetries = maxRetries;
        this.qualityOfServiceMode = qosMode;
        this.maxBatchSize = maxBatchSize;
        this.maxBatchTime = maxBatchTime;
        this.subName = subName;
        this.clientID = clientID;
        this.addMessageIDInHeader = addMessageIDInHeader;
        this.checkParams();
        if (mbeanServer != null) {
            if (objectName != null) {
                this.mbeanServer = mbeanServer;
                try {
                    JMSBridgeControlImpl controlBean = new JMSBridgeControlImpl(this);
                    this.objectName = ObjectName.getInstance(objectName);
                    StandardMBean mbean = new StandardMBean(controlBean, JMSBridgeControl.class);
                    mbeanServer.registerMBean(mbean, this.objectName);
                    log.debug((Object)("Registered JMSBridge instance as: " + this.objectName.getCanonicalName()));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to register JMSBridge MBean", e);
                }
            } else {
                throw new IllegalArgumentException("objectName is required when specifying an MBeanServer");
            }
        }
        if (trace) {
            log.trace((Object)("Created " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws Exception {
        boolean ok;
        this.stopping = false;
        if (this.started) {
            log.warn((Object)"Attempt to start, but is already started");
            return;
        }
        if (trace) {
            log.trace((Object)("Starting " + this));
        }
        if (this.executor.isShutdown()) {
            this.executor = this.createExecutor();
        }
        this.checkParams();
        TransactionManager tm = this.getTm();
        Transaction toResume = null;
        try {
            toResume = tm.suspend();
            ok = this.setupJMSObjects();
        }
        finally {
            if (toResume != null) {
                tm.resume(toResume);
            }
        }
        if (ok) {
            this.sourceConn.start();
            this.started = true;
            if (this.maxBatchTime != -1L) {
                if (trace) {
                    log.trace((Object)"Starting time checker thread");
                }
                this.timeChecker = new BatchTimeChecker();
                this.executor.execute(this.timeChecker);
                this.batchExpiryTime = System.currentTimeMillis() + this.maxBatchTime;
                if (trace) {
                    log.trace((Object)"Started time checker thread");
                }
            }
            this.executor.execute(new SourceReceiver());
            if (trace) {
                log.trace((Object)("Started " + this));
            }
        } else {
            log.warn((Object)"Failed to start bridge");
            this.handleFailureOnStartup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws Exception {
        block18: {
            block17: {
                this.stopping = true;
                if (trace) {
                    log.trace((Object)("Stopping " + this));
                }
                Object object = this.lock;
                synchronized (object) {
                    this.started = false;
                    this.executor.shutdownNow();
                }
                boolean ok = this.executor.awaitTermination(60L, TimeUnit.SECONDS);
                if (!ok) {
                    throw new Exception("fail to stop JMS Bridge");
                }
                if (this.tx != null) {
                    block16: {
                        if (trace) {
                            log.trace((Object)"Rolling back remaining tx");
                        }
                        try {
                            this.tx.rollback();
                        }
                        catch (Exception ignore) {
                            if (!trace) break block16;
                            log.trace((Object)"Failed to rollback", (Throwable)ignore);
                        }
                    }
                    if (trace) {
                        log.trace((Object)"Rolled back remaining tx");
                    }
                }
                try {
                    this.sourceConn.close();
                }
                catch (Exception ignore) {
                    if (!trace) break block17;
                    log.trace((Object)"Failed to close source conn", (Throwable)ignore);
                }
            }
            if (this.targetConn != null) {
                try {
                    this.targetConn.close();
                }
                catch (Exception ignore) {
                    if (!trace) break block18;
                    log.trace((Object)"Failed to close target conn", (Throwable)ignore);
                }
            }
        }
        if (trace) {
            log.trace((Object)("Stopped " + this));
        }
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public void destroy() {
        if (this.mbeanServer != null && this.objectName != null) {
            try {
                this.mbeanServer.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to unregisted JMS Bridge " + this.objectName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pause() throws Exception {
        if (trace) {
            log.trace((Object)("Pausing " + this));
        }
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            this.sourceConn.stop();
        }
        if (trace) {
            log.trace((Object)("Paused " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void resume() throws Exception {
        if (trace) {
            log.trace((Object)("Resuming " + this));
        }
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.sourceConn.start();
        }
        if (trace) {
            log.trace((Object)("Resumed " + this));
        }
    }

    @Override
    public DestinationFactory getSourceDestinationFactory() {
        return this.sourceDestinationFactory;
    }

    @Override
    public void setSourceDestinationFactory(DestinationFactory dest) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull(dest, "TargetDestinationFactory");
        this.sourceDestinationFactory = dest;
    }

    @Override
    public DestinationFactory getTargetDestinationFactory() {
        return this.targetDestinationFactory;
    }

    @Override
    public void setTargetDestinationFactory(DestinationFactory dest) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull(dest, "TargetDestinationFactory");
        this.targetDestinationFactory = dest;
    }

    @Override
    public String getSourceUsername() {
        return this.sourceUsername;
    }

    @Override
    public synchronized void setSourceUsername(String name) {
        this.checkBridgeNotStarted();
        this.sourceUsername = name;
    }

    @Override
    public synchronized String getSourcePassword() {
        return this.sourcePassword;
    }

    @Override
    public synchronized void setSourcePassword(String pwd) {
        this.checkBridgeNotStarted();
        this.sourcePassword = pwd;
    }

    @Override
    public synchronized String getTargetUsername() {
        return this.targetUsername;
    }

    @Override
    public synchronized void setTargetUsername(String name) {
        this.checkBridgeNotStarted();
        this.targetUsername = name;
    }

    @Override
    public synchronized String getTargetPassword() {
        return this.targetPassword;
    }

    @Override
    public synchronized void setTargetPassword(String pwd) {
        this.checkBridgeNotStarted();
        this.targetPassword = pwd;
    }

    @Override
    public synchronized String getSelector() {
        return this.selector;
    }

    @Override
    public synchronized void setSelector(String selector) {
        this.checkBridgeNotStarted();
        this.selector = selector;
    }

    @Override
    public synchronized long getFailureRetryInterval() {
        return this.failureRetryInterval;
    }

    @Override
    public synchronized void setFailureRetryInterval(long interval) {
        this.checkBridgeNotStarted();
        if (interval < 1L) {
            throw new IllegalArgumentException("FailureRetryInterval must be >= 1");
        }
        this.failureRetryInterval = interval;
    }

    @Override
    public synchronized int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public synchronized void setMaxRetries(int retries) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkValidValue(retries, "MaxRetries");
        this.maxRetries = retries;
    }

    @Override
    public synchronized QualityOfServiceMode getQualityOfServiceMode() {
        return this.qualityOfServiceMode;
    }

    @Override
    public synchronized void setQualityOfServiceMode(QualityOfServiceMode mode) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull((Object)mode, "QualityOfServiceMode");
        this.qualityOfServiceMode = mode;
    }

    @Override
    public synchronized int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Override
    public synchronized void setMaxBatchSize(int size) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkMaxBatchSize(size);
        this.maxBatchSize = size;
    }

    @Override
    public synchronized long getMaxBatchTime() {
        return this.maxBatchTime;
    }

    @Override
    public synchronized void setMaxBatchTime(long time) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkValidValue(time, "MaxBatchTime");
        this.maxBatchTime = time;
    }

    @Override
    public synchronized String getSubscriptionName() {
        return this.subName;
    }

    @Override
    public synchronized void setSubscriptionName(String subname) {
        this.checkBridgeNotStarted();
        this.subName = subname;
    }

    @Override
    public synchronized String getClientID() {
        return this.clientID;
    }

    @Override
    public synchronized void setClientID(String clientID) {
        this.checkBridgeNotStarted();
        this.clientID = clientID;
    }

    @Override
    public String getTransactionManagerLocatorClass() {
        return this.transactionManagerLocatorClass;
    }

    @Override
    public void setTransactionManagerLocatorClass(String transactionManagerLocatorClass) {
        this.checkBridgeNotStarted();
        this.transactionManagerLocatorClass = transactionManagerLocatorClass;
    }

    @Override
    public String getTransactionManagerLocatorMethod() {
        return this.transactionManagerLocatorMethod;
    }

    @Override
    public void setTransactionManagerLocatorMethod(String transactionManagerLocatorMethod) {
        this.transactionManagerLocatorMethod = transactionManagerLocatorMethod;
    }

    @Override
    public boolean isAddMessageIDInHeader() {
        return this.addMessageIDInHeader;
    }

    @Override
    public void setAddMessageIDInHeader(boolean value) {
        this.addMessageIDInHeader = value;
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused;
    }

    @Override
    public synchronized boolean isFailed() {
        return this.failed;
    }

    @Override
    public synchronized void setSourceConnectionFactoryFactory(ConnectionFactoryFactory cff) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull(cff, "SourceConnectionFactoryFactory");
        this.sourceCff = cff;
    }

    @Override
    public synchronized void setTargetConnectionFactoryFactory(ConnectionFactoryFactory cff) {
        this.checkBridgeNotStarted();
        JMSBridgeImpl.checkNotNull(cff, "TargetConnectionFactoryFactory");
        this.targetCff = cff;
    }

    @Override
    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    private void checkParams() {
        JMSBridgeImpl.checkNotNull(this.sourceCff, "sourceCff");
        JMSBridgeImpl.checkNotNull(this.targetCff, "targetCff");
        JMSBridgeImpl.checkNotNull(this.sourceDestinationFactory, "sourceDestinationFactory");
        JMSBridgeImpl.checkNotNull(this.targetDestinationFactory, "targetDestinationFactory");
        JMSBridgeImpl.checkValidValue(this.failureRetryInterval, "failureRetryInterval");
        JMSBridgeImpl.checkValidValue(this.maxRetries, "maxRetries");
        if (this.failureRetryInterval == -1L && this.maxRetries > 0) {
            throw new IllegalArgumentException("If failureRetryInterval == -1 maxRetries must be set to -1");
        }
        JMSBridgeImpl.checkMaxBatchSize(this.maxBatchSize);
        JMSBridgeImpl.checkValidValue(this.maxBatchTime, "maxBatchTime");
        JMSBridgeImpl.checkNotNull((Object)this.qualityOfServiceMode, "qualityOfServiceMode");
    }

    private static void checkNotNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    private void checkBridgeNotStarted() {
        if (this.started) {
            throw new IllegalStateException("Cannot set bridge attributes while it is started");
        }
    }

    private static void checkValidValue(long value, String name) {
        if (value != -1L && value <= 0L) {
            throw new IllegalArgumentException(name + " must be > 0 or -1");
        }
    }

    private static void checkMaxBatchSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("maxBatchSize must be >= 1");
        }
    }

    private void enlistResources(Transaction tx) throws Exception {
        if (trace) {
            log.trace((Object)"Enlisting resources in tx");
        }
        XAResource resSource = ((XASession)this.sourceSession).getXAResource();
        tx.enlistResource(resSource);
        XAResource resDest = ((XASession)this.targetSession).getXAResource();
        tx.enlistResource(resDest);
        if (trace) {
            log.trace((Object)"Enlisted resources in tx");
        }
    }

    private void delistResources(Transaction tx) {
        block7: {
            block6: {
                if (trace) {
                    log.trace((Object)"Delisting resources from tx");
                }
                XAResource resSource = ((XASession)this.sourceSession).getXAResource();
                try {
                    tx.delistResource(resSource, 0x4000000);
                }
                catch (Exception e) {
                    if (!trace) break block6;
                    log.trace((Object)"Failed to delist source resource", (Throwable)e);
                }
            }
            XAResource resDest = ((XASession)this.targetSession).getXAResource();
            try {
                tx.delistResource(resDest, 0x4000000);
            }
            catch (Exception e) {
                if (!trace) break block7;
                log.trace((Object)"Failed to delist target resource", (Throwable)e);
            }
        }
        if (trace) {
            log.trace((Object)"Delisted resources from tx");
        }
    }

    private Transaction startTx() throws Exception {
        if (trace) {
            log.trace((Object)"Starting JTA transaction");
        }
        TransactionManager tm = this.getTm();
        tm.setTransactionTimeout(315360000);
        tm.begin();
        Transaction tx = tm.getTransaction();
        tm.suspend();
        if (trace) {
            log.trace((Object)"Started JTA transaction");
        }
        return tx;
    }

    private TransactionManager getTm() {
        if (this.tm == null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> aClass = loader.loadClass(this.transactionManagerLocatorClass);
                Object o = aClass.newInstance();
                Method m = aClass.getMethod(this.transactionManagerLocatorMethod, new Class[0]);
                this.tm = (TransactionManager)m.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create TransactionManager from " + this.transactionManagerLocatorClass + "." + this.transactionManagerLocatorMethod, e);
            }
            if (this.tm == null) {
                throw new IllegalStateException("Cannot locate a transaction manager");
            }
        }
        return this.tm;
    }

    private Connection createConnection(String username, String password, ConnectionFactoryFactory cff) throws Exception {
        Connection conn;
        ConnectionFactory cf = cff.createConnectionFactory();
        if (this.qualityOfServiceMode == QualityOfServiceMode.ONCE_AND_ONLY_ONCE && !(cf instanceof XAConnectionFactory)) {
            throw new IllegalArgumentException("Connection factory must be XAConnectionFactory");
        }
        if (username == null) {
            if (this.qualityOfServiceMode == QualityOfServiceMode.ONCE_AND_ONLY_ONCE) {
                if (trace) {
                    log.trace((Object)"Creating an XA connection");
                }
                conn = ((XAConnectionFactory)cf).createXAConnection();
            } else {
                if (trace) {
                    log.trace((Object)"Creating a non XA connection");
                }
                conn = cf.createConnection();
            }
        } else if (this.qualityOfServiceMode == QualityOfServiceMode.ONCE_AND_ONLY_ONCE) {
            if (trace) {
                log.trace((Object)"Creating an XA connection");
            }
            conn = ((XAConnectionFactory)cf).createXAConnection(username, password);
        } else {
            if (trace) {
                log.trace((Object)"Creating a non XA connection");
            }
            conn = cf.createConnection(username, password);
        }
        return conn;
    }

    private boolean setupJMSObjects() {
        try {
            Session sess;
            this.forwardMode = this.sourceCff == this.targetCff ? 1 : (this.qualityOfServiceMode == QualityOfServiceMode.ONCE_AND_ONLY_ONCE ? 0 : 2);
            this.sourceDestination = this.sourceDestinationFactory.createDestination();
            this.targetDestination = this.targetDestinationFactory.createDestination();
            this.sourceConn = this.createConnection(this.sourceUsername, this.sourcePassword, this.sourceCff);
            if (this.forwardMode != 1) {
                this.targetConn = this.createConnection(this.targetUsername, this.targetPassword, this.targetCff);
                this.targetConn.setExceptionListener((ExceptionListener)new BridgeExceptionListener());
            }
            if (this.clientID != null) {
                this.sourceConn.setClientID(this.clientID);
            }
            this.sourceConn.setExceptionListener((ExceptionListener)new BridgeExceptionListener());
            if (this.forwardMode == 1) {
                sess = this.sourceSession = this.sourceConn.createSession(true, 0);
            } else if (this.forwardMode == 0) {
                if (trace) {
                    log.trace((Object)"Creating XA source session");
                }
                this.sourceSession = ((XAConnection)this.sourceConn).createXASession();
                sess = ((XASession)this.sourceSession).getSession();
            } else {
                if (trace) {
                    log.trace((Object)"Creating non XA source session");
                }
                sess = this.sourceSession = this.sourceConn.createSession(false, 2);
            }
            if (this.forwardMode == 0 && this.sourceSession instanceof HornetQSession) {
                HornetQSession jsession = (HornetQSession)this.sourceSession;
                ClientSession clientSession = jsession.getCoreSession();
            }
            this.sourceConsumer = this.subName == null ? (this.selector == null ? sess.createConsumer(this.sourceDestination) : sess.createConsumer(this.sourceDestination, this.selector, false)) : (this.selector == null ? sess.createDurableSubscriber((Topic)this.sourceDestination, this.subName) : sess.createDurableSubscriber((Topic)this.sourceDestination, this.subName, this.selector, false));
            if (this.forwardMode != 1) {
                if (this.forwardMode == 0) {
                    if (trace) {
                        log.trace((Object)"Creating XA dest session");
                    }
                    this.targetSession = ((XAConnection)this.targetConn).createXASession();
                    sess = ((XASession)this.targetSession).getSession();
                } else {
                    if (trace) {
                        log.trace((Object)"Creating non XA dest session");
                    }
                    boolean transacted = this.maxBatchSize > 1;
                    sess = this.targetSession = this.targetConn.createSession(transacted, transacted ? 0 : 1);
                }
            }
            if (this.forwardMode == 0) {
                if (trace) {
                    log.trace((Object)"Starting JTA transaction");
                }
                this.tx = this.startTx();
                this.enlistResources(this.tx);
            }
            this.targetProducer = sess.createProducer(null);
            return true;
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Failed to connect bridge", (Throwable)e);
            }
            this.cleanup();
            return false;
        }
    }

    private void cleanup() {
        block16: {
            block15: {
                block14: {
                    block12: {
                        try {
                            this.sourceConn.stop();
                        }
                        catch (Throwable ignore) {
                            if (!trace) break block12;
                            log.trace((Object)"Failed to stop source connection", ignore);
                        }
                    }
                    if (this.tx != null) {
                        block13: {
                            try {
                                this.delistResources(this.tx);
                            }
                            catch (Throwable ignore) {
                                if (!trace) break block13;
                                log.trace((Object)"Failed to delist resources", ignore);
                            }
                        }
                        try {
                            this.tx.rollback();
                        }
                        catch (Throwable ignore) {
                            if (!trace) break block14;
                            log.trace((Object)"Failed to rollback", ignore);
                        }
                    }
                }
                try {
                    this.sourceConn.close();
                }
                catch (Throwable ignore) {
                    if (!trace) break block15;
                    log.trace((Object)"Failed to close source connection", ignore);
                }
            }
            try {
                if (this.targetConn != null) {
                    this.targetConn.close();
                }
            }
            catch (Throwable ignore) {
                if (!trace) break block16;
                log.trace((Object)"Failed to close target connection", ignore);
            }
        }
    }

    private void pause(long interval) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.failureRetryInterval) {
            try {
                Thread.sleep(this.failureRetryInterval);
            }
            catch (InterruptedException ex) {}
        }
    }

    private boolean setupJMSObjectsWithRetry() {
        if (trace) {
            log.trace((Object)"Setting up connections");
        }
        int count = 0;
        while (!this.stopping) {
            boolean ok = this.setupJMSObjects();
            if (ok) {
                return true;
            }
            if (this.maxRetries != -1 && ++count == this.maxRetries) break;
            log.info((Object)("Failed to set up JMS bridge connections. Most probably the source or target servers are unavailable. Will retry after a pause of " + this.failureRetryInterval + " ms"));
            this.pause(this.failureRetryInterval);
        }
        return false;
    }

    private void sendBatch() {
        if (trace) {
            log.trace((Object)("Sending batch of " + this.messages.size() + " messages"));
        }
        if (this.paused) {
            if (trace) {
                log.trace((Object)"Paused, so not sending now");
            }
            return;
        }
        if (this.forwardMode == 1) {
            this.sendBatchLocalTx();
        } else if (this.forwardMode == 0) {
            this.sendBatchXA();
        } else {
            this.sendBatchNonTransacted();
        }
    }

    private void sendBatchNonTransacted() {
        try {
            if (this.qualityOfServiceMode == QualityOfServiceMode.ONCE_AND_ONLY_ONCE) {
                if (trace) {
                    log.trace((Object)"Client acking source session");
                }
                this.messages.getLast().acknowledge();
                if (trace) {
                    log.trace((Object)"Client acked source session");
                }
            }
            this.sendMessages();
            if (this.maxBatchSize > 1) {
                if (trace) {
                    log.trace((Object)"Committing target session");
                }
                this.targetSession.commit();
                if (trace) {
                    log.trace((Object)"Committed source session");
                }
            }
            if (this.qualityOfServiceMode == QualityOfServiceMode.DUPLICATES_OK) {
                if (trace) {
                    log.trace((Object)"Client acking source session");
                }
                this.messages.getLast().acknowledge();
                if (trace) {
                    log.trace((Object)"Client acked source session");
                }
            }
            this.messages.clear();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to send + acknowledge batch, closing JMS objects", (Throwable)e);
            this.handleFailureOnSend();
        }
    }

    private void sendBatchXA() {
        try {
            this.sendMessages();
            this.delistResources(this.tx);
            if (trace) {
                log.trace((Object)"Committing JTA transaction");
            }
            this.tx.commit();
            if (trace) {
                log.trace((Object)"Committed JTA transaction");
            }
            this.tx = this.startTx();
            this.enlistResources(this.tx);
            this.messages.clear();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to send + acknowledge batch, closing JMS objects", (Throwable)e);
            this.handleFailureOnSend();
        }
    }

    private void sendBatchLocalTx() {
        try {
            this.sendMessages();
            if (trace) {
                log.trace((Object)"Committing source session");
            }
            this.sourceSession.commit();
            if (trace) {
                log.trace((Object)"Committed source session");
            }
            this.messages.clear();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to send + acknowledge batch, closing JMS objects", (Throwable)e);
            this.handleFailureOnSend();
        }
    }

    private void sendMessages() throws Exception {
        Iterator iter = this.messages.iterator();
        Message msg = null;
        while (iter.hasNext()) {
            long timeToLive;
            msg = (Message)iter.next();
            if (this.addMessageIDInHeader) {
                this.addMessageIDInHeader(msg);
            }
            if (trace) {
                log.trace((Object)("Sending message " + msg));
            }
            if ((timeToLive = msg.getJMSExpiration()) != 0L && (timeToLive -= System.currentTimeMillis()) <= 0L) {
                timeToLive = 1L;
            }
            this.targetProducer.send(this.targetDestination, msg, msg.getJMSDeliveryMode(), msg.getJMSPriority(), timeToLive);
            if (!trace) continue;
            log.trace((Object)("Sent message " + msg));
        }
    }

    private void handleFailureOnSend() {
        this.handleFailure(new FailureHandler());
    }

    private void handleFailureOnStartup() {
        this.handleFailure(new StartupFailureHandler());
    }

    private void handleFailure(Runnable failureHandler) {
        this.failed = true;
        this.executor.execute(failureHandler);
    }

    private void addMessageIDInHeader(Message msg) throws Exception {
        if (trace) {
            log.trace((Object)"Adding old message id in Message header");
        }
        JMSBridgeImpl.copyProperties(msg);
        String val = null;
        val = msg.getStringProperty("HQ_BRIDGE_MSG_ID_LIST");
        if (val == null) {
            val = msg.getJMSMessageID();
        } else {
            StringBuffer sb = new StringBuffer(val);
            sb.append(",").append(msg.getJMSMessageID());
            val = sb.toString();
        }
        msg.setStringProperty("HQ_BRIDGE_MSG_ID_LIST", val);
    }

    private static void copyProperties(Message msg) throws JMSException {
        Enumeration en = msg.getPropertyNames();
        HashMap<String, Object> oldProps = null;
        while (en.hasMoreElements()) {
            String propName = (String)en.nextElement();
            if (oldProps == null) {
                oldProps = new HashMap<String, Object>();
            }
            oldProps.put(propName, msg.getObjectProperty(propName));
        }
        msg.clearProperties();
        if (oldProps != null) {
            for (Map.Entry entry : oldProps.entrySet()) {
                String propName = (String)entry.getKey();
                Object val = entry.getValue();
                if (!(val instanceof byte[])) {
                    msg.setObjectProperty(propName, entry.getValue());
                    continue;
                }
                if (!(msg instanceof HornetQMessage)) continue;
                ((HornetQMessage)msg).getCoreMessage().putBytesProperty(propName, (byte[])val);
            }
        }
    }

    private ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(3);
    }

    private class BridgeExceptionListener
    implements ExceptionListener {
        private BridgeExceptionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(JMSException e) {
            log.warn((Object)"Detected failure on bridge connection");
            Object object = JMSBridgeImpl.this.lock;
            synchronized (object) {
                if (JMSBridgeImpl.this.failed) {
                    if (trace) {
                        log.trace((Object)"Failure recovery already in progress");
                    }
                } else {
                    JMSBridgeImpl.this.handleFailure(new FailureHandler());
                }
            }
        }
    }

    private class BatchTimeChecker
    implements Runnable {
        private BatchTimeChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (trace) {
                log.trace((Object)(this + " running"));
            }
            Object object = JMSBridgeImpl.this.lock;
            synchronized (object) {
                while (JMSBridgeImpl.this.started) {
                    long toWait = JMSBridgeImpl.this.batchExpiryTime - System.currentTimeMillis();
                    if (toWait <= 0L) {
                        if (trace) {
                            log.trace((Object)(this + " waited enough"));
                        }
                        Object object2 = JMSBridgeImpl.this.lock;
                        synchronized (object2) {
                            if (!JMSBridgeImpl.this.failed && !JMSBridgeImpl.this.messages.isEmpty()) {
                                if (trace) {
                                    log.trace((Object)(this + " got some messages so sending batch"));
                                }
                                JMSBridgeImpl.this.sendBatch();
                                if (trace) {
                                    log.trace((Object)(this + " sent batch"));
                                }
                            }
                        }
                        JMSBridgeImpl.this.batchExpiryTime = System.currentTimeMillis() + JMSBridgeImpl.this.maxBatchTime;
                        continue;
                    }
                    try {
                        if (trace) {
                            log.trace((Object)(this + " waiting for " + toWait));
                        }
                        JMSBridgeImpl.this.lock.wait(toWait);
                        if (!trace) continue;
                        log.trace((Object)(this + " woke up"));
                    }
                    catch (InterruptedException e) {
                        if (!trace) continue;
                        log.trace((Object)(this + " thread was interrupted"));
                    }
                }
                return;
            }
        }
    }

    private class StartupFailureHandler
    extends FailureHandler {
        private StartupFailureHandler() {
        }

        @Override
        protected void failed() {
            log.warn((Object)"Unable to set up connections, bridge will not be started");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void succeeded() {
            log.info((Object)"Succeeded in connecting to servers");
            Object object = JMSBridgeImpl.this.lock;
            synchronized (object) {
                JMSBridgeImpl.this.failed = false;
                JMSBridgeImpl.this.started = true;
                try {
                    JMSBridgeImpl.this.sourceConn.start();
                }
                catch (JMSException e) {
                    log.error((Object)"Failed to start source connection", (Throwable)e);
                }
            }
        }
    }

    private class FailureHandler
    implements Runnable {
        private FailureHandler() {
        }

        protected void startSourceConnection() {
            try {
                JMSBridgeImpl.this.sourceConn.start();
            }
            catch (JMSException e) {
                log.error((Object)"Failed to start source connection", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void succeeded() {
            log.info((Object)"Succeeded in reconnecting to servers");
            Object object = JMSBridgeImpl.this.lock;
            synchronized (object) {
                JMSBridgeImpl.this.failed = false;
                this.startSourceConnection();
            }
        }

        protected void failed() {
            log.warn((Object)"Unable to set up connections, bridge will be stopped");
            try {
                JMSBridgeImpl.this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            if (trace) {
                log.trace((Object)"Failure handler running");
            }
            JMSBridgeImpl.this.messages.clear();
            JMSBridgeImpl.this.cleanup();
            boolean ok = false;
            if (JMSBridgeImpl.this.maxRetries > 0 || JMSBridgeImpl.this.maxRetries == -1) {
                log.warn((Object)("Will retry after a pause of " + JMSBridgeImpl.this.failureRetryInterval + " ms"));
                JMSBridgeImpl.this.pause(JMSBridgeImpl.this.failureRetryInterval);
                ok = JMSBridgeImpl.this.setupJMSObjectsWithRetry();
            }
            if (!ok) {
                this.failed();
            } else {
                this.succeeded();
            }
        }
    }

    private final class SourceReceiver
    extends Thread {
        SourceReceiver() {
            super("jmsbridge-source-receiver-thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (JMSBridgeImpl.this.started) {
                Object object = JMSBridgeImpl.this.lock;
                synchronized (object) {
                    Message msg;
                    block18: {
                        if (JMSBridgeImpl.this.paused || JMSBridgeImpl.this.failed) {
                            block17: {
                                try {
                                    JMSBridgeImpl.this.lock.wait(500L);
                                }
                                catch (InterruptedException e) {
                                    if (!trace) break block17;
                                    log.trace((Object)(this + " thread was interrupted"));
                                }
                            }
                            continue;
                        }
                        msg = null;
                        try {
                            msg = JMSBridgeImpl.this.sourceConsumer.receive(1000L);
                        }
                        catch (JMSException jmse) {
                            if (!trace) break block18;
                            log.trace((Object)(this + " exception while receiving a message"), (Throwable)jmse);
                        }
                    }
                    if (msg == null) {
                        block19: {
                            try {
                                JMSBridgeImpl.this.lock.wait(500L);
                            }
                            catch (InterruptedException e) {
                                if (!trace) break block19;
                                log.trace((Object)(this + " thread was interrupted"));
                            }
                        }
                        continue;
                    }
                    if (trace) {
                        log.trace((Object)(this + " received message " + msg));
                    }
                    JMSBridgeImpl.this.messages.add(msg);
                    JMSBridgeImpl.this.batchExpiryTime = System.currentTimeMillis() + JMSBridgeImpl.this.maxBatchTime;
                    if (trace) {
                        log.trace((Object)(this + " rescheduled batchExpiryTime to " + JMSBridgeImpl.this.batchExpiryTime));
                    }
                    if (JMSBridgeImpl.this.maxBatchSize != -1 && JMSBridgeImpl.this.messages.size() >= JMSBridgeImpl.this.maxBatchSize) {
                        if (trace) {
                            log.trace((Object)(this + " maxBatchSize has been reached so sending batch"));
                        }
                        JMSBridgeImpl.this.sendBatch();
                        if (trace) {
                            log.trace((Object)(this + " sent batch"));
                        }
                    }
                }
            }
        }
    }
}

