/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.hornetq.core.logging.Logger;
import org.hornetq.ra.HornetQRAConnectionManager;
import org.hornetq.ra.HornetQRAConnectionRequestInfo;
import org.hornetq.ra.HornetQRAManagedConnectionFactory;
import org.hornetq.ra.HornetQRASession;
import org.hornetq.ra.HornetQRASessionFactory;
import org.hornetq.ra.HornetQResourceAdapter;

public class HornetQRASessionFactoryImpl
implements HornetQRASessionFactory,
Referenceable {
    private static final Logger log = Logger.getLogger(HornetQRASessionFactoryImpl.class);
    private static boolean trace = log.isTraceEnabled();
    private boolean closed = false;
    private Reference reference;
    private String userName;
    private String password;
    private String clientID;
    private final int type;
    private boolean started = false;
    private final HornetQRAManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private final Set sessions = new HashSet();
    private final Set tempQueues = new HashSet();
    private final Set tempTopics = new HashSet();

    public HornetQRASessionFactoryImpl(HornetQRAManagedConnectionFactory mcf, ConnectionManager cm, int type) {
        this.mcf = mcf;
        this.cm = cm == null ? new HornetQRAConnectionManager() : cm;
        this.type = type;
        if (trace) {
            log.trace((Object)("constructor(" + mcf + ", " + cm + ", " + type));
        }
    }

    public void setReference(Reference reference) {
        if (trace) {
            log.trace((Object)("setReference(" + reference + ")"));
        }
        this.reference = reference;
    }

    public Reference getReference() {
        if (trace) {
            log.trace((Object)"getReference()");
        }
        return this.reference;
    }

    public void setUserName(String name) {
        if (trace) {
            log.trace((Object)("setUserName(" + name + ")"));
        }
        this.userName = name;
    }

    public void setPassword(String password) {
        if (trace) {
            log.trace((Object)"setPassword(****)");
        }
        this.password = password;
    }

    public String getClientID() throws JMSException {
        if (trace) {
            log.trace((Object)"getClientID()");
        }
        this.checkClosed();
        if (this.clientID == null) {
            return ((HornetQResourceAdapter)this.mcf.getResourceAdapter()).getProperties().getClientID();
        }
        return this.clientID;
    }

    public void setClientID(String cID) throws JMSException {
        if (trace) {
            log.trace((Object)("setClientID(" + cID + ")"));
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (trace) {
            log.trace((Object)("createQueueSession(" + transacted + ", " + acknowledgeMode + ")"));
        }
        this.checkClosed();
        if (this.type == 2 || this.type == 5) {
            throw new IllegalStateException("Can not get a queue session from a topic connection");
        }
        return this.allocateConnection(transacted, acknowledgeMode, this.type);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        if (trace) {
            log.trace((Object)"createXAQueueSession()");
        }
        this.checkClosed();
        if (this.type == 0 || this.type == 2 || this.type == 5) {
            throw new IllegalStateException("Can not get a topic session from a queue connection");
        }
        return this.allocateConnection(this.type);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (trace) {
            log.trace((Object)("createConnectionConsumer(" + queue + ", " + messageSelector + ", " + sessionPool + ", " + maxMessages + ")"));
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (trace) {
            log.trace((Object)("createTopicSession(" + transacted + ", " + acknowledgeMode + ")"));
        }
        this.checkClosed();
        if (this.type == 1 || this.type == 4) {
            throw new IllegalStateException("Can not get a topic session from a queue connection");
        }
        return this.allocateConnection(transacted, acknowledgeMode, this.type);
    }

    public XATopicSession createXATopicSession() throws JMSException {
        if (trace) {
            log.trace((Object)"createXATopicSession()");
        }
        this.checkClosed();
        if (this.type == 0 || this.type == 1 || this.type == 4) {
            throw new IllegalStateException("Can not get a topic session from a queue connection");
        }
        return this.allocateConnection(this.type);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (trace) {
            log.trace((Object)("createConnectionConsumer(" + topic + ", " + messageSelector + ", " + sessionPool + ", " + maxMessages + ")"));
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (trace) {
            log.trace((Object)("createConnectionConsumer(" + topic + ", " + subscriptionName + ", " + messageSelector + ", " + sessionPool + ", " + maxMessages + ")"));
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, ServerSessionPool pool, int maxMessages) throws JMSException {
        if (trace) {
            log.trace((Object)("createConnectionConsumer(" + destination + ", " + pool + ", " + maxMessages + ")"));
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String name, ServerSessionPool pool, int maxMessages) throws JMSException {
        if (trace) {
            log.trace((Object)("createConnectionConsumer(" + destination + ", " + name + ", " + pool + ", " + maxMessages + ")"));
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (trace) {
            log.trace((Object)("createSession(" + transacted + ", " + acknowledgeMode + ")"));
        }
        this.checkClosed();
        return this.allocateConnection(transacted, acknowledgeMode, this.type);
    }

    public XASession createXASession() throws JMSException {
        if (trace) {
            log.trace((Object)"createXASession()");
        }
        this.checkClosed();
        return this.allocateConnection(this.type);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (trace) {
            log.trace((Object)"getMetaData()");
        }
        this.checkClosed();
        return this.mcf.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (trace) {
            log.trace((Object)"getExceptionListener()");
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (trace) {
            log.trace((Object)("setExceptionListener(" + listener + ")"));
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.checkClosed();
        if (trace) {
            log.trace((Object)("start() " + this));
        }
        Set set = this.sessions;
        synchronized (set) {
            if (this.started) {
                return;
            }
            this.started = true;
            for (HornetQRASession session : this.sessions) {
                session.start();
            }
        }
    }

    public void stop() throws JMSException {
        if (trace) {
            log.trace((Object)("stop() " + this));
        }
        throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        TemporaryQueue temp;
        Iterator i;
        if (trace) {
            log.trace((Object)("close() " + this));
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        Set set = this.sessions;
        synchronized (set) {
            i = this.sessions.iterator();
            while (i.hasNext()) {
                HornetQRASession session = (HornetQRASession)i.next();
                try {
                    session.closeSession();
                }
                catch (Throwable t) {
                    log.trace((Object)"Error closing session", t);
                }
                i.remove();
            }
        }
        set = this.tempQueues;
        synchronized (set) {
            i = this.tempQueues.iterator();
            while (i.hasNext()) {
                temp = (TemporaryQueue)i.next();
                try {
                    if (trace) {
                        log.trace((Object)("Closing temporary queue " + temp + " for " + this));
                    }
                    temp.delete();
                }
                catch (Throwable t) {
                    log.trace((Object)"Error deleting temporary queue", t);
                }
                i.remove();
            }
        }
        set = this.tempTopics;
        synchronized (set) {
            i = this.tempTopics.iterator();
            while (i.hasNext()) {
                temp = (TemporaryTopic)i.next();
                try {
                    if (trace) {
                        log.trace((Object)("Closing temporary topic " + temp + " for " + this));
                    }
                    temp.delete();
                }
                catch (Throwable t) {
                    log.trace((Object)"Error deleting temporary queue", t);
                }
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(HornetQRASession session) throws JMSException {
        if (trace) {
            log.trace((Object)("closeSession(" + session + ")"));
        }
        Set set = this.sessions;
        synchronized (set) {
            this.sessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTemporaryQueue(TemporaryQueue temp) {
        if (trace) {
            log.trace((Object)("addTemporaryQueue(" + temp + ")"));
        }
        Set set = this.tempQueues;
        synchronized (set) {
            this.tempQueues.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTemporaryTopic(TemporaryTopic temp) {
        if (trace) {
            log.trace((Object)("addTemporaryTopic(" + temp + ")"));
        }
        Set set = this.tempTopics;
        synchronized (set) {
            this.tempTopics.add(temp);
        }
    }

    protected HornetQRASession allocateConnection(int sessionType) throws JMSException {
        if (trace) {
            log.trace((Object)("allocateConnection(" + sessionType + ")"));
        }
        try {
            Set set = this.sessions;
            synchronized (set) {
                if (!this.sessions.isEmpty()) {
                    throw new IllegalStateException("Only allowed one session per connection. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
                }
                HornetQRAConnectionRequestInfo info = new HornetQRAConnectionRequestInfo(sessionType);
                info.setUserName(this.userName);
                info.setPassword(this.password);
                info.setClientID(this.clientID);
                info.setDefaults(((HornetQResourceAdapter)this.mcf.getResourceAdapter()).getProperties());
                if (trace) {
                    log.trace((Object)("Allocating session for " + this + " with request info=" + info));
                }
                HornetQRASession session = (HornetQRASession)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)info);
                try {
                    if (trace) {
                        log.trace((Object)("Allocated  " + this + " session=" + session));
                    }
                    session.setHornetQSessionFactory(this);
                    if (this.started) {
                        session.start();
                    }
                    this.sessions.add(session);
                    return session;
                }
                catch (Throwable t) {
                    try {
                        session.close();
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new RuntimeException("Unexpected error: ", t);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not create session", (Throwable)e);
            JMSException je = new JMSException("Could not create a session: " + e.getMessage());
            je.setLinkedException(e);
            throw je;
        }
    }

    protected HornetQRASession allocateConnection(boolean transacted, int acknowledgeMode, int sessionType) throws JMSException {
        if (trace) {
            log.trace((Object)("allocateConnection(" + transacted + ", " + acknowledgeMode + ", " + sessionType + ")"));
        }
        try {
            Set set = this.sessions;
            synchronized (set) {
                if (!this.sessions.isEmpty()) {
                    throw new IllegalStateException("Only allowed one session per connection. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
                }
                if (transacted) {
                    acknowledgeMode = 0;
                }
                HornetQRAConnectionRequestInfo info = new HornetQRAConnectionRequestInfo(transacted, acknowledgeMode, sessionType);
                info.setUserName(this.userName);
                info.setPassword(this.password);
                info.setClientID(this.clientID);
                if (trace) {
                    log.trace((Object)("Allocating session for " + this + " with request info=" + info));
                }
                HornetQRASession session = (HornetQRASession)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)info);
                try {
                    if (trace) {
                        log.trace((Object)("Allocated  " + this + " session=" + session));
                    }
                    session.setHornetQSessionFactory(this);
                    if (this.started) {
                        session.start();
                    }
                    this.sessions.add(session);
                    return session;
                }
                catch (Throwable t) {
                    try {
                        session.close();
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new RuntimeException("Unexpected error: ", t);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not create session", (Throwable)e);
            JMSException je = new JMSException("Could not create a session: " + e.getMessage());
            je.setLinkedException(e);
            throw je;
        }
    }

    protected void checkClosed() throws IllegalStateException {
        if (trace) {
            log.trace((Object)("checkClosed()" + this));
        }
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
    }
}

