/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import org.hornetq.core.logging.Logger;
import org.hornetq.ra.HornetQRAManagedConnection;

public class HornetQRALocalTransaction
implements LocalTransaction {
    private static final Logger log = Logger.getLogger(HornetQRALocalTransaction.class);
    private static boolean trace = log.isTraceEnabled();
    private final HornetQRAManagedConnection mc;

    public HornetQRALocalTransaction(HornetQRAManagedConnection mc) {
        if (trace) {
            log.trace((Object)("constructor(" + mc + ")"));
        }
        this.mc = mc;
    }

    public void begin() throws ResourceException {
        if (trace) {
            log.trace((Object)"begin()");
        }
        this.mc.setInManagedTx(true);
    }

    public void commit() throws ResourceException {
        if (trace) {
            log.trace((Object)"commit()");
        }
        this.mc.lock();
        try {
            if (this.mc.getSession().getTransacted()) {
                this.mc.getSession().commit();
            }
        }
        catch (JMSException e) {
            throw new ResourceException("Could not commit LocalTransaction", (Throwable)e);
        }
        finally {
            this.mc.setInManagedTx(false);
            this.mc.unlock();
        }
    }

    public void rollback() throws ResourceException {
        if (trace) {
            log.trace((Object)"rollback()");
        }
        this.mc.lock();
        try {
            if (this.mc.getSession().getTransacted()) {
                this.mc.getSession().rollback();
            }
        }
        catch (JMSException ex) {
            throw new ResourceException("Could not rollback LocalTransaction", (Throwable)ex);
        }
        finally {
            this.mc.setInManagedTx(false);
            this.mc.unlock();
        }
    }
}

