#!/bin/bash

SOAK_CONF=soak-conf
mkdir $SOAK_CONF

dest=$SOAK_CONF/destinations-hornetq-jms.xml

echo '<configuration xmlns="urn:hornetq"' > $dest
echo '      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"' >> $dest
echo '      xsi:schemaLocation="urn:hornetq /schema/hornetq-jms.xsd">' >> $dest

for (( I=0; I<50; I=I+1 )); do
	props=$SOAK_CONF/soak${I}.properties
	echo 'duration-in-minutes=300' > $props
	echo 'num-warmup-messages=100' >> $props
	echo 'message-size=1024' >> $props
	echo 'durable=true' >> $props
	echo 'transacted=false' >> $props
	echo 'batch-size=1000' >> $props
	echo 'drain-queue=false' >> $props
	echo 'destination-lookup=queue/soakQueue'${I} >> $props
	echo 'connection-factory-lookup=/ConnectionFactory' >> $props
	echo 'throttle-rate=-1' >> $props
	echo 'dups-ok-acknowledge=false' >> $props
	echo 'disable-message-id=true' >> $props
	echo 'disable-message-timestamp=true' >> $props

	echo '<queue name="soakQueue'${I}'"><entry name="/queue/soakQueue'${I}'"/><durable>true</durable></queue>' >> $dest
done

echo '</configuration>' >> $dest
