/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.service;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.integration.jboss.security.JBossASSecurityManager;
import org.hornetq.service.HornetQFileConfigurationServiceMBean;
import org.hornetq.service.HornetQStarterServiceMBean;
import org.hornetq.service.JBossASSecurityManagerServiceMBean;
import org.hornetq.spi.core.security.HornetQSecurityManager;

public class HornetQStarterService
implements HornetQStarterServiceMBean,
MBeanRegistration {
    JBossASSecurityManagerServiceMBean securityManagerService;
    HornetQFileConfigurationServiceMBean configurationService;
    private MBeanServer mBeanServer;
    private HornetQServer server;
    private boolean start = true;

    @Override
    public void create() throws Exception {
        JBossASSecurityManager hornetQSecurityManager = null;
        if (this.securityManagerService != null) {
            hornetQSecurityManager = this.securityManagerService.getJBossASSecurityManager();
        }
        Object config = this.configurationService != null ? this.configurationService.getConfiguration() : new ConfigurationImpl();
        this.server = new HornetQServerImpl(config, this.mBeanServer, (HornetQSecurityManager)hornetQSecurityManager);
    }

    @Override
    public void start() throws Exception {
        if (this.start) {
            this.server.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.start) {
            this.server.stop();
        }
    }

    @Override
    public HornetQServer getServer() {
        return this.server;
    }

    @Override
    public void setStart(boolean start) {
        this.start = start;
    }

    @Override
    public void setSecurityManagerService(JBossASSecurityManagerServiceMBean securityManagerService) {
        this.securityManagerService = securityManagerService;
    }

    @Override
    public void setConfigurationService(HornetQFileConfigurationServiceMBean configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mBeanServer = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.server = null;
        this.mBeanServer = null;
    }
}

