/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp.v11;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.core.protocol.stomp.FrameEventListener;
import org.hornetq.core.protocol.stomp.HornetQStompException;
import org.hornetq.core.protocol.stomp.HornetQStompProtocolMessageBundle;
import org.hornetq.core.protocol.stomp.SimpleBytes;
import org.hornetq.core.protocol.stomp.Stomp;
import org.hornetq.core.protocol.stomp.StompConnection;
import org.hornetq.core.protocol.stomp.StompDecoder;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.protocol.stomp.VersionedStompFrameHandler;
import org.hornetq.core.protocol.stomp.v11.StompFrameV11;
import org.hornetq.core.server.HornetQServerLogger;

public class StompFrameHandlerV11
extends VersionedStompFrameHandler
implements FrameEventListener {
    protected static final char ESC_CHAR = '\\';
    private HeartBeater heartBeater;

    public StompFrameHandlerV11(StompConnection connection) {
        super(connection);
        connection.addStompEventListener(this);
        this.decoder = new StompDecoderV11();
        this.decoder.init();
    }

    @Override
    public StompFrame onConnect(StompFrame frame) {
        StompFrame response = null;
        Map<String, String> headers = frame.getHeadersMap();
        String login = headers.get("login");
        String passcode = headers.get("passcode");
        String clientID = headers.get("client-id");
        String requestID = headers.get("request-id");
        try {
            if (this.connection.validateUser(login, passcode)) {
                String heartBeat;
                this.connection.setClientID(clientID);
                this.connection.setValid(true);
                response = this.createStompFrame("CONNECTED");
                response.addHeader("version", this.connection.getVersion());
                response.addHeader("session", this.connection.getID().toString());
                response.addHeader("server", this.connection.getHornetQServerName());
                if (requestID != null) {
                    response.addHeader("response-id", requestID);
                }
                if ((heartBeat = headers.get(Stomp.Headers.Connect.HEART_BEAT)) != null) {
                    this.handleHeartBeat(heartBeat);
                    if (this.heartBeater == null) {
                        response.addHeader("heart-beat", "0,0");
                    } else {
                        response.addHeader("heart-beat", this.heartBeater.getServerHeartBeatValue());
                    }
                }
            } else {
                response = new StompFrame("ERROR", true);
                response.addHeader("message", "Failed to connect");
                response.setBody("The login account is not valid.");
            }
        }
        catch (HornetQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    private void handleHeartBeat(String heartBeatHeader) throws HornetQStompException {
        String[] params = heartBeatHeader.split(",");
        if (params.length != 2) {
            throw new HornetQStompException("Incorrect heartbeat header " + heartBeatHeader);
        }
        long minPingInterval = Long.valueOf(params[0]);
        long minAcceptInterval = Long.valueOf(params[1]);
        if (minPingInterval != 0L || minAcceptInterval != 0L) {
            this.heartBeater = new HeartBeater(minPingInterval, minAcceptInterval);
        }
    }

    @Override
    public StompFrame onDisconnect(StompFrame frame) {
        if (this.heartBeater != null) {
            this.heartBeater.shutdown();
            try {
                this.heartBeater.join();
            }
            catch (InterruptedException e) {
                HornetQServerLogger.LOGGER.errorOnStompHeartBeat(e);
            }
        }
        return null;
    }

    @Override
    public StompFrame onUnsubscribe(StompFrame request) {
        StompFrame response = null;
        String id = request.getHeader("id");
        String durableSubscriberName = request.getHeader("durable-subscriber-name");
        String subscriptionID = null;
        if (id == null) {
            response = HornetQStompProtocolMessageBundle.BUNDLE.needSubscriptionID().getFrame();
            return response;
        }
        subscriptionID = id;
        try {
            this.connection.unsubscribe(subscriptionID, durableSubscriberName);
        }
        catch (HornetQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    @Override
    public StompFrame onAck(StompFrame request) {
        StompFrame response = null;
        String messageID = request.getHeader("message-id");
        String txID = request.getHeader("transaction");
        String subscriptionID = request.getHeader("subscription");
        if (txID != null) {
            HornetQServerLogger.LOGGER.stompTXAckNorSupported();
        }
        if (subscriptionID == null) {
            response = HornetQStompProtocolMessageBundle.BUNDLE.needSubscriptionID().getFrame();
            return response;
        }
        try {
            this.connection.acknowledge(messageID, subscriptionID);
        }
        catch (HornetQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    @Override
    public StompFrame onStomp(StompFrame request) {
        if (!this.connection.isValid()) {
            return this.onConnect(request);
        }
        return null;
    }

    @Override
    public StompFrame onNack(StompFrame request) {
        return this.onAck(request);
    }

    @Override
    public void replySent(StompFrame reply) {
        if (reply.getCommand().equals("CONNECTED")) {
            this.startHeartBeat();
        }
        if (reply.needsDisconnect()) {
            this.connection.disconnect(false);
        } else if (this.heartBeater != null) {
            this.heartBeater.pinged();
        }
    }

    private void startHeartBeat() {
        if (this.heartBeater != null) {
            this.heartBeater.start();
        }
    }

    public StompFrame createPingFrame() {
        StompFrame frame = new StompFrame("STOMP");
        frame.setPing(true);
        return frame;
    }

    @Override
    public void requestAccepted(StompFrame request) {
        if (this.heartBeater != null) {
            this.heartBeater.pingAccepted();
        }
    }

    @Override
    public StompFrame createStompFrame(String command) {
        return new StompFrameV11(command);
    }

    @Override
    public void initDecoder(VersionedStompFrameHandler existingHandler) {
        this.decoder.init(existingHandler.getDecoder());
    }

    protected class StompDecoderV11
    extends StompDecoder {
        protected boolean isEscaping = false;
        protected SimpleBytes holder = new SimpleBytes(1024);

        protected StompDecoderV11() {
        }

        @Override
        public void init(StompDecoder decoder) {
            this.data = decoder.data;
            this.workingBuffer = decoder.workingBuffer;
            this.pos = decoder.pos;
            this.command = decoder.command;
        }

        @Override
        public void init() {
            super.init();
            this.isEscaping = false;
            this.holder.reset();
        }

        @Override
        protected boolean parseCommand() throws HornetQStompException {
            boolean nextChar;
            int offset;
            block39: {
                offset = 0;
                nextChar = false;
                do {
                    if (this.workingBuffer[offset] == 10) {
                        if (StompFrameHandlerV11.this.heartBeater != null) {
                            StompFrameHandlerV11.this.heartBeater.pingAccepted();
                        }
                        nextChar = false;
                        continue;
                    }
                    if (this.workingBuffer[offset] != 13) break block39;
                    if (nextChar) {
                        throw HornetQStompProtocolMessageBundle.BUNDLE.invalidTwoCRs();
                    }
                    nextChar = true;
                } while (++offset != this.data);
                return false;
            }
            if (nextChar) {
                throw HornetQStompProtocolMessageBundle.BUNDLE.badCRs();
            }
            if (offset > 0) {
                System.arraycopy(this.workingBuffer, offset, this.workingBuffer, 0, this.data - offset);
                this.data -= offset;
                offset = 0;
            }
            if (this.data < 4) {
                return false;
            }
            byte b = this.workingBuffer[offset];
            switch (b) {
                case 65: {
                    if (this.workingBuffer[offset + 1] == 66) {
                        if (!this.tryIncrement(offset + COMMAND_ABORT_LENGTH + this.eolLen)) {
                            return false;
                        }
                        this.command = "ABORT";
                        break;
                    }
                    if (!this.tryIncrement(offset + COMMAND_ACK_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "ACK";
                    break;
                }
                case 66: {
                    if (!this.tryIncrement(offset + COMMAND_BEGIN_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "BEGIN";
                    break;
                }
                case 67: {
                    if (this.workingBuffer[offset + 2] == 77) {
                        if (!this.tryIncrement(offset + COMMAND_COMMIT_LENGTH + this.eolLen)) {
                            return false;
                        }
                        this.command = "COMMIT";
                        break;
                    }
                    if (this.workingBuffer[offset + 7] == 69) {
                        if (!this.tryIncrement(offset + COMMAND_CONNECTED_LENGTH + this.eolLen)) {
                            return false;
                        }
                        this.command = "CONNECTED";
                        break;
                    }
                    if (!this.tryIncrement(offset + COMMAND_CONNECT_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "CONNECT";
                    break;
                }
                case 68: {
                    if (!this.tryIncrement(offset + COMMAND_DISCONNECT_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "DISCONNECT";
                    break;
                }
                case 82: {
                    if (!this.tryIncrement(offset + COMMAND_RECEIPT_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "RECEIPT";
                    break;
                }
                case 69: {
                    if (!this.tryIncrement(offset + COMMAND_ERROR_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "ERROR";
                    break;
                }
                case 77: {
                    if (!this.tryIncrement(offset + COMMAND_MESSAGE_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "MESSAGE";
                    break;
                }
                case 83: {
                    if (this.workingBuffer[offset + 1] == 69) {
                        if (!this.tryIncrement(offset + COMMAND_SEND_LENGTH + this.eolLen)) {
                            return false;
                        }
                        this.command = "SEND";
                        break;
                    }
                    if (this.workingBuffer[offset + 1] == 85) {
                        if (!this.tryIncrement(offset + COMMAND_SUBSCRIBE_LENGTH + this.eolLen)) {
                            return false;
                        }
                        this.command = "SUBSCRIBE";
                        break;
                    }
                    if (!this.tryIncrement(offset + StompDecoder.COMMAND_STOMP_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "STOMP";
                    break;
                }
                case 85: {
                    if (!this.tryIncrement(offset + COMMAND_UNSUBSCRIBE_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "UNSUBSCRIBE";
                    break;
                }
                case 78: {
                    if (!this.tryIncrement(offset + COMMAND_NACK_LENGTH + this.eolLen)) {
                        return false;
                    }
                    this.command = "NACK";
                    break;
                }
                default: {
                    this.throwInvalid();
                }
            }
            this.checkEol();
            return true;
        }

        protected void checkEol() throws HornetQStompException {
            if (this.workingBuffer[this.pos - 1] != 10) {
                this.throwInvalid();
            }
        }

        @Override
        protected boolean parseHeaders() throws HornetQStompException {
            block15: {
                do {
                    byte b = this.workingBuffer[this.pos++];
                    switch (b) {
                        case 92: {
                            if (this.isEscaping) {
                                this.holder.append(b);
                                this.isEscaping = false;
                                break;
                            }
                            this.isEscaping = true;
                            break;
                        }
                        case 58: {
                            if (this.inHeaderName) {
                                this.headerName = this.holder.getString();
                                this.holder.reset();
                                this.inHeaderName = false;
                                this.headerValueWhitespace = true;
                            }
                            this.whiteSpaceOnly = false;
                            break;
                        }
                        case 110: {
                            if (this.isEscaping) {
                                this.holder.append((byte)10);
                                this.isEscaping = false;
                                break;
                            }
                            this.holder.append(b);
                            break;
                        }
                        case 99: {
                            if (this.isEscaping) {
                                this.holder.append((byte)58);
                                this.isEscaping = false;
                                break;
                            }
                            this.holder.append(b);
                            break;
                        }
                        case 10: {
                            if (this.whiteSpaceOnly) {
                                this.readingHeaders = false;
                                break block15;
                            }
                            String headerValue = this.holder.getString();
                            this.holder.reset();
                            this.headers.put(this.headerName, headerValue);
                            if (this.headerName.equals("content-length")) {
                                this.contentLength = Integer.parseInt(headerValue);
                            }
                            if (this.headerName.equals("content-type")) {
                                this.contentType = headerValue;
                            }
                            this.whiteSpaceOnly = true;
                            this.inHeaderName = true;
                            this.headerValueWhitespace = false;
                            break;
                        }
                        default: {
                            this.whiteSpaceOnly = false;
                            this.headerValueWhitespace = false;
                            this.holder.append(b);
                        }
                    }
                } while (this.pos != this.data);
                return false;
            }
            return true;
        }

        @Override
        protected StompFrame parseBody() throws HornetQStompException {
            byte[] content;
            block9: {
                block8: {
                    content = null;
                    if (this.contentLength == -1) break block8;
                    if (this.pos + this.contentLength + 1 > this.data) break block9;
                    content = new byte[this.contentLength];
                    System.arraycopy(this.workingBuffer, this.pos, content, 0, this.contentLength);
                    this.pos += this.contentLength;
                    if (this.bodyStart == -1) {
                        this.bodyStart = this.pos;
                    }
                    while (this.pos < this.data && this.workingBuffer[this.pos++] != 0) {
                    }
                    break block9;
                }
                if (this.bodyStart == -1) {
                    this.bodyStart = this.pos;
                }
                while (this.pos < this.data) {
                    if (this.workingBuffer[this.pos++] != 0) continue;
                    content = new byte[this.pos - this.bodyStart - 1];
                    System.arraycopy(this.workingBuffer, this.bodyStart, content, 0, content.length);
                    break;
                }
            }
            if (content != null) {
                if (this.data > this.pos) {
                    if (this.workingBuffer[this.pos] == 10) {
                        ++this.pos;
                    }
                    if (this.data > this.pos) {
                        System.arraycopy(this.workingBuffer, this.pos, this.workingBuffer, 0, this.data - this.pos);
                    }
                }
                this.data -= this.pos;
                StompFrameV11 ret = new StompFrameV11(this.command, this.headers, content);
                this.init();
                return ret;
            }
            return null;
        }
    }

    private class HeartBeater
    extends Thread {
        private static final int MIN_SERVER_PING = 500;
        private static final int MIN_CLIENT_PING = 500;
        long serverPing = 0L;
        long serverAcceptPing = 0L;
        volatile boolean shutdown = false;
        AtomicLong lastPingTime = new AtomicLong(0L);
        AtomicLong lastAccepted = new AtomicLong(0L);
        StompFrame pingFrame;

        public HeartBeater(long clientPing, long clientAcceptPing) {
            if (clientPing != 0L) {
                long l = this.serverAcceptPing = clientPing > 500L ? clientPing : 500L;
            }
            if (clientAcceptPing != 0L) {
                this.serverPing = clientAcceptPing > 500L ? clientAcceptPing : 500L;
            }
        }

        public synchronized void shutdown() {
            this.shutdown = true;
            this.notify();
        }

        public String getServerHeartBeatValue() {
            return String.valueOf(this.serverPing) + "," + String.valueOf(this.serverAcceptPing);
        }

        public void pinged() {
            this.lastPingTime.set(System.currentTimeMillis());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.lastAccepted.set(System.currentTimeMillis());
            this.pingFrame = StompFrameHandlerV11.this.createPingFrame();
            HeartBeater heartBeater = this;
            synchronized (heartBeater) {
                while (!this.shutdown) {
                    long dur1 = 0L;
                    long dur2 = 0L;
                    if (this.serverPing != 0L && (dur1 = System.currentTimeMillis() - this.lastPingTime.get()) >= this.serverPing) {
                        this.lastPingTime.set(System.currentTimeMillis());
                        StompFrameHandlerV11.this.connection.ping(this.pingFrame);
                        dur1 = 0L;
                    }
                    if (this.serverAcceptPing != 0L && (dur2 = System.currentTimeMillis() - this.lastAccepted.get()) > 2L * this.serverAcceptPing) {
                        StompFrameHandlerV11.this.connection.disconnect(false);
                        this.shutdown = true;
                        return;
                    }
                    long waitTime1 = 0L;
                    long waitTime2 = 0L;
                    if (this.serverPing > 0L) {
                        waitTime1 = this.serverPing - dur1;
                    }
                    if (this.serverAcceptPing > 0L) {
                        waitTime2 = this.serverAcceptPing * 2L - dur2;
                    }
                    long waitTime = 10L;
                    if (waitTime1 > 0L && waitTime2 > 0L) {
                        waitTime = Math.min(waitTime1, waitTime2);
                    } else if (waitTime1 > 0L) {
                        waitTime = waitTime1;
                    } else if (waitTime2 > 0L) {
                        waitTime = waitTime2;
                    }
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
        }

        public void pingAccepted() {
            this.lastAccepted.set(System.currentTimeMillis());
        }
    }
}

