/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import org.hornetq.core.protocol.stomp.HornetQStompException;
import org.hornetq.core.protocol.stomp.HornetQStompProtocolMessageBundle;
import org.hornetq.core.server.impl.ServerMessageImpl;

public class HornetQStompProtocolMessageBundle_$bundle
implements Serializable,
HornetQStompProtocolMessageBundle {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "HQ";
    public static final HornetQStompProtocolMessageBundle_$bundle INSTANCE = new HornetQStompProtocolMessageBundle_$bundle();
    private static final String nullHostHeader = "Header host is null";
    private static final String badCRs = "Invalid char sequence: There is a CR not followed by an LF";
    private static final String errorCreatSubscription = "Error creating subscription {0}";
    private static final String needIDorDestination = "Must specify the subscription's id or the destination you are unsubscribing from";
    private static final String errorUnsubscrib = "Error unsubscribing {0}";
    private static final String errorBeginTx = "Error beginning a transaction {0}";
    private static final String negativeConnectionTTL = "Stomp Connection TTL cannot be negative: {0}";
    private static final String noDestination = "Client must set destination or id header to a SUBSCRIBE command";
    private static final String headerTooBig = "Message header too big, increase minLargeMessageSize please.";
    private static final String failToAckMissingID = "failed to ack because no message with id: {0}";
    private static final String unknownCommand = "Unsupported command: {0}";
    private static final String versionNotSupported = "Stomp versions not supported: {0}";
    private static final String invalidCall = "This method should not be called";
    private static final String invalidFrame = "Invalid STOMP frame: {0}";
    private static final String hostNotMatchDetails = "host {0} doesn't match server host name";
    private static final String invalidTwoCRs = "Invalid char sequence: two consecutive CRs.";
    private static final String errorCommitTx = "Error committing {0}";
    private static final String errorAbortTx = "Error aborting {0}";
    private static final String errorHandleSend = "Error handling send";
    private static final String missingClientID = "Cannot create a subscriber on the durable subscription if the client-id of the connection is not set";
    private static final String subscriptionIDMismatch = "subscription id {0} does not match {1}";
    private static final String unexpectedNewLine = "Expect new line char but is {0}";
    private static final String needSubscriptionID = "Must specify the subscription's id";
    private static final String notValidNewLine = "Expect new line char but is {0}";
    private static final String hostCannotBeNull = "Cannot accept null as host";
    private static final String destinationNotExist = "Destination doesn't exist: {0}";
    private static final String abortTxNoID = "transaction header is mandatory to ABORT a transaction";
    private static final String errorGetSession = "Exception getting session";
    private static final String connectionDestroyed = "Connection was destroyed.";
    private static final String errorSendMessage = "Error sending message {0}";
    private static final String hostNotMatch = "Header host doesn't match server host";
    private static final String errorAck = "Error acknowledging message {0}";
    private static final String invalidCommand = "Invalid STOMP frame: {0}";
    private static final String beginTxNoID = "Need a transaction id to begin";
    private static final String noIDInAck = "No id header in ACK/NACK frame.";
    private static final String connectionNotEstablished = "Connection hasn't been established.";
    private static final String invalidConnection = "Connection is not valid.";
    private static final String needTxIDHeader = "transaction header is mandatory to COMMIT a transaction";

    protected HornetQStompProtocolMessageBundle_$bundle() {
    }

    protected HornetQStompProtocolMessageBundle_$bundle readResolve() {
        return INSTANCE;
    }

    @Override
    public final HornetQStompException nullHostHeader() {
        HornetQStompException result = new HornetQStompException("HQ339003: " + this.nullHostHeader$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullHostHeader$str() {
        return nullHostHeader;
    }

    @Override
    public final HornetQStompException badCRs() {
        HornetQStompException result = new HornetQStompException("HQ339020: " + this.badCRs$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String badCRs$str() {
        return badCRs;
    }

    @Override
    public final HornetQStompException errorCreatSubscription(String subscriptionID, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339016: " + this.errorCreatSubscription$str(), subscriptionID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCreatSubscription$str() {
        return errorCreatSubscription;
    }

    @Override
    public final HornetQStompException needIDorDestination() {
        HornetQStompException result = new HornetQStompException("HQ339035: " + this.needIDorDestination$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needIDorDestination$str() {
        return needIDorDestination;
    }

    @Override
    public final HornetQStompException errorUnsubscrib(String subscriptionID, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339017: " + this.errorUnsubscrib$str(), subscriptionID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorUnsubscrib$str() {
        return errorUnsubscrib;
    }

    @Override
    public final HornetQStompException errorBeginTx(String txID, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339012: " + this.errorBeginTx$str(), txID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorBeginTx$str() {
        return errorBeginTx;
    }

    @Override
    public final IllegalStateException negativeConnectionTTL(Long ttl) {
        IllegalStateException result = new IllegalStateException(MessageFormat.format("HQ339000: " + this.negativeConnectionTTL$str(), ttl));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String negativeConnectionTTL$str() {
        return negativeConnectionTTL;
    }

    @Override
    public final HornetQStompException noDestination() {
        HornetQStompException result = new HornetQStompException("HQ339015: " + this.noDestination$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDestination$str() {
        return noDestination;
    }

    @Override
    public final Exception headerTooBig() {
        Exception result = new Exception("HQ339028: " + this.headerTooBig$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String headerTooBig$str() {
        return headerTooBig;
    }

    @Override
    public final HornetQStompException failToAckMissingID(long id) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339025: " + this.failToAckMissingID$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToAckMissingID$str() {
        return failToAckMissingID;
    }

    @Override
    public final HornetQStompException unknownCommand(String command) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339029: " + this.unknownCommand$str(), command));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownCommand$str() {
        return unknownCommand;
    }

    @Override
    public final HornetQStompException versionNotSupported(String acceptVersion) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339002: " + this.versionNotSupported$str(), acceptVersion));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String versionNotSupported$str() {
        return versionNotSupported;
    }

    @Override
    public final IllegalStateException invalidCall() {
        IllegalStateException result = new IllegalStateException("HQ339034: " + this.invalidCall$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCall$str() {
        return invalidCall;
    }

    @Override
    public final String invalidFrame(String dumpByteArray) {
        String result = MessageFormat.format("HQ339024: " + this.invalidFrame$str(), dumpByteArray);
        return result;
    }

    protected String invalidFrame$str() {
        return "Invalid STOMP frame: {0}";
    }

    @Override
    public final String hostNotMatchDetails(String host) {
        String result = MessageFormat.format("HQ339006: " + this.hostNotMatchDetails$str(), host);
        return result;
    }

    protected String hostNotMatchDetails$str() {
        return hostNotMatchDetails;
    }

    @Override
    public final HornetQStompException invalidTwoCRs() {
        HornetQStompException result = new HornetQStompException("HQ339019: " + this.invalidTwoCRs$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidTwoCRs$str() {
        return invalidTwoCRs;
    }

    @Override
    public final HornetQStompException errorCommitTx(String txID, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339013: " + this.errorCommitTx$str(), txID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCommitTx$str() {
        return errorCommitTx;
    }

    @Override
    public final HornetQStompException errorAbortTx(String txID, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339014: " + this.errorAbortTx$str(), txID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorAbortTx$str() {
        return errorAbortTx;
    }

    @Override
    public final HornetQStompException errorHandleSend(Exception e) {
        HornetQStompException result = new HornetQStompException("HQ339031: " + this.errorHandleSend$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorHandleSend$str() {
        return errorHandleSend;
    }

    @Override
    public final IllegalStateException missingClientID() {
        IllegalStateException result = new IllegalStateException("HQ339027: " + this.missingClientID$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingClientID$str() {
        return missingClientID;
    }

    @Override
    public final HornetQStompException subscriptionIDMismatch(String subscriptionID, String actualID) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339026: " + this.subscriptionIDMismatch$str(), subscriptionID, actualID));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String subscriptionIDMismatch$str() {
        return subscriptionIDMismatch;
    }

    @Override
    public final String unexpectedNewLine(byte b) {
        String result = MessageFormat.format("HQ339022: " + this.unexpectedNewLine$str(), b);
        return result;
    }

    protected String unexpectedNewLine$str() {
        return "Expect new line char but is {0}";
    }

    @Override
    public final HornetQStompException needSubscriptionID() {
        HornetQStompException result = new HornetQStompException("HQ339037: " + this.needSubscriptionID$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needSubscriptionID$str() {
        return needSubscriptionID;
    }

    @Override
    public final HornetQStompException notValidNewLine(byte b) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339021: " + this.notValidNewLine$str(), b));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notValidNewLine$str() {
        return "Expect new line char but is {0}";
    }

    @Override
    public final String hostCannotBeNull() {
        String result = "HQ339004: " + this.hostCannotBeNull$str();
        return result;
    }

    protected String hostCannotBeNull$str() {
        return hostCannotBeNull;
    }

    @Override
    public final HornetQStompException destinationNotExist(String destination) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339001: " + this.destinationNotExist$str(), destination));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String destinationNotExist$str() {
        return destinationNotExist;
    }

    @Override
    public final HornetQStompException abortTxNoID() {
        HornetQStompException result = new HornetQStompException("HQ339033: " + this.abortTxNoID$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String abortTxNoID$str() {
        return abortTxNoID;
    }

    @Override
    public final HornetQStompException errorGetSession(Exception e) {
        HornetQStompException result = new HornetQStompException("HQ339009: " + this.errorGetSession$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorGetSession$str() {
        return errorGetSession;
    }

    @Override
    public final HornetQStompException connectionDestroyed() {
        HornetQStompException result = new HornetQStompException("HQ339007: " + this.connectionDestroyed$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionDestroyed$str() {
        return connectionDestroyed;
    }

    @Override
    public final HornetQStompException errorSendMessage(ServerMessageImpl message, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339011: " + this.errorSendMessage$str(), message), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorSendMessage$str() {
        return errorSendMessage;
    }

    @Override
    public final HornetQStompException hostNotMatch() {
        HornetQStompException result = new HornetQStompException("HQ339005: " + this.hostNotMatch$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hostNotMatch$str() {
        return hostNotMatch;
    }

    @Override
    public final HornetQStompException errorAck(String messageID, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339018: " + this.errorAck$str(), messageID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorAck$str() {
        return errorAck;
    }

    @Override
    public final HornetQStompException invalidCommand(String dumpByteArray) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format("HQ339023: " + this.invalidCommand$str(), dumpByteArray));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCommand$str() {
        return "Invalid STOMP frame: {0}";
    }

    @Override
    public final HornetQStompException beginTxNoID() {
        HornetQStompException result = new HornetQStompException("HQ339032: " + this.beginTxNoID$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String beginTxNoID$str() {
        return beginTxNoID;
    }

    @Override
    public final HornetQStompException noIDInAck() {
        HornetQStompException result = new HornetQStompException("HQ339039: " + this.noIDInAck$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noIDInAck$str() {
        return noIDInAck;
    }

    @Override
    public final HornetQStompException connectionNotEstablished() {
        HornetQStompException result = new HornetQStompException("HQ339008: " + this.connectionNotEstablished$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionNotEstablished$str() {
        return connectionNotEstablished;
    }

    @Override
    public final HornetQStompException invalidConnection() {
        HornetQStompException result = new HornetQStompException("HQ339010: " + this.invalidConnection$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConnection$str() {
        return invalidConnection;
    }

    @Override
    public final HornetQStompException needTxIDHeader() {
        HornetQStompException result = new HornetQStompException("HQ339030: " + this.needTxIDHeader$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needTxIDHeader$str() {
        return needTxIDHeader;
    }
}

