/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp.v12;

import org.hornetq.core.protocol.stomp.FrameEventListener;
import org.hornetq.core.protocol.stomp.HornetQStompException;
import org.hornetq.core.protocol.stomp.HornetQStompProtocolMessageBundle;
import org.hornetq.core.protocol.stomp.StompConnection;
import org.hornetq.core.protocol.stomp.StompDecoder;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.protocol.stomp.StompSubscription;
import org.hornetq.core.protocol.stomp.v11.StompFrameHandlerV11;
import org.hornetq.core.protocol.stomp.v11.StompFrameV11;
import org.hornetq.core.protocol.stomp.v12.StompFrameV12;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.ServerMessage;

public class StompFrameHandlerV12
extends StompFrameHandlerV11
implements FrameEventListener {
    public StompFrameHandlerV12(StompConnection connection) {
        super(connection);
        this.decoder = new StompDecoderV12();
        this.decoder.init();
    }

    @Override
    public StompFrame createStompFrame(String command) {
        return new StompFrameV12(command);
    }

    @Override
    public StompFrame createMessageFrame(ServerMessage serverMessage, StompSubscription subscription, int deliveryCount) throws Exception {
        StompFrame frame = super.createMessageFrame(serverMessage, subscription, deliveryCount);
        if (!subscription.getAck().equals("auto")) {
            frame.addHeader("ack", String.valueOf(serverMessage.getMessageID()));
        }
        return frame;
    }

    @Override
    public StompFrame onAck(StompFrame request) {
        StompFrame response = null;
        String messageID = request.getHeader("id");
        String txID = request.getHeader("transaction");
        if (txID != null) {
            HornetQServerLogger.LOGGER.stompTXAckNorSupported();
        }
        if (messageID == null) {
            HornetQStompException error = HornetQStompProtocolMessageBundle.BUNDLE.noIDInAck();
            error.setHandler(this.connection.getFrameHandler());
            return error.getFrame();
        }
        try {
            this.connection.acknowledge(messageID, null);
        }
        catch (HornetQStompException e) {
            response = e.getFrame();
        }
        return response;
    }

    protected class StompDecoderV12
    extends StompFrameHandlerV11.StompDecoderV11 {
        protected boolean nextEOLChar;

        public StompDecoderV12() {
            super(StompFrameHandlerV12.this);
            this.nextEOLChar = false;
            this.eolLen = 2;
        }

        @Override
        public void init() {
            super.init();
            this.nextEOLChar = false;
        }

        @Override
        protected void checkEol() throws HornetQStompException {
            if (this.workingBuffer[this.pos - 2] == 10) {
                --this.pos;
            } else if (this.workingBuffer[this.pos - 2] != 13) {
                this.throwInvalid();
            } else if (this.workingBuffer[this.pos - 1] != 10) {
                this.throwInvalid();
            }
        }

        @Override
        public void init(StompDecoder decoder) {
            this.data = decoder.data;
            this.workingBuffer = decoder.workingBuffer;
            this.pos = decoder.pos;
            this.command = decoder.command;
        }

        @Override
        protected boolean parseHeaders() throws HornetQStompException {
            block20: {
                do {
                    byte b = this.workingBuffer[this.pos++];
                    switch (b) {
                        case 92: {
                            if (this.isEscaping) {
                                this.holder.append(b);
                                this.isEscaping = false;
                                break;
                            }
                            this.isEscaping = true;
                            break;
                        }
                        case 58: {
                            if (this.isEscaping) {
                                this.holder.append(b);
                                this.isEscaping = false;
                            } else if (this.inHeaderName) {
                                this.headerName = this.holder.getString();
                                this.holder.reset();
                                this.inHeaderName = false;
                                this.headerValueWhitespace = true;
                            }
                            this.whiteSpaceOnly = false;
                            break;
                        }
                        case 110: {
                            if (this.isEscaping) {
                                this.holder.append((byte)10);
                                this.isEscaping = false;
                                break;
                            }
                            this.holder.append(b);
                            break;
                        }
                        case 114: {
                            if (this.isEscaping) {
                                this.holder.append((byte)13);
                                this.isEscaping = false;
                                break;
                            }
                            this.holder.append(b);
                            break;
                        }
                        case 13: {
                            if (this.nextEOLChar) {
                                throw HornetQStompProtocolMessageBundle.BUNDLE.invalidTwoCRs();
                            }
                            this.nextEOLChar = true;
                            break;
                        }
                        case 10: {
                            this.nextEOLChar = false;
                            if (this.whiteSpaceOnly) {
                                this.readingHeaders = false;
                                break block20;
                            }
                            String headerValue = this.holder.getString();
                            this.holder.reset();
                            if (!this.headers.containsKey(this.headerName)) {
                                this.headers.put(this.headerName, headerValue);
                            }
                            if (this.headerName.equals("content-length")) {
                                this.contentLength = Integer.parseInt(headerValue);
                            }
                            if (this.headerName.equals("content-type")) {
                                this.contentType = headerValue;
                            }
                            this.whiteSpaceOnly = true;
                            this.inHeaderName = true;
                            this.headerValueWhitespace = false;
                            break;
                        }
                        default: {
                            this.whiteSpaceOnly = false;
                            this.headerValueWhitespace = false;
                            this.holder.append(b);
                        }
                    }
                } while (this.pos != this.data);
                return false;
            }
            return true;
        }

        @Override
        protected StompFrame parseBody() throws HornetQStompException {
            byte[] content;
            block9: {
                block8: {
                    content = null;
                    if (this.contentLength == -1) break block8;
                    if (this.pos + this.contentLength + 1 > this.data) break block9;
                    content = new byte[this.contentLength];
                    System.arraycopy(this.workingBuffer, this.pos, content, 0, this.contentLength);
                    this.pos += this.contentLength;
                    if (this.bodyStart == -1) {
                        this.bodyStart = this.pos;
                    }
                    while (this.pos < this.data && this.workingBuffer[this.pos++] != 0) {
                    }
                    break block9;
                }
                if (this.bodyStart == -1) {
                    this.bodyStart = this.pos;
                }
                while (this.pos < this.data) {
                    if (this.workingBuffer[this.pos++] != 0) continue;
                    content = new byte[this.pos - this.bodyStart - 1];
                    System.arraycopy(this.workingBuffer, this.bodyStart, content, 0, content.length);
                    break;
                }
            }
            if (content != null) {
                if (this.data > this.pos) {
                    if (this.workingBuffer[this.pos] == 10) {
                        ++this.pos;
                    }
                    if (this.data > this.pos) {
                        System.arraycopy(this.workingBuffer, this.pos, this.workingBuffer, 0, this.data - this.pos);
                    }
                }
                this.data -= this.pos;
                StompFrameV11 ret = new StompFrameV11(this.command, this.headers, content);
                this.init();
                return ret;
            }
            return null;
        }
    }
}

