/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import org.hornetq.core.protocol.stomp.HornetQStompException;
import org.hornetq.core.protocol.stomp.HornetQStompProtocolMessageBundle;
import org.hornetq.core.server.impl.ServerMessageImpl;

public class HornetQStompProtocolMessageBundle_$bundle
implements Serializable,
HornetQStompProtocolMessageBundle {
    private static final long serialVersionUID = 1L;
    public static final HornetQStompProtocolMessageBundle_$bundle INSTANCE = new HornetQStompProtocolMessageBundle_$bundle();
    private static final String negativeConnectionTTL = "HQ339000: Stomp Connection TTL cannot be negative: {0}";
    private static final String destinationNotExist = "HQ339001: Destination does not exist: {0}";
    private static final String versionNotSupported = "HQ339002: Stomp versions not supported: {0}";
    private static final String nullHostHeader = "HQ339003: Header host is null";
    private static final String hostCannotBeNull = "HQ339004: Cannot accept null as host";
    private static final String hostNotMatch = "HQ339005: Header host does not match server host";
    private static final String hostNotMatchDetails = "HQ339006: host {0} does not match server host name";
    private static final String connectionDestroyed = "HQ339007: Connection was destroyed.";
    private static final String connectionNotEstablished = "HQ339008: Connection has not been established.";
    private static final String errorGetSession = "HQ339009: Exception getting session";
    private static final String invalidConnection = "HQ339010: Connection is not valid.";
    private static final String errorSendMessage = "HQ339011: Error sending message {0}";
    private static final String errorBeginTx = "HQ339012: Error beginning a transaction {0}";
    private static final String errorCommitTx = "HQ339013: Error committing {0}";
    private static final String errorAbortTx = "HQ339014: Error aborting {0}";
    private static final String noDestination = "HQ339015: Client must set destination or id header to a SUBSCRIBE command";
    private static final String errorCreatSubscription = "HQ339016: Error creating subscription {0}";
    private static final String errorUnsubscrib = "HQ339017: Error unsubscribing {0}";
    private static final String errorAck = "HQ339018: Error acknowledging message {0}";
    private static final String invalidTwoCRs = "HQ339019: Invalid char sequence: two consecutive CRs.";
    private static final String badCRs = "HQ339020: Invalid char sequence: There is a CR not followed by an LF";
    private static final String notValidNewLine = "HQ339021: Expect new line char but is {0}";
    private static final String unexpectedNewLine = "HQ339022: Expect new line char but is {0}";
    private static final String invalidCommand = "HQ339023: Invalid STOMP frame: {0}";
    private static final String invalidFrame = "HQ339024: Invalid STOMP frame: {0}";
    private static final String failToAckMissingID = "HQ339025: failed to ack because no message with id: {0}";
    private static final String subscriptionIDMismatch = "HQ339026: subscription id {0} does not match {1}";
    private static final String missingClientID = "HQ339027: Cannot create a subscriber on the durable subscription if the client-id of the connection is not set";
    private static final String headerTooBig = "HQ339028: Message header too big, increase minLargeMessageSize please.";
    private static final String unknownCommand = "HQ339029: Unsupported command: {0}";
    private static final String needTxIDHeader = "HQ339030: transaction header is mandatory to COMMIT a transaction";
    private static final String errorHandleSend = "HQ339031: Error handling send";
    private static final String beginTxNoID = "HQ339032: Need a transaction id to begin";
    private static final String abortTxNoID = "HQ339033: transaction header is mandatory to ABORT a transaction";
    private static final String invalidCall = "HQ339034: This method should not be called";
    private static final String needIDorDestination = "HQ339035: Must specify the subscription''s id or the destination you are unsubscribing from";
    private static final String needSubscriptionID = "HQ339037: Must specify the subscription''s id";
    private static final String noIDInAck = "HQ339039: No id header in ACK/NACK frame.";

    protected HornetQStompProtocolMessageBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public final IllegalStateException negativeConnectionTTL(Long ttl) {
        IllegalStateException result = new IllegalStateException(MessageFormat.format(this.negativeConnectionTTL$str(), ttl));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String negativeConnectionTTL$str() {
        return negativeConnectionTTL;
    }

    @Override
    public final HornetQStompException destinationNotExist(String destination) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.destinationNotExist$str(), destination));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String destinationNotExist$str() {
        return destinationNotExist;
    }

    @Override
    public final HornetQStompException versionNotSupported(String acceptVersion) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.versionNotSupported$str(), acceptVersion));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String versionNotSupported$str() {
        return versionNotSupported;
    }

    @Override
    public final HornetQStompException nullHostHeader() {
        HornetQStompException result = new HornetQStompException(this.nullHostHeader$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullHostHeader$str() {
        return nullHostHeader;
    }

    @Override
    public final String hostCannotBeNull() {
        String result = this.hostCannotBeNull$str();
        return result;
    }

    protected String hostCannotBeNull$str() {
        return hostCannotBeNull;
    }

    @Override
    public final HornetQStompException hostNotMatch() {
        HornetQStompException result = new HornetQStompException(this.hostNotMatch$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hostNotMatch$str() {
        return hostNotMatch;
    }

    @Override
    public final String hostNotMatchDetails(String host) {
        String result = MessageFormat.format(this.hostNotMatchDetails$str(), host);
        return result;
    }

    protected String hostNotMatchDetails$str() {
        return hostNotMatchDetails;
    }

    @Override
    public final HornetQStompException connectionDestroyed() {
        HornetQStompException result = new HornetQStompException(this.connectionDestroyed$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionDestroyed$str() {
        return connectionDestroyed;
    }

    @Override
    public final HornetQStompException connectionNotEstablished() {
        HornetQStompException result = new HornetQStompException(this.connectionNotEstablished$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionNotEstablished$str() {
        return connectionNotEstablished;
    }

    @Override
    public final HornetQStompException errorGetSession(Exception e) {
        HornetQStompException result = new HornetQStompException(this.errorGetSession$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorGetSession$str() {
        return errorGetSession;
    }

    @Override
    public final HornetQStompException invalidConnection() {
        HornetQStompException result = new HornetQStompException(this.invalidConnection$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConnection$str() {
        return invalidConnection;
    }

    @Override
    public final HornetQStompException errorSendMessage(ServerMessageImpl message, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.errorSendMessage$str(), message), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorSendMessage$str() {
        return errorSendMessage;
    }

    @Override
    public final HornetQStompException errorBeginTx(String txID, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.errorBeginTx$str(), txID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorBeginTx$str() {
        return errorBeginTx;
    }

    @Override
    public final HornetQStompException errorCommitTx(String txID, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.errorCommitTx$str(), txID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCommitTx$str() {
        return errorCommitTx;
    }

    @Override
    public final HornetQStompException errorAbortTx(String txID, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.errorAbortTx$str(), txID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorAbortTx$str() {
        return errorAbortTx;
    }

    @Override
    public final HornetQStompException noDestination() {
        HornetQStompException result = new HornetQStompException(this.noDestination$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDestination$str() {
        return noDestination;
    }

    @Override
    public final HornetQStompException errorCreatSubscription(String subscriptionID, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.errorCreatSubscription$str(), subscriptionID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCreatSubscription$str() {
        return errorCreatSubscription;
    }

    @Override
    public final HornetQStompException errorUnsubscrib(String subscriptionID, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.errorUnsubscrib$str(), subscriptionID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorUnsubscrib$str() {
        return errorUnsubscrib;
    }

    @Override
    public final HornetQStompException errorAck(String messageID, Exception e) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.errorAck$str(), messageID), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorAck$str() {
        return errorAck;
    }

    @Override
    public final HornetQStompException invalidTwoCRs() {
        HornetQStompException result = new HornetQStompException(this.invalidTwoCRs$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidTwoCRs$str() {
        return invalidTwoCRs;
    }

    @Override
    public final HornetQStompException badCRs() {
        HornetQStompException result = new HornetQStompException(this.badCRs$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String badCRs$str() {
        return badCRs;
    }

    @Override
    public final HornetQStompException notValidNewLine(byte b) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.notValidNewLine$str(), b));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notValidNewLine$str() {
        return notValidNewLine;
    }

    @Override
    public final String unexpectedNewLine(byte b) {
        String result = MessageFormat.format(this.unexpectedNewLine$str(), b);
        return result;
    }

    protected String unexpectedNewLine$str() {
        return unexpectedNewLine;
    }

    @Override
    public final HornetQStompException invalidCommand(String dumpByteArray) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.invalidCommand$str(), dumpByteArray));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCommand$str() {
        return invalidCommand;
    }

    @Override
    public final String invalidFrame(String dumpByteArray) {
        String result = MessageFormat.format(this.invalidFrame$str(), dumpByteArray);
        return result;
    }

    protected String invalidFrame$str() {
        return invalidFrame;
    }

    @Override
    public final HornetQStompException failToAckMissingID(long id) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.failToAckMissingID$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToAckMissingID$str() {
        return failToAckMissingID;
    }

    @Override
    public final HornetQStompException subscriptionIDMismatch(String subscriptionID, String actualID) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.subscriptionIDMismatch$str(), subscriptionID, actualID));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String subscriptionIDMismatch$str() {
        return subscriptionIDMismatch;
    }

    @Override
    public final IllegalStateException missingClientID() {
        IllegalStateException result = new IllegalStateException(this.missingClientID$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingClientID$str() {
        return missingClientID;
    }

    @Override
    public final Exception headerTooBig() {
        Exception result = new Exception(this.headerTooBig$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String headerTooBig$str() {
        return headerTooBig;
    }

    @Override
    public final HornetQStompException unknownCommand(String command) {
        HornetQStompException result = new HornetQStompException(MessageFormat.format(this.unknownCommand$str(), command));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownCommand$str() {
        return unknownCommand;
    }

    @Override
    public final HornetQStompException needTxIDHeader() {
        HornetQStompException result = new HornetQStompException(this.needTxIDHeader$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needTxIDHeader$str() {
        return needTxIDHeader;
    }

    @Override
    public final HornetQStompException errorHandleSend(Exception e) {
        HornetQStompException result = new HornetQStompException(this.errorHandleSend$str(), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorHandleSend$str() {
        return errorHandleSend;
    }

    @Override
    public final HornetQStompException beginTxNoID() {
        HornetQStompException result = new HornetQStompException(this.beginTxNoID$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String beginTxNoID$str() {
        return beginTxNoID;
    }

    @Override
    public final HornetQStompException abortTxNoID() {
        HornetQStompException result = new HornetQStompException(this.abortTxNoID$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String abortTxNoID$str() {
        return abortTxNoID;
    }

    @Override
    public final IllegalStateException invalidCall() {
        IllegalStateException result = new IllegalStateException(this.invalidCall$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCall$str() {
        return invalidCall;
    }

    @Override
    public final HornetQStompException needIDorDestination() {
        HornetQStompException result = new HornetQStompException(this.needIDorDestination$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needIDorDestination$str() {
        return needIDorDestination;
    }

    @Override
    public final HornetQStompException needSubscriptionID() {
        HornetQStompException result = new HornetQStompException(this.needSubscriptionID$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needSubscriptionID$str() {
        return needSubscriptionID;
    }

    @Override
    public final HornetQStompException noIDInAck() {
        HornetQStompException result = new HornetQStompException(this.noIDInAck$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noIDInAck$str() {
        return noIDInAck;
    }
}

