/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tools;

import org.hornetq.jms.persistence.impl.journal.XmlDataExporter;
import org.hornetq.jms.persistence.impl.journal.XmlDataImporter;
import org.hornetq.tools.DataTool;
import org.hornetq.tools.PrintData;
import org.hornetq.tools.PrintPages;
import org.hornetq.tools.TransferQueue;

public class Main {
    public static final String USAGE = "Use: java -jar " + Main.getJarName();
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private static final String PRINT_DATA = "print-data";
    private static final String PRINT_PAGES = "print-pages";
    private static final String DATA_TOOL = "data-tool";
    private static final String TRANSFER = "transfer-queue";
    private static final String OPTIONS = " [import|export|print-data|print-pages|data-tool|transfer-queue]";

    public static void main(String[] arg) throws Exception {
        if (arg.length == 0) {
            System.out.println(USAGE + OPTIONS);
            System.exit(-1);
        }
        if (TRANSFER.equals(arg[0])) {
            TransferQueue tool = new TransferQueue();
            tool.process(arg);
        } else if (DATA_TOOL.equals(arg[0])) {
            DataTool dataTool = new DataTool();
            dataTool.process(arg);
        } else if (EXPORT.equals(arg[0])) {
            if (arg.length != 5) {
                System.out.println(USAGE + " " + EXPORT + " <bindings-directory> <journal-directory> <paging-directory> <large-messages-directory>");
                System.exit(-1);
            } else {
                String[] mainArgs = new String[]{arg[1], arg[2], arg[3], arg[4]};
                XmlDataExporter.main((String[])mainArgs);
            }
        } else if (IMPORT.equals(arg[0])) {
            if (arg.length != 6) {
                System.out.println(USAGE + " " + IMPORT + " <input-file> <host> <port> <transactional> <application-server-compatibility>");
                System.exit(-1);
            } else {
                String[] mainArgs = new String[]{arg[1], arg[2], arg[3], arg[4], arg[5]};
                XmlDataImporter.main((String[])mainArgs);
            }
        } else if (PRINT_DATA.equals(arg[0])) {
            if (arg.length != 3) {
                System.err.println(USAGE + " " + PRINT_DATA + " <bindings-directory> <journal-directory>");
                System.exit(-1);
            }
            PrintData.printData(arg[1], arg[2]);
        } else if (PRINT_PAGES.equals(arg[0])) {
            if (arg.length != 3) {
                System.err.println(USAGE + " " + PRINT_PAGES + " <paging-directory> <journal-directory>");
                System.exit(-1);
            }
            PrintPages.printPages(arg[1], arg[2]);
        } else {
            System.out.println(USAGE + OPTIONS);
        }
    }

    protected static String getJarName() {
        try {
            Class<Main> klass = Main.class;
            String url = klass.getResource('/' + klass.getName().replace('.', '/') + ".class").toString();
            String jarName = url.substring(0, url.lastIndexOf(33));
            return jarName.substring(jarName.lastIndexOf(47) + 1);
        }
        catch (Throwable e) {
            return "tool-jar-name.jar";
        }
    }
}

