/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.PagingStoreFactory;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.impl.PagePositionImpl;
import org.hornetq.core.paging.impl.Page;
import org.hornetq.core.paging.impl.PageTransactionInfoImpl;
import org.hornetq.core.paging.impl.PagingManagerImpl;
import org.hornetq.core.paging.impl.PagingStoreFactoryNIO;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.persistence.impl.nullpm.NullStorageManager;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.settings.impl.HierarchicalObjectRepository;
import org.hornetq.utils.ExecutorFactory;

public class PrintPages {
    public static void main(String[] arg) {
        if (arg.length != 2) {
            System.err.println("Usage: PrintPages <page folder> <journal folder>");
            System.exit(-1);
        }
        try {
            SimpleString[] stores;
            PageCursorsInfo cursorACKs = PrintPages.loadCursorACKs(arg[1]);
            Set<Long> pgTXs = cursorACKs.getPgTXs();
            ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(1);
            final ExecutorService executor = Executors.newFixedThreadPool(10);
            ExecutorFactory execfactory = new ExecutorFactory(){

                public Executor getExecutor() {
                    return executor;
                }
            };
            NullStorageManager sm = new NullStorageManager();
            PagingStoreFactoryNIO pageStoreFactory = new PagingStoreFactoryNIO((StorageManager)sm, arg[0], 1000L, scheduled, execfactory, false, null);
            HierarchicalObjectRepository addressSettingsRepository = new HierarchicalObjectRepository();
            addressSettingsRepository.setDefault((Object)new AddressSettings());
            PagingManagerImpl manager = new PagingManagerImpl((PagingStoreFactory)pageStoreFactory, (HierarchicalRepository)addressSettingsRepository);
            manager.start();
            for (SimpleString store : stores = manager.getStoreNames()) {
                PagingStore pgStore = manager.getPageStore(store);
                String folder = null;
                if (pgStore != null) {
                    folder = pgStore.getFolder();
                }
                System.out.println("####################################################################################################");
                System.out.println("Exploring store " + store + " folder = " + folder);
                int pgid = (int)pgStore.getFirstPage();
                for (int pg = 0; pg < pgStore.getNumberOfPages(); ++pg) {
                    System.out.println("*******   Page " + pgid);
                    Page page = pgStore.createPage(pgid);
                    page.open();
                    List msgs = page.read((StorageManager)sm);
                    page.close();
                    int msgID = 0;
                    for (PagedMessage msg : msgs) {
                        msg.initMessage((StorageManager)sm);
                        System.out.print("pg=" + pgid + ", msg=" + msgID + ",pgTX=" + msg.getTransactionID() + ",userMessageID=" + (msg.getMessage().getUserID() != null ? msg.getMessage().getUserID() : "") + ", msg=" + msg.getMessage());
                        System.out.print(",Queues = ");
                        long[] q = msg.getQueueIDs();
                        for (int i = 0; i < q.length; ++i) {
                            System.out.print(q[i]);
                            PagePositionImpl posCheck = new PagePositionImpl((long)pgid, msgID);
                            boolean acked = false;
                            Set<PagePosition> positions = cursorACKs.getCursorRecords().get(q[i]);
                            if (positions != null) {
                                acked = positions.contains(posCheck);
                            }
                            if (acked) {
                                System.out.print(" (ACK)");
                            }
                            if (cursorACKs.getCompletePages(q[i]).contains(pgid)) {
                                System.out.println(" (PG-COMPLETE)");
                            }
                            if (i + 1 >= q.length) continue;
                            System.out.print(",");
                        }
                        if (msg.getTransactionID() >= 0L && !pgTXs.contains(msg.getTransactionID())) {
                            System.out.print(", **PG_TX_NOT_FOUND**");
                        }
                        System.out.println();
                        ++msgID;
                    }
                    ++pgid;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static PageCursorsInfo loadCursorACKs(String journalLocation) throws Exception {
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(journalLocation, null);
        ConfigurationImpl defaultValues = new ConfigurationImpl();
        JournalImpl messagesJournal = new JournalImpl(defaultValues.getJournalFileSize(), defaultValues.getJournalMinFiles(), 0, 0, (SequentialFileFactory)messagesFF, "hornetq-data", "hq", 1);
        messagesJournal.start();
        ArrayList records = new ArrayList();
        ArrayList txs = new ArrayList();
        messagesJournal.load(records, txs, null, false);
        PageCursorsInfo cursorInfo = new PageCursorsInfo();
        for (RecordInfo record : records) {
            JournalStorageManager.CursorAckRecordEncoding encoding;
            byte[] data = record.data;
            HornetQBuffer buff = HornetQBuffers.wrappedBuffer((byte[])data);
            if (record.userRecordType == 39) {
                encoding = new JournalStorageManager.CursorAckRecordEncoding();
                encoding.decode(buff);
                Set<PagePosition> set = cursorInfo.getCursorRecords().get(encoding.queueID);
                if (set == null) {
                    set = new HashSet<PagePosition>();
                    cursorInfo.getCursorRecords().put(encoding.queueID, set);
                }
                set.add(encoding.position);
                continue;
            }
            if (record.userRecordType == 42) {
                encoding = new JournalStorageManager.CursorAckRecordEncoding();
                encoding.decode(buff);
                Long queueID = encoding.queueID;
                Long pageNR = encoding.position.getPageNr();
                if (cursorInfo.getCompletePages(queueID).add(pageNR)) continue;
                System.err.println("Page " + pageNR + " has been already set as complete on queue " + queueID);
                continue;
            }
            if (record.userRecordType != 35) continue;
            if (record.isUpdate) {
                JournalStorageManager.PageUpdateTXEncoding pageUpdate = new JournalStorageManager.PageUpdateTXEncoding();
                pageUpdate.decode(buff);
                cursorInfo.getPgTXs().add(pageUpdate.pageTX);
                continue;
            }
            PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
            pageTransactionInfo.decode(buff);
            pageTransactionInfo.setRecordID(record.id);
            cursorInfo.getPgTXs().add(pageTransactionInfo.getTransactionID());
        }
        return cursorInfo;
    }

    private static class PageCursorsInfo {
        private final Map<Long, Set<PagePosition>> cursorRecords = new HashMap<Long, Set<PagePosition>>();
        private final Set<Long> pgTXs = new HashSet<Long>();
        private final Map<Long, Set<Long>> completePages = new HashMap<Long, Set<Long>>();

        public Set<Long> getPgTXs() {
            return this.pgTXs;
        }

        public Map<Long, Set<PagePosition>> getCursorRecords() {
            return this.cursorRecords;
        }

        public Map<Long, Set<Long>> getCompletePages() {
            return this.completePages;
        }

        public Set<Long> getCompletePages(Long queueID) {
            Set<Long> completePagesSet = this.completePages.get(queueID);
            if (completePagesSet == null) {
                completePagesSet = new HashSet<Long>();
                this.completePages.put(queueID, completePagesSet);
            }
            return completePagesSet;
        }
    }
}

