/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tools;

import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.journal.Journal;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.TransactionFailureCallback;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.core.message.BodyEncoder;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.PagingStoreFactory;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.impl.PagePositionImpl;
import org.hornetq.core.paging.impl.Page;
import org.hornetq.core.paging.impl.PageTransactionInfoImpl;
import org.hornetq.core.paging.impl.PagingManagerImpl;
import org.hornetq.core.paging.impl.PagingStoreFactoryNIO;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.persistence.impl.journal.DescribeJournal;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.settings.impl.HierarchicalObjectRepository;
import org.hornetq.jms.persistence.config.PersistedConnectionFactory;
import org.hornetq.jms.persistence.config.PersistedDestination;
import org.hornetq.jms.persistence.config.PersistedJNDI;
import org.hornetq.jms.persistence.config.PersistedType;
import org.hornetq.utils.Base64;
import org.hornetq.utils.ExecutorFactory;

public final class XmlDataExporter {
    private static final Long LARGE_MESSAGE_CHUNK_SIZE = 1000L;
    private final JournalStorageManager storageManager;
    private final Configuration config;
    private final XMLStreamWriter xmlWriter;
    private final Map<Long, HashMap<Long, DescribeJournal.ReferenceDescribe>> messageRefs;
    private final HashMap<Long, Message> messages;
    private final Map<Long, Set<PagePosition>> cursorRecords;
    private final Set<Long> pgTXs;
    final HashMap<Long, JournalStorageManager.PersistentQueueBindingEncoding> queueBindings;
    private final Map<String, PersistedConnectionFactory> jmsConnectionFactories = new ConcurrentHashMap<String, PersistedConnectionFactory>();
    private final Map<Pair<PersistedType, String>, PersistedDestination> jmsDestinations = new ConcurrentHashMap<Pair<PersistedType, String>, PersistedDestination>();
    private final Map<Pair<PersistedType, String>, PersistedJNDI> jmsJNDI = new ConcurrentHashMap<Pair<PersistedType, String>, PersistedJNDI>();
    long messagesPrinted = 0L;
    long bindingsPrinted = 0L;

    public XmlDataExporter(OutputStream out, String bindingsDir, String journalDir, String pagingDir, String largeMessagesDir) throws Exception {
        this.config = new ConfigurationImpl().setBindingsDirectory(bindingsDir).setJournalDirectory(journalDir).setPagingDirectory(pagingDir).setLargeMessagesDirectory(largeMessagesDir).setJournalType(JournalType.NIO);
        final ExecutorService executor = Executors.newFixedThreadPool(1);
        ExecutorFactory executorFactory = new ExecutorFactory(){

            public Executor getExecutor() {
                return executor;
            }
        };
        this.storageManager = new JournalStorageManager(this.config, executorFactory);
        this.messageRefs = new HashMap<Long, HashMap<Long, DescribeJournal.ReferenceDescribe>>();
        this.messages = new HashMap();
        this.cursorRecords = new HashMap<Long, Set<PagePosition>>();
        this.pgTXs = new HashSet<Long>();
        this.queueBindings = new HashMap();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter rawXmlWriter = factory.createXMLStreamWriter(out, "UTF-8");
        PrettyPrintHandler handler = new PrettyPrintHandler(rawXmlWriter);
        this.xmlWriter = (XMLStreamWriter)Proxy.newProxyInstance(XMLStreamWriter.class.getClassLoader(), new Class[]{XMLStreamWriter.class}, (InvocationHandler)handler);
    }

    public void writeXMLData() throws Exception {
        long start = System.currentTimeMillis();
        this.getBindings();
        this.getJmsBindings();
        this.processMessageJournal();
        this.printDataAsXML();
        HornetQServerLogger.LOGGER.debug((Object)("\n\nProcessing took: " + (System.currentTimeMillis() - start) + "ms"));
        HornetQServerLogger.LOGGER.debug((Object)("Output " + this.messagesPrinted + " messages and " + this.bindingsPrinted + " bindings."));
    }

    private void processMessageJournal() throws Exception {
        ArrayList<RecordInfo> acks = new ArrayList<RecordInfo>();
        LinkedList records = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        Journal messageJournal = this.storageManager.getMessageJournal();
        HornetQServerLogger.LOGGER.debug((Object)("Reading journal from " + this.config.getJournalDirectory()));
        messageJournal.start();
        TransactionFailureCallback transactionFailureCallback = new TransactionFailureCallback(){

            public void failedTransaction(long transactionID, List<RecordInfo> records1, List<RecordInfo> recordsToDelete) {
                int i;
                StringBuilder message = new StringBuilder();
                message.append("Encountered failed journal transaction: ").append(transactionID);
                for (i = 0; i < records1.size(); ++i) {
                    if (i == 0) {
                        message.append("; Records: ");
                    }
                    message.append(records1.get(i));
                    if (i == records1.size() - 1) continue;
                    message.append(", ");
                }
                for (i = 0; i < recordsToDelete.size(); ++i) {
                    if (i == 0) {
                        message.append("; RecordsToDelete: ");
                    }
                    message.append(recordsToDelete.get(i));
                    if (i == recordsToDelete.size() - 1) continue;
                    message.append(", ");
                }
                HornetQServerLogger.LOGGER.debug((Object)message.toString());
            }
        };
        ((JournalImpl)messageJournal).load(records, preparedTransactions, transactionFailureCallback, false);
        preparedTransactions = null;
        for (RecordInfo info : records) {
            byte[] data = info.data;
            HornetQBuffer buff = HornetQBuffers.wrappedBuffer((byte[])data);
            Object o = DescribeJournal.newObjectEncoding((RecordInfo)info, (JournalStorageManager)this.storageManager);
            if (info.getUserRecordType() == 31) {
                this.messages.put(info.id, ((DescribeJournal.MessageDescribe)o).getMsg());
                continue;
            }
            if (info.getUserRecordType() == 30) {
                this.messages.put(info.id, ((DescribeJournal.MessageDescribe)o).getMsg());
                continue;
            }
            if (info.getUserRecordType() == 32) {
                DescribeJournal.ReferenceDescribe ref = (DescribeJournal.ReferenceDescribe)o;
                HashMap<Long, DescribeJournal.ReferenceDescribe> map = this.messageRefs.get(info.id);
                if (map == null) {
                    HashMap<Long, DescribeJournal.ReferenceDescribe> newMap = new HashMap<Long, DescribeJournal.ReferenceDescribe>();
                    newMap.put(ref.refEncoding.queueID, ref);
                    this.messageRefs.put(info.id, newMap);
                    continue;
                }
                map.put(ref.refEncoding.queueID, ref);
                continue;
            }
            if (info.getUserRecordType() == 33) {
                acks.add(info);
                continue;
            }
            if (info.userRecordType == 39) {
                JournalStorageManager.CursorAckRecordEncoding encoding = new JournalStorageManager.CursorAckRecordEncoding();
                encoding.decode(buff);
                Set<PagePosition> set = this.cursorRecords.get(encoding.queueID);
                if (set == null) {
                    set = new HashSet<PagePosition>();
                    this.cursorRecords.put(encoding.queueID, set);
                }
                set.add(encoding.position);
                continue;
            }
            if (info.userRecordType != 35) continue;
            if (info.isUpdate) {
                JournalStorageManager.PageUpdateTXEncoding pageUpdate = new JournalStorageManager.PageUpdateTXEncoding();
                pageUpdate.decode(buff);
                this.pgTXs.add(pageUpdate.pageTX);
                continue;
            }
            PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
            pageTransactionInfo.decode(buff);
            pageTransactionInfo.setRecordID(info.id);
            this.pgTXs.add(pageTransactionInfo.getTransactionID());
        }
        messageJournal.stop();
        this.removeAcked(acks);
    }

    private void removeAcked(ArrayList<RecordInfo> acks) {
        for (RecordInfo info : acks) {
            JournalStorageManager.AckDescribe ack = (JournalStorageManager.AckDescribe)DescribeJournal.newObjectEncoding((RecordInfo)info, null);
            HashMap<Long, DescribeJournal.ReferenceDescribe> referenceDescribeHashMap = this.messageRefs.get(info.id);
            referenceDescribeHashMap.remove(ack.refEncoding.queueID);
            if (referenceDescribeHashMap.size() != 0) continue;
            this.messages.remove(info.id);
            this.messageRefs.remove(info.id);
        }
    }

    private void getJmsBindings() throws Exception {
        NIOSequentialFileFactory bindingsJMS = new NIOSequentialFileFactory(this.config.getBindingsDirectory());
        JournalImpl jmsJournal = new JournalImpl(0x100000, 2, this.config.getJournalCompactMinFiles(), this.config.getJournalCompactPercentage(), (SequentialFileFactory)bindingsJMS, "hornetq-jms", "jms", 1);
        jmsJournal.start();
        ArrayList data = new ArrayList();
        ArrayList list = new ArrayList();
        HornetQServerLogger.LOGGER.debug((Object)("Reading jms bindings journal from " + this.config.getBindingsDirectory()));
        jmsJournal.load(data, list, null);
        for (RecordInfo record : data) {
            long id = record.id;
            HornetQBuffer buffer = HornetQBuffers.wrappedBuffer((byte[])record.data);
            byte rec = record.getUserRecordType();
            if (rec == 1) {
                PersistedConnectionFactory cf = new PersistedConnectionFactory();
                cf.decode(buffer);
                cf.setId(id);
                HornetQServerLogger.LOGGER.info((Object)("Found JMS connection factory: " + cf.getName()));
                this.jmsConnectionFactories.put(cf.getName(), cf);
                continue;
            }
            if (rec == 2) {
                PersistedDestination destination = new PersistedDestination();
                destination.decode(buffer);
                destination.setId(id);
                HornetQServerLogger.LOGGER.info((Object)("Found JMS destination: " + destination.getName()));
                this.jmsDestinations.put((Pair<PersistedType, String>)new Pair((Object)destination.getType(), (Object)destination.getName()), destination);
                continue;
            }
            if (rec == 3) {
                PersistedJNDI jndi = new PersistedJNDI();
                jndi.decode(buffer);
                jndi.setId(id);
                Pair key = new Pair((Object)jndi.getType(), (Object)jndi.getName());
                StringBuilder builder = new StringBuilder();
                for (String binding : jndi.getJndi()) {
                    builder.append(binding).append(" ");
                }
                HornetQServerLogger.LOGGER.info((Object)("Found JMS JNDI binding data for " + jndi.getType() + " " + jndi.getName() + ": " + builder.toString()));
                this.jmsJNDI.put((Pair<PersistedType, String>)key, jndi);
                continue;
            }
            throw new IllegalStateException("Invalid record type " + rec);
        }
    }

    private void getBindings() throws Exception {
        LinkedList records = new LinkedList();
        Journal bindingsJournal = this.storageManager.getBindingsJournal();
        bindingsJournal.start();
        HornetQServerLogger.LOGGER.debug((Object)("Reading bindings journal from " + this.config.getBindingsDirectory()));
        ((JournalImpl)bindingsJournal).load(records, null, null, false);
        for (RecordInfo info : records) {
            if (info.getUserRecordType() != 21) continue;
            JournalStorageManager.PersistentQueueBindingEncoding bindingEncoding = (JournalStorageManager.PersistentQueueBindingEncoding)DescribeJournal.newObjectEncoding((RecordInfo)info, null);
            this.queueBindings.put(bindingEncoding.getId(), bindingEncoding);
        }
        bindingsJournal.stop();
    }

    private void printDataAsXML() {
        try {
            this.xmlWriter.writeStartDocument("1.0");
            this.xmlWriter.writeStartElement("hornetq-journal");
            this.printBindingsAsXML();
            this.printJmsConnectionFactoriesAsXML();
            this.printJmsDestinationsAsXML();
            this.printAllMessagesAsXML();
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeEndDocument();
            this.xmlWriter.flush();
            this.xmlWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printBindingsAsXML() throws XMLStreamException {
        this.xmlWriter.writeStartElement("bindings");
        for (Map.Entry<Long, JournalStorageManager.PersistentQueueBindingEncoding> queueBindingEncodingEntry : this.queueBindings.entrySet()) {
            JournalStorageManager.PersistentQueueBindingEncoding bindingEncoding = this.queueBindings.get(queueBindingEncodingEntry.getKey());
            this.xmlWriter.writeEmptyElement("binding");
            this.xmlWriter.writeAttribute("address", bindingEncoding.getAddress().toString());
            String filter = "";
            if (bindingEncoding.getFilterString() != null) {
                filter = bindingEncoding.getFilterString().toString();
            }
            this.xmlWriter.writeAttribute("filter-string", filter);
            this.xmlWriter.writeAttribute("queue-name", bindingEncoding.getQueueName().toString());
            this.xmlWriter.writeAttribute("id", Long.toString(bindingEncoding.getId()));
            ++this.bindingsPrinted;
        }
        this.xmlWriter.writeEndElement();
    }

    private void printJmsConnectionFactoriesAsXML() throws XMLStreamException {
        this.xmlWriter.writeStartElement("jms-connection-factories");
        for (String jmsConnectionFactoryKey : this.jmsConnectionFactories.keySet()) {
            this.xmlWriter.writeStartElement("jms-connection-factory");
            PersistedConnectionFactory jmsConnectionFactory = this.jmsConnectionFactories.get(jmsConnectionFactoryKey);
            this.xmlWriter.writeStartElement("name");
            this.xmlWriter.writeCharacters(jmsConnectionFactory.getName());
            this.xmlWriter.writeEndElement();
            String clientID = jmsConnectionFactory.getConfig().getClientID();
            if (clientID != null) {
                this.xmlWriter.writeStartElement("client-id");
                this.xmlWriter.writeCharacters(clientID);
                this.xmlWriter.writeEndElement();
            }
            long callFailoverTimeout = jmsConnectionFactory.getConfig().getCallFailoverTimeout();
            this.xmlWriter.writeStartElement("call-failover-timeout");
            this.xmlWriter.writeCharacters(Long.toString(callFailoverTimeout));
            this.xmlWriter.writeEndElement();
            long callTimeout = jmsConnectionFactory.getConfig().getCallTimeout();
            this.xmlWriter.writeStartElement("call-timeout");
            this.xmlWriter.writeCharacters(Long.toString(callTimeout));
            this.xmlWriter.writeEndElement();
            long clientFailureCheckPeriod = jmsConnectionFactory.getConfig().getClientFailureCheckPeriod();
            this.xmlWriter.writeStartElement("client-failure-check-period");
            this.xmlWriter.writeCharacters(Long.toString(clientFailureCheckPeriod));
            this.xmlWriter.writeEndElement();
            int confirmationWindowSize = jmsConnectionFactory.getConfig().getConfirmationWindowSize();
            this.xmlWriter.writeStartElement("confirmation-window-size");
            this.xmlWriter.writeCharacters(Integer.toString(confirmationWindowSize));
            this.xmlWriter.writeEndElement();
            long connectionTTL = jmsConnectionFactory.getConfig().getConnectionTTL();
            this.xmlWriter.writeStartElement("connection-ttl");
            this.xmlWriter.writeCharacters(Long.toString(connectionTTL));
            this.xmlWriter.writeEndElement();
            long consumerMaxRate = jmsConnectionFactory.getConfig().getConsumerMaxRate();
            this.xmlWriter.writeStartElement("consumer-max-rate");
            this.xmlWriter.writeCharacters(Long.toString(consumerMaxRate));
            this.xmlWriter.writeEndElement();
            long consumerWindowSize = jmsConnectionFactory.getConfig().getConsumerWindowSize();
            this.xmlWriter.writeStartElement("consumer-window-size");
            this.xmlWriter.writeCharacters(Long.toString(consumerWindowSize));
            this.xmlWriter.writeEndElement();
            String discoveryGroupName = jmsConnectionFactory.getConfig().getDiscoveryGroupName();
            if (discoveryGroupName != null) {
                this.xmlWriter.writeStartElement("discovery-group-name");
                this.xmlWriter.writeCharacters(discoveryGroupName);
                this.xmlWriter.writeEndElement();
            }
            int dupsOKBatchSize = jmsConnectionFactory.getConfig().getDupsOKBatchSize();
            this.xmlWriter.writeStartElement("dups-ok-batch-size");
            this.xmlWriter.writeCharacters(Integer.toString(dupsOKBatchSize));
            this.xmlWriter.writeEndElement();
            JMSFactoryType factoryType = jmsConnectionFactory.getConfig().getFactoryType();
            this.xmlWriter.writeStartElement("type");
            this.xmlWriter.writeCharacters(Integer.toString(factoryType.intValue()));
            this.xmlWriter.writeEndElement();
            String groupID = jmsConnectionFactory.getConfig().getGroupID();
            if (groupID != null) {
                this.xmlWriter.writeStartElement("group-id");
                this.xmlWriter.writeCharacters(groupID);
                this.xmlWriter.writeEndElement();
            }
            String loadBalancingPolicyClassName = jmsConnectionFactory.getConfig().getLoadBalancingPolicyClassName();
            this.xmlWriter.writeStartElement("load-balancing-policy-class-name");
            this.xmlWriter.writeCharacters(loadBalancingPolicyClassName);
            this.xmlWriter.writeEndElement();
            long maxRetryInterval = jmsConnectionFactory.getConfig().getMaxRetryInterval();
            this.xmlWriter.writeStartElement("max-retry-interval");
            this.xmlWriter.writeCharacters(Long.toString(maxRetryInterval));
            this.xmlWriter.writeEndElement();
            long minLargeMessageSize = jmsConnectionFactory.getConfig().getMinLargeMessageSize();
            this.xmlWriter.writeStartElement("min-large-message-size");
            this.xmlWriter.writeCharacters(Long.toString(minLargeMessageSize));
            this.xmlWriter.writeEndElement();
            long producerMaxRate = jmsConnectionFactory.getConfig().getProducerMaxRate();
            this.xmlWriter.writeStartElement("producer-max-rate");
            this.xmlWriter.writeCharacters(Long.toString(producerMaxRate));
            this.xmlWriter.writeEndElement();
            long producerWindowSize = jmsConnectionFactory.getConfig().getProducerWindowSize();
            this.xmlWriter.writeStartElement("producer-window-size");
            this.xmlWriter.writeCharacters(Long.toString(producerWindowSize));
            this.xmlWriter.writeEndElement();
            long reconnectAttempts = jmsConnectionFactory.getConfig().getReconnectAttempts();
            this.xmlWriter.writeStartElement("reconnect-attempts");
            this.xmlWriter.writeCharacters(Long.toString(reconnectAttempts));
            this.xmlWriter.writeEndElement();
            long retryInterval = jmsConnectionFactory.getConfig().getRetryInterval();
            this.xmlWriter.writeStartElement("retry-interval");
            this.xmlWriter.writeCharacters(Long.toString(retryInterval));
            this.xmlWriter.writeEndElement();
            double retryIntervalMultiplier = jmsConnectionFactory.getConfig().getRetryIntervalMultiplier();
            this.xmlWriter.writeStartElement("retry-interval-multiplier");
            this.xmlWriter.writeCharacters(Double.toString(retryIntervalMultiplier));
            this.xmlWriter.writeEndElement();
            long scheduledThreadPoolMaxSize = jmsConnectionFactory.getConfig().getScheduledThreadPoolMaxSize();
            this.xmlWriter.writeStartElement("scheduled-thread-pool-max-size");
            this.xmlWriter.writeCharacters(Long.toString(scheduledThreadPoolMaxSize));
            this.xmlWriter.writeEndElement();
            long threadPoolMaxSize = jmsConnectionFactory.getConfig().getThreadPoolMaxSize();
            this.xmlWriter.writeStartElement("thread-pool-max-size");
            this.xmlWriter.writeCharacters(Long.toString(threadPoolMaxSize));
            this.xmlWriter.writeEndElement();
            long transactionBatchSize = jmsConnectionFactory.getConfig().getTransactionBatchSize();
            this.xmlWriter.writeStartElement("transaction-batch-size");
            this.xmlWriter.writeCharacters(Long.toString(transactionBatchSize));
            this.xmlWriter.writeEndElement();
            boolean autoGroup = jmsConnectionFactory.getConfig().isAutoGroup();
            this.xmlWriter.writeStartElement("auto-group");
            this.xmlWriter.writeCharacters(Boolean.toString(autoGroup));
            this.xmlWriter.writeEndElement();
            boolean blockOnAcknowledge = jmsConnectionFactory.getConfig().isBlockOnAcknowledge();
            this.xmlWriter.writeStartElement("block-on-acknowledge");
            this.xmlWriter.writeCharacters(Boolean.toString(blockOnAcknowledge));
            this.xmlWriter.writeEndElement();
            boolean blockOnDurableSend = jmsConnectionFactory.getConfig().isBlockOnDurableSend();
            this.xmlWriter.writeStartElement("block-on-durable-send");
            this.xmlWriter.writeCharacters(Boolean.toString(blockOnDurableSend));
            this.xmlWriter.writeEndElement();
            boolean blockOnNonDurableSend = jmsConnectionFactory.getConfig().isBlockOnNonDurableSend();
            this.xmlWriter.writeStartElement("block-on-non-durable-send");
            this.xmlWriter.writeCharacters(Boolean.toString(blockOnNonDurableSend));
            this.xmlWriter.writeEndElement();
            boolean cacheLargeMessagesClient = jmsConnectionFactory.getConfig().isCacheLargeMessagesClient();
            this.xmlWriter.writeStartElement("cache-large-messages-client");
            this.xmlWriter.writeCharacters(Boolean.toString(cacheLargeMessagesClient));
            this.xmlWriter.writeEndElement();
            boolean compressLargeMessages = jmsConnectionFactory.getConfig().isCompressLargeMessages();
            this.xmlWriter.writeStartElement("compress-large-messages");
            this.xmlWriter.writeCharacters(Boolean.toString(compressLargeMessages));
            this.xmlWriter.writeEndElement();
            boolean failoverOnInitialConnection = jmsConnectionFactory.getConfig().isFailoverOnInitialConnection();
            this.xmlWriter.writeStartElement("failover-on-initial-connection");
            this.xmlWriter.writeCharacters(Boolean.toString(failoverOnInitialConnection));
            this.xmlWriter.writeEndElement();
            boolean ha = jmsConnectionFactory.getConfig().isHA();
            this.xmlWriter.writeStartElement("ha");
            this.xmlWriter.writeCharacters(Boolean.toString(ha));
            this.xmlWriter.writeEndElement();
            boolean preAcknowledge = jmsConnectionFactory.getConfig().isPreAcknowledge();
            this.xmlWriter.writeStartElement("preacknowledge");
            this.xmlWriter.writeCharacters(Boolean.toString(preAcknowledge));
            this.xmlWriter.writeEndElement();
            boolean useGlobalPools = jmsConnectionFactory.getConfig().isUseGlobalPools();
            this.xmlWriter.writeStartElement("use-global-pools");
            this.xmlWriter.writeCharacters(Boolean.toString(useGlobalPools));
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeStartElement("connectors");
            for (String connector : jmsConnectionFactory.getConfig().getConnectorNames()) {
                this.xmlWriter.writeStartElement("connector");
                this.xmlWriter.writeCharacters(connector);
                this.xmlWriter.writeEndElement();
            }
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeStartElement("entries");
            PersistedJNDI jndi = this.jmsJNDI.get(new Pair((Object)PersistedType.ConnectionFactory, (Object)jmsConnectionFactory.getName()));
            for (String jndiEntry : jndi.getJndi()) {
                this.xmlWriter.writeStartElement("entry");
                this.xmlWriter.writeCharacters(jndiEntry);
                this.xmlWriter.writeEndElement();
            }
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeEndElement();
        }
        this.xmlWriter.writeEndElement();
    }

    private void printJmsDestinationsAsXML() throws XMLStreamException {
        this.xmlWriter.writeStartElement("jms-destinations");
        for (Pair<PersistedType, String> jmsDestinationsKey : this.jmsDestinations.keySet()) {
            PersistedDestination jmsDestination = this.jmsDestinations.get(jmsDestinationsKey);
            this.xmlWriter.writeStartElement("jms-destination");
            this.xmlWriter.writeStartElement("name");
            this.xmlWriter.writeCharacters(jmsDestination.getName());
            this.xmlWriter.writeEndElement();
            String selector = jmsDestination.getSelector();
            if (selector != null && selector.length() != 0) {
                this.xmlWriter.writeStartElement("selector");
                this.xmlWriter.writeCharacters(selector);
                this.xmlWriter.writeEndElement();
            }
            this.xmlWriter.writeStartElement("type");
            this.xmlWriter.writeCharacters(jmsDestination.getType().toString());
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeStartElement("entries");
            PersistedJNDI jndi = this.jmsJNDI.get(new Pair((Object)jmsDestination.getType(), (Object)jmsDestination.getName()));
            for (String jndiEntry : jndi.getJndi()) {
                this.xmlWriter.writeStartElement("entry");
                this.xmlWriter.writeCharacters(jndiEntry);
                this.xmlWriter.writeEndElement();
            }
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeEndElement();
        }
        this.xmlWriter.writeEndElement();
    }

    private void printAllMessagesAsXML() throws XMLStreamException {
        this.xmlWriter.writeStartElement("messages");
        for (Map.Entry<Long, Message> messageMapEntry : this.messages.entrySet()) {
            this.printSingleMessageAsXML((ServerMessage)messageMapEntry.getValue(), this.extractQueueNames(this.messageRefs.get(messageMapEntry.getKey())));
        }
        this.printPagedMessagesAsXML();
        this.xmlWriter.writeEndElement();
    }

    private void printPagedMessagesAsXML() {
        try {
            SimpleString[] stores;
            ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(1);
            final ExecutorService executor = Executors.newFixedThreadPool(10);
            ExecutorFactory executorFactory = new ExecutorFactory(){

                public Executor getExecutor() {
                    return executor;
                }
            };
            PagingStoreFactoryNIO pageStoreFactory = new PagingStoreFactoryNIO((StorageManager)this.storageManager, this.config.getPagingDirectory(), 1000L, scheduled, executorFactory, true, null);
            HierarchicalObjectRepository addressSettingsRepository = new HierarchicalObjectRepository();
            addressSettingsRepository.setDefault((Object)new AddressSettings());
            PagingManagerImpl manager = new PagingManagerImpl((PagingStoreFactory)pageStoreFactory, (HierarchicalRepository)addressSettingsRepository);
            manager.start();
            for (SimpleString store : stores = manager.getStoreNames()) {
                PagingStore pageStore = manager.getPageStore(store);
                if (pageStore != null) {
                    String folder = pageStore.getFolder();
                    HornetQServerLogger.LOGGER.debug((Object)("Reading page store " + store + " folder = " + folder));
                    int pageId = (int)pageStore.getFirstPage();
                    for (int i = 0; i < pageStore.getNumberOfPages(); ++i) {
                        HornetQServerLogger.LOGGER.debug((Object)("Reading page " + pageId));
                        Page page = pageStore.createPage(pageId);
                        page.open();
                        List messages = page.read((StorageManager)this.storageManager);
                        page.close();
                        int messageId = 0;
                        for (PagedMessage message : messages) {
                            message.initMessage((StorageManager)this.storageManager);
                            long[] queueIDs = message.getQueueIDs();
                            ArrayList<String> queueNames = new ArrayList<String>();
                            for (long queueID : queueIDs) {
                                JournalStorageManager.PersistentQueueBindingEncoding queueBinding;
                                PagePositionImpl posCheck = new PagePositionImpl((long)pageId, messageId);
                                boolean acked = false;
                                Set<PagePosition> positions = this.cursorRecords.get(queueID);
                                if (positions != null) {
                                    acked = positions.contains(posCheck);
                                }
                                if (acked || (queueBinding = this.queueBindings.get(queueID)) == null) continue;
                                SimpleString queueName = queueBinding.getQueueName();
                                queueNames.add(queueName.toString());
                            }
                            if (queueNames.size() > 0 && (message.getTransactionID() == -1L || this.pgTXs.contains(message.getTransactionID()))) {
                                this.printSingleMessageAsXML(message.getMessage(), queueNames);
                            }
                            ++messageId;
                        }
                        ++pageId;
                    }
                    continue;
                }
                HornetQServerLogger.LOGGER.debug((Object)"Page store was null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printSingleMessageAsXML(ServerMessage message, List<String> queues) throws XMLStreamException {
        this.xmlWriter.writeStartElement("message");
        this.printMessageAttributes(message);
        this.printMessageProperties(message);
        this.printMessageQueues(queues);
        this.printMessageBody(message);
        this.xmlWriter.writeEndElement();
        ++this.messagesPrinted;
    }

    private void printMessageBody(ServerMessage message) throws XMLStreamException {
        this.xmlWriter.writeStartElement("body");
        if (message.isLargeMessage()) {
            this.printLargeMessageBody((LargeServerMessage)message);
        } else {
            int size = message.getEndOfBodyPosition() - message.getBodyBuffer().readerIndex();
            byte[] buffer = new byte[size];
            message.getBodyBuffer().readBytes(buffer);
            this.xmlWriter.writeCData(XmlDataExporter.encode(buffer));
        }
        this.xmlWriter.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printLargeMessageBody(LargeServerMessage message) throws XMLStreamException {
        this.xmlWriter.writeAttribute("isLarge", Boolean.TRUE.toString());
        BodyEncoder encoder = null;
        try {
            encoder = message.getBodyEncoder();
            encoder.open();
            long totalBytesWritten = 0L;
            long bodySize = encoder.getLargeBodySize();
            for (long i = 0L; i < bodySize; i += LARGE_MESSAGE_CHUNK_SIZE.longValue()) {
                Long remainder = bodySize - totalBytesWritten;
                Long bufferSize = remainder >= LARGE_MESSAGE_CHUNK_SIZE ? LARGE_MESSAGE_CHUNK_SIZE : remainder;
                HornetQBuffer buffer = HornetQBuffers.fixedBuffer((int)bufferSize.intValue());
                encoder.encode(buffer, bufferSize.intValue());
                this.xmlWriter.writeCData(XmlDataExporter.encode(buffer.toByteBuffer().array()));
                totalBytesWritten += bufferSize.longValue();
            }
            encoder.close();
        }
        catch (HornetQException e) {
            e.printStackTrace();
        }
        finally {
            if (encoder != null) {
                try {
                    encoder.close();
                }
                catch (HornetQException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void printMessageQueues(List<String> queues) throws XMLStreamException {
        this.xmlWriter.writeStartElement("queues");
        for (String queueName : queues) {
            this.xmlWriter.writeEmptyElement("queue");
            this.xmlWriter.writeAttribute("name", queueName);
        }
        this.xmlWriter.writeEndElement();
    }

    private void printMessageProperties(ServerMessage message) throws XMLStreamException {
        this.xmlWriter.writeStartElement("properties");
        for (SimpleString key : message.getPropertyNames()) {
            Object value = message.getObjectProperty(key);
            this.xmlWriter.writeEmptyElement("property");
            this.xmlWriter.writeAttribute("name", key.toString());
            if (value instanceof byte[]) {
                this.xmlWriter.writeAttribute("value", XmlDataExporter.encode((byte[])value));
            } else {
                this.xmlWriter.writeAttribute("value", value == null ? "_HQ_NULL" : value.toString());
            }
            if (value instanceof Boolean) {
                this.xmlWriter.writeAttribute("type", "boolean");
                continue;
            }
            if (value instanceof Byte) {
                this.xmlWriter.writeAttribute("type", "byte");
                continue;
            }
            if (value instanceof Short) {
                this.xmlWriter.writeAttribute("type", "short");
                continue;
            }
            if (value instanceof Integer) {
                this.xmlWriter.writeAttribute("type", "integer");
                continue;
            }
            if (value instanceof Long) {
                this.xmlWriter.writeAttribute("type", "long");
                continue;
            }
            if (value instanceof Float) {
                this.xmlWriter.writeAttribute("type", "float");
                continue;
            }
            if (value instanceof Double) {
                this.xmlWriter.writeAttribute("type", "double");
                continue;
            }
            if (value instanceof String) {
                this.xmlWriter.writeAttribute("type", "string");
                continue;
            }
            if (value instanceof SimpleString) {
                this.xmlWriter.writeAttribute("type", "simple-string");
                continue;
            }
            if (!(value instanceof byte[])) continue;
            this.xmlWriter.writeAttribute("type", "bytes");
        }
        this.xmlWriter.writeEndElement();
    }

    private void printMessageAttributes(ServerMessage message) throws XMLStreamException {
        this.xmlWriter.writeAttribute("id", Long.toString(message.getMessageID()));
        this.xmlWriter.writeAttribute("priority", Byte.toString(message.getPriority()));
        this.xmlWriter.writeAttribute("expiration", Long.toString(message.getExpiration()));
        this.xmlWriter.writeAttribute("timestamp", Long.toString(message.getTimestamp()));
        byte rawType = message.getType();
        String prettyType = "default";
        if (rawType == 4) {
            prettyType = "bytes";
        } else if (rawType == 5) {
            prettyType = "map";
        } else if (rawType == 2) {
            prettyType = "object";
        } else if (rawType == 6) {
            prettyType = "stream";
        } else if (rawType == 3) {
            prettyType = "text";
        }
        this.xmlWriter.writeAttribute("type", prettyType);
        if (message.getUserID() != null) {
            this.xmlWriter.writeAttribute("user-id", message.getUserID().toString());
        }
    }

    private List<String> extractQueueNames(HashMap<Long, DescribeJournal.ReferenceDescribe> refMap) {
        ArrayList<String> queues = new ArrayList<String>();
        for (DescribeJournal.ReferenceDescribe ref : refMap.values()) {
            queues.add(this.queueBindings.get(ref.refEncoding.queueID).getQueueName().toString());
        }
        return queues;
    }

    private static String encode(byte[] data) {
        return Base64.encodeBytes((byte[])data, (int)0, (int)data.length, (int)24);
    }

    static class PrettyPrintHandler
    implements InvocationHandler {
        private final XMLStreamWriter target;
        private int depth = 0;
        private static final char INDENT_CHAR = ' ';
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        boolean wrap = true;

        public PrettyPrintHandler(XMLStreamWriter target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String m;
            switch (m = method.getName()) {
                case "writeStartElement": {
                    this.target.writeCharacters(LINE_SEPARATOR);
                    this.target.writeCharacters(this.indent(this.depth));
                    ++this.depth;
                    break;
                }
                case "writeEndElement": {
                    --this.depth;
                    if (this.wrap) {
                        this.target.writeCharacters(LINE_SEPARATOR);
                        this.target.writeCharacters(this.indent(this.depth));
                    }
                    this.wrap = true;
                    break;
                }
                case "writeEmptyElement": 
                case "writeCData": {
                    this.target.writeCharacters(LINE_SEPARATOR);
                    this.target.writeCharacters(this.indent(this.depth));
                    break;
                }
                case "writeCharacters": {
                    this.wrap = false;
                }
            }
            method.invoke((Object)this.target, args);
            return null;
        }

        private String indent(int depth) {
            char[] output = new char[depth *= 3];
            while (depth-- > 0) {
                output[depth] = 32;
            }
            return new String(output);
        }
    }
}

