/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.transports.netty;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.hornetq.integration.transports.netty.HornetQFrameDecoder2;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.ssl.SslHandler;

public class ChannelPipelineSupport {
    private ChannelPipelineSupport() {
    }

    public static void addCodecFilter(ChannelPipeline pipeline, BufferHandler handler) {
        assert (pipeline != null);
        pipeline.addLast("decoder", (ChannelHandler)new HornetQFrameDecoder2());
    }

    public static void addSSLFilter(ChannelPipeline pipeline, SSLContext context, boolean client) throws Exception {
        SSLEngine engine = context.createSSLEngine();
        engine.setUseClientMode(client);
        if (client) {
            engine.setWantClientAuth(true);
        }
        SslHandler handler = new SslHandler(engine);
        pipeline.addLast("ssl", (ChannelHandler)handler);
    }
}

