/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.transports.netty;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.core.buffers.impl.ChannelBufferWrapper;
import org.hornetq.core.logging.Logger;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.ssl.SslHandler;

public class NettyConnection
implements Connection {
    private static final Logger log = Logger.getLogger(NettyConnection.class);
    private static final int BATCHING_BUFFER_SIZE = 8192;
    private final Channel channel;
    private boolean closed;
    private final ConnectionLifeCycleListener listener;
    private final boolean batchingEnabled;
    private HornetQBuffer batchBuffer;
    private final Object writeLock = new Object();

    public NettyConnection(Channel channel, ConnectionLifeCycleListener listener, boolean batchingEnabled) {
        this.channel = channel;
        this.listener = listener;
        this.batchingEnabled = batchingEnabled;
        listener.connectionCreated((Connection)this, ProtocolType.CORE);
    }

    public synchronized void close() {
        ChannelFuture closeFuture;
        if (this.closed) {
            return;
        }
        SslHandler sslHandler = (SslHandler)this.channel.getPipeline().get("ssl");
        if (sslHandler != null) {
            try {
                ChannelFuture sslCloseFuture = sslHandler.close(this.channel);
                if (!sslCloseFuture.awaitUninterruptibly(10000L)) {
                    log.warn((Object)"Timed out waiting for ssl close future to complete");
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (!(closeFuture = this.channel.close()).awaitUninterruptibly(10000L)) {
            log.warn((Object)"Timed out waiting for channel to close");
        }
        this.closed = true;
        this.listener.connectionDestroyed(this.getID());
    }

    public HornetQBuffer createBuffer(int size) {
        return new ChannelBufferWrapper(ChannelBuffers.dynamicBuffer((int)size));
    }

    public Object getID() {
        return this.channel.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFlushBatchBuffer() {
        Object object = this.writeLock;
        synchronized (object) {
            if (!this.batchingEnabled) {
                return;
            }
            if (this.batchBuffer != null && this.batchBuffer.readable()) {
                this.channel.write((Object)this.batchBuffer.channelBuffer());
                this.batchBuffer = HornetQBuffers.dynamicBuffer((int)8192);
            }
        }
    }

    public void write(HornetQBuffer buffer) {
        this.write(buffer, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(HornetQBuffer buffer, boolean flush, boolean batched) {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.batchBuffer == null && this.batchingEnabled && batched && !flush) {
                this.batchBuffer = HornetQBuffers.dynamicBuffer((int)8192);
            }
            if (this.batchBuffer != null) {
                this.batchBuffer.writeBytes(buffer, 0, buffer.writerIndex());
                if (this.batchBuffer.writerIndex() < 8192 && batched && !flush) {
                    return;
                }
                buffer = this.batchBuffer;
                this.batchBuffer = !batched || flush ? null : HornetQBuffers.dynamicBuffer((int)8192);
            }
            ChannelFuture future = this.channel.write((Object)buffer.channelBuffer());
            if (flush) {
                while (true) {
                    try {
                        boolean ok = future.await(10000L);
                        if (ok) break;
                        log.warn((Object)"Timed out waiting for packet to be flushed");
                    }
                    catch (InterruptedException ignore) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public String getRemoteAddress() {
        return this.channel.getRemoteAddress().toString();
    }

    public String toString() {
        return super.toString() + "[local= " + this.channel.getLocalAddress() + ", remote=" + this.channel.getRemoteAddress() + "]";
    }
}

