/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.transports.netty;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hornetq.spi.core.protocol.ProtocolType;

public class TransportConstants {
    public static final String SSL_ENABLED_PROP_NAME = "ssl-enabled";
    public static final String HTTP_ENABLED_PROP_NAME = "http-enabled";
    public static final String HTTP_CLIENT_IDLE_PROP_NAME = "http-client-idle-time";
    public static final String HTTP_CLIENT_IDLE_SCAN_PERIOD = "http-client-idle-scan-period";
    public static final String HTTP_RESPONSE_TIME_PROP_NAME = "http-response-time";
    public static final String HTTP_SERVER_SCAN_PERIOD_PROP_NAME = "http-server-scan-period";
    public static final String HTTP_REQUIRES_SESSION_ID = "http-requires-session-id";
    public static final String USE_SERVLET_PROP_NAME = "use-servlet";
    public static final String SERVLET_PATH = "servlet-path";
    public static final String USE_NIO_PROP_NAME = "use-nio";
    public static final String USE_INVM_PROP_NAME = "use-invm";
    public static final String PROTOCOL_PROP_NAME = "protocol";
    public static final String HOST_PROP_NAME = "host";
    public static final String PORT_PROP_NAME = "port";
    public static final String KEYSTORE_PATH_PROP_NAME = "key-store-path";
    public static final String KEYSTORE_PASSWORD_PROP_NAME = "key-store-password";
    public static final String TRUSTSTORE_PATH_PROP_NAME = "trust-store-path";
    public static final String TRUSTSTORE_PASSWORD_PROP_NAME = "trust-store-password";
    public static final String TCP_NODELAY_PROPNAME = "tcp-no-delay";
    public static final String TCP_SENDBUFFER_SIZE_PROPNAME = "tcp-send-buffer-size";
    public static final String TCP_RECEIVEBUFFER_SIZE_PROPNAME = "tcp-receive-buffer-size";
    public static final String NIO_REMOTING_THREADS_PROPNAME = "nio-remoting-threads";
    public static final String BATCH_DELAY = "batch-delay";
    public static final boolean DEFAULT_SSL_ENABLED = false;
    public static final boolean DEFAULT_USE_NIO_SERVER = false;
    public static final boolean DEFAULT_USE_NIO_CLIENT = false;
    public static final boolean DEFAULT_USE_INVM = false;
    public static final boolean DEFAULT_USE_SERVLET = false;
    public static final String DEFAULT_PROTOCOL = ProtocolType.CORE.toString();
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 5445;
    public static final int DEFAULT_STOMP_PORT = 61613;
    public static final String DEFAULT_KEYSTORE_PATH = "hornetq.keystore";
    public static final String DEFAULT_KEYSTORE_PASSWORD = "secureexample";
    public static final String DEFAULT_TRUSTSTORE_PATH = "hornetq.truststore";
    public static final String DEFAULT_TRUSTSTORE_PASSWORD = "secureexample";
    public static final boolean DEFAULT_TCP_NODELAY = true;
    public static final int DEFAULT_TCP_SENDBUFFER_SIZE = 32768;
    public static final int DEFAULT_TCP_RECEIVEBUFFER_SIZE = 32768;
    public static final boolean DEFAULT_HTTP_ENABLED = false;
    public static final long DEFAULT_HTTP_CLIENT_IDLE_TIME = 500L;
    public static final long DEFAULT_HTTP_CLIENT_SCAN_PERIOD = 500L;
    public static final long DEFAULT_HTTP_RESPONSE_TIME = 10000L;
    public static final long DEFAULT_HTTP_SERVER_SCAN_PERIOD = 5000L;
    public static final boolean DEFAULT_HTTP_REQUIRES_SESSION_ID = false;
    public static final String DEFAULT_SERVLET_PATH = "/messaging/HornetQServlet";
    public static final long DEFAULT_BATCH_DELAY = 0L;
    public static final Set<String> ALLOWABLE_CONNECTOR_KEYS;
    public static final Set<String> ALLOWABLE_ACCEPTOR_KEYS;

    static {
        HashSet<String> allowableAcceptorKeys = new HashSet<String>();
        allowableAcceptorKeys.add(SSL_ENABLED_PROP_NAME);
        allowableAcceptorKeys.add(HTTP_ENABLED_PROP_NAME);
        allowableAcceptorKeys.add(HTTP_RESPONSE_TIME_PROP_NAME);
        allowableAcceptorKeys.add(HTTP_SERVER_SCAN_PERIOD_PROP_NAME);
        allowableAcceptorKeys.add(USE_NIO_PROP_NAME);
        allowableAcceptorKeys.add(USE_INVM_PROP_NAME);
        allowableAcceptorKeys.add(PROTOCOL_PROP_NAME);
        allowableAcceptorKeys.add(HOST_PROP_NAME);
        allowableAcceptorKeys.add(PORT_PROP_NAME);
        allowableAcceptorKeys.add(KEYSTORE_PATH_PROP_NAME);
        allowableAcceptorKeys.add(KEYSTORE_PASSWORD_PROP_NAME);
        allowableAcceptorKeys.add(TRUSTSTORE_PATH_PROP_NAME);
        allowableAcceptorKeys.add(TRUSTSTORE_PASSWORD_PROP_NAME);
        allowableAcceptorKeys.add(TCP_NODELAY_PROPNAME);
        allowableAcceptorKeys.add(TCP_SENDBUFFER_SIZE_PROPNAME);
        allowableAcceptorKeys.add(TCP_RECEIVEBUFFER_SIZE_PROPNAME);
        allowableAcceptorKeys.add(NIO_REMOTING_THREADS_PROPNAME);
        allowableAcceptorKeys.add(BATCH_DELAY);
        ALLOWABLE_ACCEPTOR_KEYS = Collections.unmodifiableSet(allowableAcceptorKeys);
        HashSet<String> allowableConnectorKeys = new HashSet<String>();
        allowableConnectorKeys.add(SSL_ENABLED_PROP_NAME);
        allowableConnectorKeys.add(HTTP_ENABLED_PROP_NAME);
        allowableConnectorKeys.add(HTTP_CLIENT_IDLE_PROP_NAME);
        allowableConnectorKeys.add(HTTP_CLIENT_IDLE_SCAN_PERIOD);
        allowableConnectorKeys.add(HTTP_REQUIRES_SESSION_ID);
        allowableConnectorKeys.add(USE_SERVLET_PROP_NAME);
        allowableConnectorKeys.add(SERVLET_PATH);
        allowableConnectorKeys.add(USE_NIO_PROP_NAME);
        allowableConnectorKeys.add(HOST_PROP_NAME);
        allowableConnectorKeys.add(PORT_PROP_NAME);
        allowableConnectorKeys.add(KEYSTORE_PATH_PROP_NAME);
        allowableConnectorKeys.add(KEYSTORE_PASSWORD_PROP_NAME);
        allowableConnectorKeys.add(TCP_NODELAY_PROPNAME);
        allowableConnectorKeys.add(TCP_SENDBUFFER_SIZE_PROPNAME);
        allowableConnectorKeys.add(TCP_RECEIVEBUFFER_SIZE_PROPNAME);
        allowableConnectorKeys.add(NIO_REMOTING_THREADS_PROPNAME);
        allowableConnectorKeys.add(BATCH_DELAY);
        ALLOWABLE_CONNECTOR_KEYS = Collections.unmodifiableSet(allowableConnectorKeys);
    }
}

